/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Lathe")
@ModOnly(value={"gregtech"})
public class Lathe {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, null, input, durationTicks, euPerTick));
    }

    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, IItemStack input, int durationTicks, int euPerTick) {
        if (outputs.length == 0) {
            MineTweakerAPI.logError((String)"Lathe recipe requires at least 1 input");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(outputs[0], outputs.length > 1 ? outputs[1] : null, input, durationTicks, euPerTick));
        }
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack output1;
        private final IItemStack output2;
        private final IItemStack input;
        private final int duration;
        private final int euPerTick;

        public AddRecipeAction(IItemStack output1, IItemStack output2, IItemStack input, int duration, int euPerTick) {
            this.output1 = output1;
            this.output2 = output2;
            this.input = input;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        public void apply() {
            GT_Values.RA.addLatheRecipe(MineTweakerMC.getItemStack((IItemStack)this.input), MineTweakerMC.getItemStack((IItemStack)this.output1), MineTweakerMC.getItemStack((IItemStack)this.output2), this.duration, this.euPerTick);
        }

        public String describe() {
            return "Adding lathe recipe for " + this.output1;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 5;
            hash = 53 * hash + (this.output1 != null ? this.output1.hashCode() : 0);
            hash = 53 * hash + (this.output2 != null ? this.output2.hashCode() : 0);
            hash = 53 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 53 * hash + this.duration;
            hash = 53 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)((Object)obj);
            if (!(this.output1 == other.output1 || this.output1 != null && this.output1.equals(other.output1))) {
                return false;
            }
            if (!(this.output2 == other.output2 || this.output2 != null && this.output2.equals(other.output2))) {
                return false;
            }
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }
}

