/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Mixer")
@ModOnly(value={"gregtech"})
public class Mixer {
    @ZenMethod
    public static void addRecipe(IItemStack output, ILiquidStack fluidOutput, IItemStack[] input, ILiquidStack fluidInput, int durationTicks, int euPerTick) {
        if (input.length == 0) {
            MineTweakerAPI.logError((String)"Lathe recipe requires at least 1 input");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddFluidRecipeAction(output, fluidOutput, input, fluidInput, durationTicks, euPerTick));
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack[] input, int durationTicks, int euPerTick) {
        if (input.length == 0) {
            MineTweakerAPI.logError((String)"Lathe recipe requires at least 1 input");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, null, input, null, durationTicks, euPerTick));
        }
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack output;
        private final ILiquidStack fluidOutput;
        private final IItemStack[] input;
        private final ILiquidStack fluidInput;
        private final int duration;
        private final int euPerTick;

        public AddRecipeAction(IItemStack output, ILiquidStack fluidOutput, IItemStack[] input, ILiquidStack fluidInput, int duration, int euPerTick) {
            this.output = output;
            this.fluidOutput = fluidOutput;
            this.input = input;
            this.fluidInput = fluidInput;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        public void apply() {
            GT_Values.RA.addMixerRecipe(MineTweakerMC.getItemStack((IItemStack)this.input[0]), this.input.length > 1 ? MineTweakerMC.getItemStack((IItemStack)this.input[1]) : null, this.input.length > 2 ? MineTweakerMC.getItemStack((IItemStack)this.input[2]) : null, this.input.length > 3 ? MineTweakerMC.getItemStack((IItemStack)this.input[3]) : null, MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidInput), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidOutput), MineTweakerMC.getItemStack((IItemStack)this.output), this.duration, this.euPerTick);
        }

        public String describe() {
            return "Adding Mixer recipe for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 1;
            hash = 17 * hash + (this.output != null ? this.output.hashCode() : 0);
            hash = 17 * hash + (this.fluidOutput != null ? this.fluidOutput.hashCode() : 0);
            hash = 17 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 17 * hash + (this.fluidInput != null ? this.fluidInput.hashCode() : 0);
            hash = 17 * hash + this.duration;
            hash = 17 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)((Object)obj);
            if (!(this.output == other.output || this.output != null && this.output.equals(other.output))) {
                return false;
            }
            if (!(this.fluidOutput == other.fluidOutput || this.fluidOutput != null && this.fluidOutput.equals(other.fluidOutput))) {
                return false;
            }
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            if (!(this.fluidInput == other.fluidInput || this.fluidInput != null && this.fluidInput.equals(other.fluidInput))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }

    private static class AddFluidRecipeAction
    extends OneWayAction {
        private final IItemStack output;
        private final ILiquidStack fluidOutput;
        private final IItemStack[] input;
        private final ILiquidStack fluidInput;
        private final int duration;
        private final int euPerTick;

        public AddFluidRecipeAction(IItemStack output, ILiquidStack fluidOutput, IItemStack[] input, ILiquidStack fluidInput, int duration, int euPerTick) {
            this.output = output;
            this.fluidOutput = fluidOutput;
            this.input = input;
            this.fluidInput = fluidInput;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        public void apply() {
            GT_Values.RA.addMixerRecipe(MineTweakerMC.getItemStack((IItemStack)this.input[0]), this.input.length > 1 ? MineTweakerMC.getItemStack((IItemStack)this.input[1]) : null, this.input.length > 2 ? MineTweakerMC.getItemStack((IItemStack)this.input[2]) : null, this.input.length > 3 ? MineTweakerMC.getItemStack((IItemStack)this.input[3]) : null, MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidInput), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidOutput), MineTweakerMC.getItemStack((IItemStack)this.output), this.duration, this.euPerTick);
        }

        public String describe() {
            return "Adding Mixer recipe for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 6;
            hash = 67 * hash + (this.output != null ? this.output.hashCode() : 0);
            hash = 67 * hash + (this.fluidOutput != null ? this.fluidOutput.hashCode() : 0);
            hash = 67 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 67 * hash + (this.fluidInput != null ? this.fluidInput.hashCode() : 0);
            hash = 67 * hash + this.duration;
            hash = 67 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddFluidRecipeAction other = (AddFluidRecipeAction)((Object)obj);
            if (!(this.output == other.output || this.output != null && this.output.equals(other.output))) {
                return false;
            }
            if (!(this.fluidOutput == other.fluidOutput || this.fluidOutput != null && this.fluidOutput.equals(other.fluidOutput))) {
                return false;
            }
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            if (!(this.fluidInput == other.fluidInput || this.fluidInput != null && this.fluidInput.equals(other.fluidInput))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }
}

