/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import java.util.Arrays;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Centrifuge")
@ModOnly(value={"gregtech"})
public class Centrifuge {
    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, ILiquidStack fluidOutput, IItemStack input, IItemStack cells, ILiquidStack fluidInput, int[] chances, int durationTicks, int euPerTick) {
        if (outputs.length < 1) {
            MineTweakerAPI.logError((String)"Centrifuge must have at least 1 output");
        } else if (outputs.length != chances.length) {
            MineTweakerAPI.logError((String)"Number of Outputs does not equal number of Chances");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddFluidRecipeAction(outputs, fluidOutput, input, cells, fluidInput, chances, durationTicks, euPerTick));
        }
    }

    @ZenMethod
    public static void addRecipeFuelCan(IItemStack[] outputs, IItemStack input, int numCans, int duration) {
        if (outputs.length < 1) {
            MineTweakerAPI.logError((String)"centrifuge must have at least 1 output");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(outputs, input, -numCans, duration));
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, IItemStack input, int cells, int durationTicks) {
        if (outputs.length < 1) {
            MineTweakerAPI.logError((String)"centrifuge must have at least 1 output");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(outputs, input, cells, durationTicks));
        }
    }

    private static class AddFluidRecipeAction
    extends OneWayAction {
        private final IItemStack[] outputs;
        private final ILiquidStack fluidOutput;
        private final IItemStack input;
        private final IItemStack cells;
        private final ILiquidStack fluidInput;
        private final int[] chances;
        private final int duration;
        private final int euPerTick;

        public AddFluidRecipeAction(IItemStack[] outputs, ILiquidStack fluidOutput, IItemStack input, IItemStack cells, ILiquidStack fluidInput, int[] chances, int duration, int euPerTick) {
            this.outputs = outputs;
            this.fluidOutput = fluidOutput;
            this.input = input;
            this.cells = cells;
            this.fluidInput = fluidInput;
            this.chances = chances;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        public void apply() {
            GT_Values.RA.addCentrifugeRecipe(MineTweakerMC.getItemStack((IItemStack)this.input), MineTweakerMC.getItemStack((IItemStack)this.cells), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidOutput), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidInput), MineTweakerMC.getItemStack((IItemStack)this.outputs[0]), this.outputs.length > 1 ? MineTweakerMC.getItemStack((IItemStack)this.outputs[1]) : null, this.outputs.length > 2 ? MineTweakerMC.getItemStack((IItemStack)this.outputs[2]) : null, this.outputs.length > 3 ? MineTweakerMC.getItemStack((IItemStack)this.outputs[3]) : null, this.outputs.length > 4 ? MineTweakerMC.getItemStack((IItemStack)this.outputs[4]) : null, this.outputs.length > 5 ? MineTweakerMC.getItemStack((IItemStack)this.outputs[5]) : null, this.chances, this.duration, this.euPerTick);
        }

        public String describe() {
            return "Adding Centrifuge recipe with Fluids for " + this.input;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 6;
            hash = 55 * hash + (this.outputs != null ? this.outputs.hashCode() : 0);
            hash = 55 * hash + (this.fluidOutput != null ? this.fluidOutput.hashCode() : 0);
            hash = 55 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 55 * hash + (this.cells != null ? this.cells.hashCode() : 0);
            hash = 55 * hash + (this.fluidInput != null ? this.fluidInput.hashCode() : 0);
            hash = 55 * hash + this.duration;
            hash = 55 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddFluidRecipeAction other = (AddFluidRecipeAction)((Object)obj);
            if (!(this.outputs == other.outputs || this.outputs != null && this.outputs.equals(other.outputs))) {
                return false;
            }
            if (!(this.fluidOutput == other.fluidOutput || this.fluidOutput != null && this.fluidOutput.equals(other.fluidOutput))) {
                return false;
            }
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            if (!(this.cells == other.cells || this.cells != null && this.cells.equals(other.cells))) {
                return false;
            }
            if (!(this.fluidInput == other.fluidInput || this.fluidInput != null && this.fluidInput.equals(other.fluidInput))) {
                return false;
            }
            if (this.chances != other.chances) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack[] output;
        private final IItemStack input;
        private final int cells;
        private final int duration;

        public AddRecipeAction(IItemStack[] output, IItemStack input, int cells, int duration) {
            this.output = output;
            this.input = input;
            this.cells = cells;
            this.duration = duration;
        }

        public void apply() {
            GT_Values.RA.addCentrifugeRecipe(MineTweakerMC.getItemStack((IItemStack)this.input), this.cells, MineTweakerMC.getItemStack((IItemStack)this.output[0]), this.output.length > 1 ? MineTweakerMC.getItemStack((IItemStack)this.output[1]) : null, this.output.length > 2 ? MineTweakerMC.getItemStack((IItemStack)this.output[2]) : null, this.output.length > 3 ? MineTweakerMC.getItemStack((IItemStack)this.output[3]) : null, this.output.length > 4 ? MineTweakerMC.getItemStack((IItemStack)this.output[4]) : null, this.output.length > 5 ? MineTweakerMC.getItemStack((IItemStack)this.output[5]) : null, this.duration);
        }

        public String describe() {
            return "Adding centrifuge recipe with input " + this.input;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + Arrays.deepHashCode(this.output);
            hash = 59 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 59 * hash + this.cells;
            hash = 59 * hash + this.duration;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)((Object)obj);
            if (!Arrays.deepEquals(this.output, other.output)) {
                return false;
            }
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            if (this.cells != other.cells) {
                return false;
            }
            return this.duration == other.duration;
        }
    }
}

