/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.FluidExtractor")
@ModOnly(value={"gregtech"})
public class FluidExtractor {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input, ILiquidStack fluidOutput, int durationTicks, int euPerTick, int chance) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, input, fluidOutput, durationTicks, euPerTick, chance));
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack output;
        private final IItemStack input;
        private final ILiquidStack fluidOutput;
        private final int duration;
        private final int euPerTick;
        private final int chance;

        public AddRecipeAction(IItemStack output, IItemStack input, ILiquidStack fluidOutput, int duration, int euPerTick, int chance) {
            this.output = output;
            this.input = input;
            this.fluidOutput = fluidOutput;
            this.duration = duration;
            this.euPerTick = euPerTick;
            this.chance = chance;
        }

        public void apply() {
            GT_Values.RA.addFluidExtractionRecipe(MineTweakerMC.getItemStack((IItemStack)this.input), MineTweakerMC.getItemStack((IItemStack)this.output), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidOutput), this.duration, this.euPerTick, this.chance);
        }

        public String describe() {
            return "Adding Fluid Extractor recipe for " + this.input;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 3;
            hash = 94 * hash + (this.output != null ? this.output.hashCode() : 0);
            hash = 94 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 94 * hash + (this.fluidOutput != null ? this.fluidOutput.hashCode() : 0);
            hash = 94 * hash + this.duration;
            hash = 94 * hash + this.euPerTick;
            hash = 94 * hash + this.chance;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)((Object)obj);
            if (!(this.output == other.output || this.output != null && this.output.equals(other.output))) {
                return false;
            }
            if (this.input == other.input || this.input == null || !this.input.equals(other.input)) {
                // empty if block
            }
            if (!(this.fluidOutput == other.fluidOutput || this.fluidOutput != null && this.fluidOutput.equals(other.fluidOutput))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            if (this.euPerTick != other.euPerTick) {
                return false;
            }
            return this.chance == other.chance;
        }
    }
}

