/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.FluidHeater")
@ModOnly(value={"gregtech"})
public class FluidHeater {
    @ZenMethod
    public static void addRecipe(ILiquidStack fluidOutput, IItemStack Circuit, ILiquidStack fluidInput, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(fluidOutput, Circuit, fluidInput, durationTicks, euPerTick));
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final ILiquidStack fluidOutput;
        private final IItemStack Circuit;
        private final ILiquidStack fluidInput;
        private final int duration;
        private final int euPerTick;

        public AddRecipeAction(ILiquidStack fluidOutput, IItemStack Circuit, ILiquidStack fluidInput, int duration, int euPerTick) {
            this.fluidOutput = fluidOutput;
            this.Circuit = Circuit;
            this.fluidInput = fluidInput;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        public void apply() {
            GT_Values.RA.addFluidHeaterRecipe(MineTweakerMC.getItemStack((IItemStack)this.Circuit), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidInput), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidOutput), this.duration, this.euPerTick);
        }

        public String describe() {
            return "Adding Fluid Heater recipe for " + this.fluidOutput;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 3;
            hash = 44 * hash + (this.fluidOutput != null ? this.fluidOutput.hashCode() : 0);
            hash = 44 * hash + (this.Circuit != null ? this.Circuit.hashCode() : 0);
            hash = 44 * hash + (this.fluidInput != null ? this.fluidInput.hashCode() : 0);
            hash = 44 * hash + this.duration;
            hash = 44 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)((Object)obj);
            if (!(this.fluidOutput == other.fluidOutput || this.fluidOutput != null && this.fluidOutput.equals(other.fluidOutput))) {
                return false;
            }
            if (this.Circuit == other.Circuit || this.Circuit == null || !this.Circuit.equals(other.Circuit)) {
                // empty if block
            }
            if (!(this.fluidInput == other.fluidInput || this.fluidInput != null && this.fluidInput.equals(other.fluidInput))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }
}

