/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import java.util.Arrays;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Pulverizer")
@ModOnly(value={"gregtech"})
public class Pulverizer {
    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, IItemStack input, int[] outChances, int durationTicks, int euPerTick) {
        if (outputs.length < 1) {
            MineTweakerAPI.logError((String)"Pulverizer must have at least 1 output");
        } else if (outputs.length != outChances.length) {
            MineTweakerAPI.logError((String)"Number of Outputs does not equal number of Chances");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(outputs, input, outChances, durationTicks, euPerTick));
        }
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack[] output;
        private final IItemStack input;
        private final int[] chances;
        private final int duration;
        private final int euPerTick;

        public AddRecipeAction(IItemStack[] output, IItemStack input, int[] outChances, int duration, int euPerTick1) {
            this.output = output;
            this.input = input;
            this.chances = outChances;
            this.duration = duration;
            this.euPerTick = euPerTick1;
        }

        public void apply() {
            GT_Values.RA.addPulveriserRecipe(MineTweakerMC.getItemStack((IItemStack)this.input), MineTweakerMC.getItemStacks((IItemStack[])this.output), this.chances, this.duration, this.euPerTick);
        }

        public String describe() {
            return "Adding Pulverizer recipe for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 8;
            hash = 71 * hash + Arrays.deepHashCode(this.output);
            hash = 71 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 71 * hash + this.duration;
            hash = 71 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)((Object)obj);
            if (!Arrays.deepEquals(this.output, other.output)) {
                return false;
            }
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            if (this.chances != other.chances) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }
}

