/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import java.util.Arrays;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Electrolyzer")
@ModOnly(value={"gregtech"})
public class Electrolyzer {
    @ZenMethod
    public static void addRecipe(IItemStack[] output, ILiquidStack fluidOutput, IItemStack input, IItemStack cells, ILiquidStack fluidInput, int[] chances, int durationTicks, int euPerTick) {
        if (output.length < 1) {
            MineTweakerAPI.logError((String)"Electrolyzer must have at least 1 output");
        } else if (output.length != chances.length) {
            MineTweakerAPI.logError((String)"Number of Outputs does not equal number of Chances");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddFluidRecipeAction(output, fluidOutput, input, cells, fluidInput, chances, durationTicks, euPerTick));
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack[] output, IItemStack input, int cells, int durationTicks, int euPerTick) {
        if (output.length == 0) {
            MineTweakerAPI.logError((String)"Electrolyzer recipe requires at least 1 input");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, input, cells, durationTicks, euPerTick));
        }
    }

    private static class AddFluidRecipeAction
    extends OneWayAction {
        private final IItemStack[] output;
        private final ILiquidStack fluidOutput;
        private final IItemStack input;
        private final IItemStack cells;
        private final ILiquidStack fluidInput;
        private final int[] chances;
        private final int duration;
        private final int euPerTick;

        public AddFluidRecipeAction(IItemStack[] output, ILiquidStack fluidOutput, IItemStack input, IItemStack cells, ILiquidStack fluidInput, int[] chances, int duration, int euPerTick) {
            this.output = output;
            this.fluidOutput = fluidOutput;
            this.input = input;
            this.cells = cells;
            this.fluidInput = fluidInput;
            this.chances = chances;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        public void apply() {
            GT_Values.RA.addElectrolyzerRecipe(MineTweakerMC.getItemStack((IItemStack)this.input), MineTweakerMC.getItemStack((IItemStack)this.cells), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidInput), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidOutput), MineTweakerMC.getItemStack((IItemStack)this.output[0]), this.output.length > 1 ? MineTweakerMC.getItemStack((IItemStack)this.output[1]) : null, this.output.length > 2 ? MineTweakerMC.getItemStack((IItemStack)this.output[2]) : null, this.output.length > 3 ? MineTweakerMC.getItemStack((IItemStack)this.output[3]) : null, this.output.length > 4 ? MineTweakerMC.getItemStack((IItemStack)this.output[4]) : null, this.output.length > 5 ? MineTweakerMC.getItemStack((IItemStack)this.output[5]) : null, this.chances, this.duration, this.euPerTick);
        }

        public String describe() {
            return "Adding Electrolyzer recipe with Liquid support for " + this.input;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 8;
            hash = 44 * hash + (this.output != null ? this.output.hashCode() : 0);
            hash = 44 * hash + (this.fluidOutput != null ? this.fluidOutput.hashCode() : 0);
            hash = 44 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 44 * hash + (this.cells != null ? this.cells.hashCode() : 0);
            hash = 44 * hash + (this.fluidInput != null ? this.fluidInput.hashCode() : 0);
            hash = 44 * hash + (this.chances != null ? this.chances.hashCode() : 0);
            hash = 44 * hash + this.duration;
            hash = 44 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddFluidRecipeAction other = (AddFluidRecipeAction)((Object)obj);
            if (this.output == other.output || this.output == null || !this.output.equals(other.output)) {
                // empty if block
            }
            if (!(this.fluidOutput == other.fluidOutput || this.fluidOutput != null && this.fluidOutput.equals(other.fluidOutput))) {
                return false;
            }
            if (this.input == other.input || this.input == null || !this.input.equals(other.input)) {
                // empty if block
            }
            if (this.cells == other.cells || this.cells == null || !this.cells.equals(other.cells)) {
                // empty if block
            }
            if (!(this.fluidInput == other.fluidInput || this.fluidInput != null && this.fluidInput.equals(other.fluidInput))) {
                return false;
            }
            if (this.chances != other.chances) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack[] output;
        private final IItemStack input;
        private final int cells;
        private final int duration;
        private final int euPerTick;

        public AddRecipeAction(IItemStack[] output, IItemStack input, int cells, int duration, int euPerTick) {
            this.output = output;
            this.input = input;
            this.cells = cells;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        public void apply() {
            GT_Values.RA.addElectrolyzerRecipe(MineTweakerMC.getItemStack((IItemStack)this.input), this.cells, MineTweakerMC.getItemStack((IItemStack)this.output[0]), this.output.length > 1 ? MineTweakerMC.getItemStack((IItemStack)this.output[1]) : null, this.output.length > 2 ? MineTweakerMC.getItemStack((IItemStack)this.output[2]) : null, this.output.length > 3 ? MineTweakerMC.getItemStack((IItemStack)this.output[3]) : null, this.output.length > 4 ? MineTweakerMC.getItemStack((IItemStack)this.output[4]) : null, this.output.length > 5 ? MineTweakerMC.getItemStack((IItemStack)this.output[5]) : null, this.duration, this.cells);
        }

        public String describe() {
            return "Adding electrolyzer recipe with input " + this.input;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Arrays.deepHashCode(this.output);
            hash = 97 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 97 * hash + this.cells;
            hash = 97 * hash + this.duration;
            hash = 97 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)((Object)obj);
            if (!Arrays.deepEquals(this.output, other.output)) {
                return false;
            }
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            if (this.cells != other.cells) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }
}

