/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.FluidSolidifier")
@ModOnly(value={"gregtech"})
public class FluidSolidifier {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack Mold, ILiquidStack fluidInput, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, Mold, fluidInput, durationTicks, euPerTick));
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack output;
        private final IItemStack Mold;
        private final ILiquidStack fluidInput;
        private final int duration;
        private final int euPerTick;

        public AddRecipeAction(IItemStack output, IItemStack Mold, ILiquidStack fluidInput, int duration, int euPerTick) {
            this.output = output;
            this.Mold = Mold;
            this.fluidInput = fluidInput;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        public void apply() {
            GT_Values.RA.addFluidSolidifierRecipe(MineTweakerMC.getItemStack((IItemStack)this.Mold), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidInput), MineTweakerMC.getItemStack((IItemStack)this.output), this.duration, this.euPerTick);
        }

        public String describe() {
            return "Adding Fluid Solidifier recipe for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 3;
            hash = 94 * hash + (this.output != null ? this.output.hashCode() : 0);
            hash = 94 * hash + (this.Mold != null ? this.Mold.hashCode() : 0);
            hash = 94 * hash + (this.fluidInput != null ? this.fluidInput.hashCode() : 0);
            hash = 94 * hash + this.duration;
            hash = 94 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)((Object)obj);
            if (!(this.output == other.output || this.output != null && this.output.equals(other.output))) {
                return false;
            }
            if (this.Mold == other.Mold || this.Mold == null || !this.Mold.equals(other.Mold)) {
                // empty if block
            }
            if (!(this.fluidInput == other.fluidInput || this.fluidInput != null && this.fluidInput.equals(other.fluidInput))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }
}

