/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Assembler")
@ModOnly(value={"gregtech"})
public class Assembler {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input1, IItemStack input2, ILiquidStack fluidInput1, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply((IUndoableAction)new AddFluidRecipeAction(output, input1, input2, fluidInput1, durationTicks, euPerTick));
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input1, IItemStack input2, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, input1, input2, durationTicks, euPerTick));
    }

    private static class AddFluidRecipeAction
    extends OneWayAction {
        private final IItemStack output;
        private final IItemStack input1;
        private final IItemStack input2;
        private final ILiquidStack fluidInput1;
        private final int duration;
        private final int euPerTick;

        public AddFluidRecipeAction(IItemStack output, IItemStack input1, IItemStack input2, ILiquidStack fluidInput1, int duration, int euPerTick) {
            this.output = output;
            this.input1 = input1;
            this.input2 = input2;
            this.fluidInput1 = fluidInput1;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        public void apply() {
            GT_Values.RA.addAssemblerRecipe(MineTweakerMC.getItemStack((IItemStack)this.input1), MineTweakerMC.getItemStack((IItemStack)this.input2), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidInput1), MineTweakerMC.getItemStack((IItemStack)this.output), this.duration, this.euPerTick);
        }

        public String describe() {
            return "Adding assembler recipe with fluid Support for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 77 * hash + (this.output != null ? this.output.hashCode() : 0);
            hash = 77 * hash + (this.input1 != null ? this.input1.hashCode() : 0);
            hash = 77 * hash + (this.input2 != null ? this.input2.hashCode() : 0);
            hash = 77 * hash + (this.fluidInput1 != null ? this.fluidInput1.hashCode() : 0);
            hash = 77 * hash + this.duration;
            hash = 77 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddFluidRecipeAction other = (AddFluidRecipeAction)((Object)obj);
            if (!(this.output == other.output || this.output != null && this.output.equals(other.output))) {
                return false;
            }
            if (!(this.input1 == other.input1 || this.input1 != null && this.input1.equals(other.input1))) {
                return false;
            }
            if (!(this.input2 == other.input2 || this.input2 != null && this.input2.equals(other.input2))) {
                return false;
            }
            if (!(this.fluidInput1 == other.fluidInput1 || this.fluidInput1 != null && this.fluidInput1.equals(other.fluidInput1))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack output;
        private final IItemStack input1;
        private final IItemStack input2;
        private final int duration;
        private final int euPerTick;

        public AddRecipeAction(IItemStack output, IItemStack input1, IItemStack input2, int duration, int euPerTick) {
            this.output = output;
            this.input1 = input1;
            this.input2 = input2;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        public void apply() {
            GT_Values.RA.addAssemblerRecipe(MineTweakerMC.getItemStack((IItemStack)this.input1), MineTweakerMC.getItemStack((IItemStack)this.input2), MineTweakerMC.getItemStack((IItemStack)this.output), this.duration, this.euPerTick);
        }

        public String describe() {
            return "Adding assembler recipe for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

