/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.PlateBender")
@ModOnly(value={"gregtech"})
public class PlateBender {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack input, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, input, durationTicks, euPerTick));
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack output;
        private final IItemStack input;
        private final int duration;
        private final int euPerTick;

        public AddRecipeAction(IItemStack output, IItemStack input, int duration, int euPerTick) {
            this.output = output;
            this.input = input;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        public void apply() {
            GT_Values.RA.addBenderRecipe(MineTweakerMC.getItemStack((IItemStack)this.input), MineTweakerMC.getItemStack((IItemStack)this.output), this.duration, this.euPerTick);
        }

        public String describe() {
            return "Adding plate bender recipe for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 5;
            hash = 79 * hash + (this.output != null ? this.output.hashCode() : 0);
            hash = 79 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 79 * hash + this.duration;
            hash = 79 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)((Object)obj);
            if (!(this.output == other.output || this.output != null && this.output.equals(other.output))) {
                return false;
            }
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }
}

