/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.ChemicalBath")
@ModOnly(value={"gregtech"})
public class ChemicalBath {
    @ZenMethod
    public static void addRecipe(IItemStack[] output, IItemStack input, ILiquidStack fluidInput, int[] chances, int durationTicks, int euPerTick) {
        if (output.length == 0) {
            MineTweakerAPI.logError((String)"chemical bath requires at least 1 output");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, input, fluidInput, chances, durationTicks, euPerTick));
        }
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack[] output;
        private final IItemStack input;
        private final ILiquidStack fluidInput;
        private final int[] chances;
        private final int duration;
        private final int euPerTick;

        public AddRecipeAction(IItemStack[] output, IItemStack input, ILiquidStack fluidInput, int[] chances, int duration, int euPerTick) {
            this.output = output;
            this.input = input;
            this.fluidInput = fluidInput;
            this.chances = chances;
            this.duration = duration;
            this.euPerTick = euPerTick;
        }

        public void apply() {
            GT_Values.RA.addChemicalBathRecipe(MineTweakerMC.getItemStack((IItemStack)this.input), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidInput), MineTweakerMC.getItemStack((IItemStack)this.output[0]), this.output.length > 1 ? MineTweakerMC.getItemStack((IItemStack)this.output[1]) : null, this.output.length > 2 ? MineTweakerMC.getItemStack((IItemStack)this.output[2]) : null, this.chances, this.duration, this.euPerTick);
        }

        public String describe() {
            return "Adding Chemical Bath recipe for " + this.input;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 9;
            hash = 8 * hash + (this.output != null ? this.output.hashCode() : 0);
            hash = 8 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 8 * hash + (this.fluidInput != null ? this.fluidInput.hashCode() : 0);
            hash = 8 * hash + this.duration;
            hash = 8 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)((Object)obj);
            if (!(this.output == other.output || this.output != null && this.output.equals(other.output))) {
                return false;
            }
            if (this.input == other.input || this.input == null || !this.input.equals(other.input)) {
                // empty if block
            }
            if (!(this.fluidInput == other.fluidInput || this.fluidInput != null && this.fluidInput.equals(other.fluidInput))) {
                return false;
            }
            if (this.chances != other.chances) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }
}

