/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Fermenter")
@ModOnly(value={"gregtech"})
public class Fermenter {
    @ZenMethod
    public static void addRecipe(ILiquidStack fluidOutput, ILiquidStack fluidInput, int duration, boolean Hidden) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(fluidOutput, fluidInput, duration, Hidden));
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final ILiquidStack fluidOutput;
        private final ILiquidStack fluidInput;
        private final int duration;
        private final boolean Hidden;

        public AddRecipeAction(ILiquidStack fluidOutput, ILiquidStack fluidInput, int duration, boolean Hidden) {
            this.fluidOutput = fluidOutput;
            this.fluidInput = fluidInput;
            this.duration = duration;
            this.Hidden = Hidden;
        }

        public void apply() {
            GT_Values.RA.addFermentingRecipe(MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidInput), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidOutput), this.duration, this.Hidden);
        }

        public String describe() {
            return "Adding Fermenter recipe for " + this.fluidOutput;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 2;
            hash = 12 * hash + (this.fluidOutput != null ? this.fluidOutput.hashCode() : 0);
            hash = 12 * hash + (this.fluidInput != null ? this.fluidInput.hashCode() : 0);
            hash = 12 * hash + this.duration;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)((Object)obj);
            if (!(this.fluidOutput == other.fluidOutput || this.fluidOutput != null && this.fluidOutput.equals(other.fluidOutput))) {
                return false;
            }
            if (!(this.fluidInput == other.fluidInput || this.fluidInput != null && this.fluidInput.equals(other.fluidInput))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.Hidden == other.Hidden;
        }
    }
}

