/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.CuttingSaw")
@ModOnly(value={"gregtech"})
public class CuttingSaw {
    @ZenMethod
    public static void addRecipe(IItemStack output1, IItemStack output2, IItemStack input, ILiquidStack lubricant, int durationTicks, int euPerTick) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output1, output2, input, lubricant, durationTicks, euPerTick));
    }

    @ZenMethod
    public static void addRecipe(IItemStack[] output, IItemStack input, ILiquidStack lubricant, int durationTicks, int euPerTick) {
        if (output.length == 0) {
            MineTweakerAPI.logError((String)"canner requires at least 1 output");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output[0], output.length > 1 ? output[1] : null, input, lubricant, durationTicks, euPerTick));
        }
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack output1;
        private final IItemStack output2;
        private final IItemStack input;
        private final ILiquidStack lubricant;
        private final int duration;
        private final int euPerTick;

        public AddRecipeAction(IItemStack output1, IItemStack output2, IItemStack input, ILiquidStack lubricant, int duration, int euPerTick1) {
            this.output1 = output1;
            this.output2 = output2;
            this.input = input;
            this.lubricant = lubricant;
            this.duration = duration;
            this.euPerTick = euPerTick1;
        }

        public void apply() {
            if (this.lubricant == null) {
                GT_Values.RA.addCutterRecipe(MineTweakerMC.getItemStack((IItemStack)this.input), MineTweakerMC.getItemStack((IItemStack)this.output1), MineTweakerMC.getItemStack((IItemStack)this.output2), this.duration, this.euPerTick);
            } else {
                GT_Values.RA.addCutterRecipe(MineTweakerMC.getItemStack((IItemStack)this.input), MineTweakerMC.getLiquidStack((ILiquidStack)this.lubricant), MineTweakerMC.getItemStack((IItemStack)this.output1), MineTweakerMC.getItemStack((IItemStack)this.output2), this.duration, this.euPerTick);
            }
        }

        public String describe() {
            return "Adding Cutting Saw recipe for " + this.input;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 99 * hash + (this.output1 != null ? this.output1.hashCode() : 0);
            hash = 99 * hash + (this.output2 != null ? this.output2.hashCode() : 0);
            hash = 99 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 99 * hash + (this.lubricant != null ? this.lubricant.hashCode() : 0);
            hash = 99 * hash + this.duration;
            hash = 99 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)((Object)obj);
            if (!(this.output1 == other.output1 || this.output1 != null && this.output1.equals(other.output1))) {
                return false;
            }
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            if (!(this.lubricant == other.lubricant || this.lubricant != null && this.lubricant.equals(other.lubricant))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }
}

