/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import java.util.Arrays;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.DistillationTower")
@ModOnly(value={"gregtech"})
public class DistillationTower {
    @ZenMethod
    public static void addRecipe(ILiquidStack[] fluidOutput, IItemStack itemOutput, ILiquidStack fluidInput, int durationTicks, int euPerTick) {
        if (fluidOutput.length < 1) {
            MineTweakerAPI.logError((String)"Distillation Twower must have at least 1 Fluid output");
        } else {
            MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(fluidOutput, itemOutput, fluidInput, durationTicks, euPerTick));
        }
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final FluidStack[] fluidOutput;
        private final IItemStack itemOutput;
        private final ILiquidStack fluidInput;
        private final int duration;
        private final int euPerTick;

        public AddRecipeAction(ILiquidStack[] fluidOutput, IItemStack itemOutput, ILiquidStack fluidInput, int duration, int euPerTick) {
            this.fluidOutput = new FluidStack[fluidOutput.length];
            this.itemOutput = itemOutput;
            this.fluidInput = fluidInput;
            this.duration = duration;
            this.euPerTick = euPerTick;
            for (int i = 0; i < fluidOutput.length; ++i) {
                this.fluidOutput[i] = MineTweakerMC.getLiquidStack((ILiquidStack)fluidOutput[i]);
            }
        }

        public void apply() {
            GT_Values.RA.addDistillationTowerRecipe(MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidInput), this.fluidOutput, MineTweakerMC.getItemStack((IItemStack)this.itemOutput), this.duration, this.euPerTick);
        }

        public String describe() {
            return "Adding Distillation Tower recipe for " + this.fluidInput.getDisplayName();
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 1;
            hash = 9 * hash + (this.fluidInput != null ? this.fluidInput.hashCode() : 0);
            hash = 9 * hash + Arrays.deepHashCode(this.fluidOutput);
            hash = 9 * hash + (this.itemOutput != null ? this.itemOutput.hashCode() : 0);
            hash = 9 * hash + this.duration;
            hash = 9 * hash + this.euPerTick;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)((Object)obj);
            if (!(this.fluidInput == other.fluidInput || this.fluidInput != null && this.fluidInput.equals(other.fluidInput))) {
                return false;
            }
            if (!Arrays.deepEquals(this.fluidOutput, other.fluidOutput)) {
                return false;
            }
            if (!(this.itemOutput == other.itemOutput || this.itemOutput != null && this.itemOutput.equals(other.itemOutput))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            return this.euPerTick == other.euPerTick;
        }
    }
}

