/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.FusionReactor")
@ModOnly(value={"gregtech"})
public class FusionReactor {
    @ZenMethod
    public static void addRecipe(ILiquidStack fluidOutput, ILiquidStack fluidInput1, ILiquidStack fluidInput2, int durationTicks, int euPerTick, int startEU) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(fluidOutput, fluidInput1, fluidInput2, durationTicks, euPerTick, startEU));
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final ILiquidStack fluidOutput;
        private final ILiquidStack fluidInput1;
        private final ILiquidStack fluidInput2;
        private final int duration;
        private final int euPerTick;
        private final int startEU;

        public AddRecipeAction(ILiquidStack fluidOutput, ILiquidStack fluidInput1, ILiquidStack fluidInput2, int duration, int euPerTick, int StartEU) {
            this.fluidOutput = fluidOutput;
            this.fluidInput1 = fluidInput1;
            this.fluidInput2 = fluidInput2;
            this.duration = duration;
            this.euPerTick = euPerTick;
            this.startEU = StartEU;
        }

        public void apply() {
            GT_Values.RA.addFusionReactorRecipe(MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidInput2), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidInput1), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidOutput), this.duration, this.euPerTick, this.startEU);
        }

        public String describe() {
            return "Adding Fusion Reactor recipe for " + this.fluidOutput;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 1;
            hash = 99 * hash + (this.fluidOutput != null ? this.fluidOutput.hashCode() : 0);
            hash = 99 * hash + (this.fluidInput1 != null ? this.fluidInput1.hashCode() : 0);
            hash = 99 * hash + (this.fluidInput2 != null ? this.fluidInput2.hashCode() : 0);
            hash = 99 * hash + this.duration;
            hash = 99 * hash + this.euPerTick;
            hash = 99 * hash + this.startEU;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)((Object)obj);
            if (!(this.fluidOutput == other.fluidOutput || this.fluidOutput != null && this.fluidOutput.equals(other.fluidOutput))) {
                return false;
            }
            if (!(this.fluidInput1 == other.fluidInput1 || this.fluidInput1 != null && this.fluidInput1.equals(other.fluidInput1))) {
                return false;
            }
            if (!(this.fluidInput2 == other.fluidInput2 || this.fluidInput2 != null && this.fluidInput2.equals(other.fluidInput2))) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            if (this.euPerTick != other.euPerTick) {
                return false;
            }
            return this.startEU == other.startEU;
        }
    }
}

