/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Brewery")
@ModOnly(value={"gregtech"})
public class Brewery {
    @ZenMethod
    public static void addRecipe(ILiquidStack fluidOutput, IItemStack Ingredient, ILiquidStack fluidInput, boolean Hidden) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(fluidOutput, Ingredient, fluidInput, Hidden));
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private final IItemStack Ingredient;
        private final ILiquidStack fluidOutput;
        private final ILiquidStack fluidInput;
        private final boolean Hidden;

        public AddRecipeAction(ILiquidStack fluidOutput, IItemStack Ingredient, ILiquidStack fluidInput, boolean Hidden) {
            this.Ingredient = Ingredient;
            this.fluidOutput = fluidOutput;
            this.fluidInput = fluidInput;
            this.Hidden = Hidden;
        }

        public void apply() {
            GT_Values.RA.addBrewingRecipe(MineTweakerMC.getItemStack((IItemStack)this.Ingredient), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidOutput).getFluid(), MineTweakerMC.getLiquidStack((ILiquidStack)this.fluidInput).getFluid(), this.Hidden);
        }

        public String describe() {
            return "Adding Brewery recipe for " + this.fluidOutput;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 9;
            hash = 8 * hash + (this.fluidOutput != null ? this.fluidOutput.hashCode() : 0);
            hash = 8 * hash + (this.Ingredient != null ? this.Ingredient.hashCode() : 0);
            hash = 8 * hash + (this.fluidInput != null ? this.fluidInput.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)((Object)obj);
            if (!(this.fluidOutput == other.fluidOutput || this.fluidOutput != null && this.fluidOutput.equals(other.fluidOutput))) {
                return false;
            }
            if (this.Ingredient == other.Ingredient || this.Ingredient == null || !this.Ingredient.equals(other.Ingredient)) {
                // empty if block
            }
            if (!(this.fluidInput == other.fluidInput || this.fluidInput != null && this.fluidInput.equals(other.fluidInput))) {
                return false;
            }
            return this.Hidden == other.Hidden;
        }
    }
}

