/*
 * Decompiled with CFR 0.152.
 */
package gttweaker.mods.gregtech;

import gregtech.api.enums.GT_Values;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.Fuels")
@ModOnly(value={"gregtech"})
public class Fuels {
    @ZenMethod
    public static void addDieselFuel(IItemStack output, IItemStack input, int euPerMillibucket) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, input, euPerMillibucket, 0));
    }

    @ZenMethod
    public static void addGasTurbineFuel(IItemStack output, IItemStack input, int euPerMillibucket) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, input, euPerMillibucket, 1));
    }

    @ZenMethod
    public static void addThermalGeneratorFuel(IItemStack output, IItemStack input, int euPerMillibucket) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, input, euPerMillibucket, 2));
    }

    @ZenMethod
    public static void addDenseFluidFuel(IItemStack output, IItemStack input, int euPerMillibucket) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, input, euPerMillibucket, 3));
    }

    @ZenMethod
    public static void addPlasmaGeneratorFuel(IItemStack output, IItemStack input, int euPerMillibucket) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, input, euPerMillibucket, 4));
    }

    @ZenMethod
    public static void addMagicGeneratorFuel(IItemStack output, IItemStack input, int euPerMillibucket) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, input, euPerMillibucket, 5));
    }

    private static class AddRecipeAction
    extends OneWayAction {
        private static final String[] GENERATORS = new String[]{"diesel", "gas turbine", "thermal", "dense fluid", "plasma", "magic"};
        private final IItemStack output;
        private final IItemStack input;
        private final int euPerMillibucket;
        private final int type;

        public AddRecipeAction(IItemStack output, IItemStack input, int euPerMillibucket, int type) {
            this.output = output;
            this.input = input;
            this.euPerMillibucket = euPerMillibucket;
            this.type = type;
        }

        public void apply() {
            GT_Values.RA.addFuel(MineTweakerMC.getItemStack((IItemStack)this.input), MineTweakerMC.getItemStack((IItemStack)this.output), this.euPerMillibucket, this.type);
        }

        public String describe() {
            return "Adding " + GENERATORS[this.type] + " fuel " + this.input;
        }

        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 5;
            hash = 59 * hash + (this.output != null ? this.output.hashCode() : 0);
            hash = 59 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 59 * hash + this.euPerMillibucket;
            hash = 59 * hash + this.type;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            AddRecipeAction other = (AddRecipeAction)((Object)obj);
            if (!(this.output == other.output || this.output != null && this.output.equals(other.output))) {
                return false;
            }
            if (!(this.input == other.input || this.input != null && this.input.equals(other.input))) {
                return false;
            }
            if (this.euPerMillibucket != other.euPerMillibucket) {
                return false;
            }
            return this.type == other.type;
        }
    }
}

