/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import ihl.IHLMod;
import ihl.flexible_cable.FrequencyGeneratorTileEntity;
import ihl.flexible_cable.IEnergyNetNode;
import ihl.flexible_cable.IHLCable;
import ihl.flexible_cable.IHLCableSet;
import ihl.flexible_cable.IHLGrid;
import ihl.flexible_cable.NodeEntity;
import ihl.utils.IHLUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class RectifierTransformerUnitTileEntity
extends TileEntityBlock
implements INetworkClientTileEntityEventListener,
IEnergyNetNode {
    private double connectionX;
    private double connectionY;
    private double connectionZ;
    private int gridID = -1;
    private IHLCableSet cableList = new IHLCableSet();
    private int countdownTimer = 200;
    private boolean startCableBurning = false;
    private IHLCable cableToBurn;
    public double energy;
    public int maxStorage = 4096;
    private boolean addedToEnergyNet = false;
    private static final int[] voltageOutArray = new int[]{5, 10, 50, 500, 1000, 2000, 4000, 8000};
    public byte mode = 0;
    private FrequencyGeneratorTileEntity frequencyGenerator;

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void onLoaded() {
        super.onLoaded();
        if (this.gridID != -1) {
            IHLGrid grid = IHLMod.enet.getGrid(this.gridID);
            grid.telist.add(this);
        }
    }

    public void setFacing(short facing1) {
        short facing2 = (short)Math.max(facing1, 2);
        double range = 0.1;
        AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)(this.getConnectionX() - range), (double)(this.getConnectionY() - range), (double)(this.getConnectionZ() - range), (double)(this.getConnectionX() + range), (double)(this.getConnectionY() + range), (double)(this.getConnectionZ() + range));
        List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
        super.setFacing(facing2);
        this.setConnectionX((double)this.field_145851_c + 0.5);
        this.setConnectionY((double)this.field_145848_d + 1.7);
        this.setConnectionZ((double)this.field_145849_e + 0.5);
        if (!nodeList.isEmpty()) {
            for (NodeEntity ne : nodeList) {
                if (!ne.isFixed || !this.cableListContains(ne.getChainUniqueID())) continue;
                ne.func_70107_b(this.getConnectionX(), this.getConnectionY(), this.getConnectionZ());
            }
        }
    }

    private boolean checkACEnergySource(ForgeDirection orientation) {
        if (this.frequencyGenerator != null) {
            return true;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + orientation.offsetX, this.field_145848_d, this.field_145849_e + orientation.offsetZ);
        if (te instanceof FrequencyGeneratorTileEntity) {
            this.frequencyGenerator = (FrequencyGeneratorTileEntity)te;
            return true;
        }
        return false;
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        return IHLUtils.getThisModItemStack("rectifierTransformerUnit");
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.cableList.saveToNBT(nbt);
        nbt.func_74780_a("connectionX", this.getConnectionX());
        nbt.func_74780_a("connectionY", this.getConnectionY());
        nbt.func_74780_a("connectionZ", this.getConnectionZ());
        nbt.func_74768_a("gridID", this.gridID);
        nbt.func_74780_a("energy", this.energy);
        nbt.func_74774_a("mode", this.mode);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cableList.loadFromNBT(nbt);
        this.setConnectionX(nbt.func_74769_h("connectionX"));
        this.setConnectionY(nbt.func_74769_h("connectionY"));
        this.setConnectionZ(nbt.func_74769_h("connectionZ"));
        this.gridID = nbt.func_74762_e("gridID");
        this.energy = nbt.func_74769_h("energy");
        this.mode = nbt.func_74771_c("mode");
    }

    @Override
    public void removeAttachedChains() {
        if (!this.getCableList().isEmpty()) {
            double range = 128.0;
            AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
            List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
            if (!nodeList.isEmpty()) {
                for (NodeEntity ne : nodeList) {
                    if (!this.cableListContains(ne.getChainUniqueID())) continue;
                    ne.func_70106_y();
                }
            }
            for (IHLCable c : this.getCableList()) {
                ItemStack is = IHLUtils.getThisModItemStack(c.itemName);
                is.field_77990_d = new NBTTagCompound();
                is.field_77990_d.func_74757_a("firstConnection", false);
                is.field_77990_d.func_74768_a("length", c.length);
                is.field_77990_d.func_74768_a("fullLength", c.length);
                EntityItem eitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, is);
                this.field_145850_b.func_72838_d((Entity)eitem);
            }
            if (this.gridID != -1) {
                IHLMod.enet.splitGrids(this.gridID, this);
            }
            this.getCableList().clear();
        }
    }

    private boolean cableListContains(int chainUniqueID) {
        for (IHLCable c : this.getCableList()) {
            if (c.cableID != chainUniqueID) continue;
            return true;
        }
        return false;
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            default: 
        }
    }

    public void switchModeUp() {
        if (this.mode + 1 < voltageOutArray.length) {
            this.mode = (byte)(this.mode + 1);
            this.getGrid().injectEnergy(this.energy, voltageOutArray[this.mode], this);
            this.energy = 0.0;
        }
    }

    public void switchModeDown() {
        if (this.mode > 0) {
            this.mode = (byte)(this.mode - 1);
            this.getGrid().injectEnergy(this.energy, voltageOutArray[this.mode], this);
            this.energy = 0.0;
        }
    }

    public void func_145845_h() {
        if (IC2.platform.isSimulating()) {
            super.func_145845_h();
            if (this.gridID != -1 && this.getGrid().energy < 0.1 && this.energy > 0.0) {
                this.getGrid().injectEnergy(this.energy, voltageOutArray[this.mode], this);
                this.energy = 0.0;
            }
            ForgeDirection orientation = ForgeDirection.getOrientation((int)this.getFacing());
            if (this.energy < (double)this.maxStorage && this.checkACEnergySource(orientation)) {
                this.energy += this.frequencyGenerator.requestEnergy(orientation.getOpposite(), Integer.MAX_VALUE);
            }
            if (this.startCableBurning) {
                --this.countdownTimer;
                if (this.countdownTimer <= 0) {
                    double range = (double)this.cableToBurn.length * 2.0 + 32.0;
                    AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
                    List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
                    if (!nodeList.isEmpty()) {
                        for (NodeEntity ne : nodeList) {
                            if (ne.getChainUniqueID() != this.cableToBurn.cableID) continue;
                            ne.func_70106_y();
                        }
                    }
                    IHLMod.enet.removeCableAndSplitGrids(this.gridID, this.cableToBurn);
                    this.startCableBurning = false;
                    this.countdownTimer = 200;
                }
            }
        }
    }

    @Override
    public void initiateCableBurnout(IHLCable cable) {
        this.cableToBurn = cable;
        double range = (double)cable.length * 2.0 + 32.0;
        AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
        List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
        if (!nodeList.isEmpty()) {
            for (NodeEntity ne : nodeList) {
                if (ne.getChainUniqueID() != cable.cableID) continue;
                ne.func_70015_d(10);
            }
        }
        this.startCableBurning = true;
    }

    @Override
    public double getConnectionX() {
        return this.connectionX;
    }

    public void setConnectionX(double connectionX) {
        this.connectionX = connectionX;
    }

    @Override
    public double getConnectionY() {
        return this.connectionY;
    }

    public void setConnectionY(double connectionY) {
        this.connectionY = connectionY;
    }

    @Override
    public double getConnectionZ() {
        return this.connectionZ;
    }

    public void setConnectionZ(double connectionZ) {
        this.connectionZ = connectionZ;
    }

    @Override
    public boolean addCable(IHLCable cable) {
        return this.cableList.add(cable);
    }

    @Override
    public IHLCableSet getCableList() {
        return this.cableList;
    }

    @Override
    public void setGrid(int newGridID) {
        if (newGridID != -1) {
            this.gridID = newGridID;
            IHLMod.enet.getGrid((int)newGridID).telist.add(this);
            IHLMod.enet.getGrid((int)newGridID).isGridValid = true;
        } else {
            this.gridID = -1;
        }
    }

    public double requestACEnergy(double amount) {
        double energyToReturn = Math.min(amount, this.energy);
        this.energy -= energyToReturn;
        return energyToReturn;
    }

    @Override
    public int getGridID() {
        return this.gridID;
    }

    @Override
    public IHLGrid getGrid() {
        return IHLMod.enet.getGrid(this.gridID);
    }

    public int getVoltageOut() {
        return voltageOutArray[this.mode];
    }

    @Override
    public double getMaxAllowableVoltage() {
        return 64000.0;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }
}

