/*
 * Decompiled with CFR 0.152.
 */
package ihl.items_blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ihl.IHLCreativeTab;
import ihl.IHLMod;
import ihl.flexible_cable.IEnergyNetNode;
import ihl.flexible_cable.IHLCable;
import ihl.flexible_cable.NodeEntity;
import ihl.items_blocks.WireItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class FlexibleCableItem
extends WireItem {
    public int voltageLimit = 5000;
    public int resistivity = 10000;
    private List<String> info = new ArrayList<String>();
    private String registryName;
    public InsulationMaterial insulationMaterial;

    public FlexibleCableItem(WireItem.WireMaterial wireMaterial, WireItem.WireBasicTransverseSection wireBasicTransverseSection, InsulationMaterial insulationMaterial1, int i2p, String registryName1) {
        this.insulationMaterial = insulationMaterial1;
        this.voltageLimit = insulationMaterial1.voltageLimit;
        this.registryName = registryName1;
        this.material = wireMaterial;
        this.ts = wireBasicTransverseSection;
        this.leadsNum = i2p;
        this.func_77637_a(IHLCreativeTab.tab);
        this.func_77625_d(1);
        this.info.add(this.material.description + " " + this.ts.value * (float)this.leadsNum + " sq. mm,");
        switch (insulationMaterial1) {
            case VulcanizedRubber: {
                this.info.add("vulcanized rubber insulated");
                this.material.vulcanizedRubberCablesMap.put(Float.valueOf(this.ts.value * (float)this.leadsNum), new ItemStack((Item)this));
                break;
            }
            case Rubber: {
                this.info.add("non vulcanized rubber insulated");
                this.material.cablesMap.put(Float.valueOf(this.ts.value * (float)this.leadsNum), new ItemStack((Item)this));
            }
        }
        this.resistivity = Math.round((float)this.material.baseResistance / this.ts.value / (float)this.leadsNum);
        this.func_77655_b("flexibleCableWithClamp");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        ItemStack stack = new ItemStack(item);
        stack.field_77990_d = new NBTTagCompound();
        stack.field_77990_d.func_74768_a("fullLength", 16);
        stack.field_77990_d.func_74768_a("length", 16);
        stack.field_77990_d.func_74757_a("firstConnection", false);
        itemList.add(stack);
    }

    public static void init() {
        WireItem.WireMaterial[] var1 = WireItem.WireMaterial.values();
        for (int i = 0; i < var1.length; ++i) {
            WireItem.WireBasicTransverseSection[] var2 = WireItem.WireBasicTransverseSection.values();
            for (int i1 = 0; i1 < var2.length; ++i1) {
                InsulationMaterial[] var3 = InsulationMaterial.values();
                for (int i2 = 0; i2 < var3.length; ++i2) {
                    String registryName = "flexibleCable" + var1[i].description;
                    if (i1 == 0 && var1[i] == WireItem.WireMaterial.Copper) {
                        registryName = "flexibleCableWithClamp";
                    }
                    if (i1 == 1 && var1[i] == WireItem.WireMaterial.Copper) {
                        registryName = "flexibleCableCopper16x";
                    }
                    if (var1[i] == WireItem.WireMaterial.Steel) {
                        registryName = "flexibleCable" + var1[i].description + Math.round(var2[i1].value);
                    }
                    if (var3[i2] != InsulationMaterial.Rubber) {
                        registryName = "flexibleCable" + var1[i].description + var3[i2].description + Math.round(var2[i1].value);
                    }
                    GameRegistry.registerItem((Item)new FlexibleCableItem(var1[i], var2[i1], var3[i2], 1, registryName), (String)registryName);
                }
            }
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        TileEntity t = world.func_147438_o(x, y, z);
        world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "step.stone", 1.0f, 0.8f);
        if (!world.field_72995_K && t != null && t instanceof IEnergyNetNode) {
            boolean firstConnection = false;
            IEnergyNetNode te = (IEnergyNetNode)t;
            if (stack.field_77990_d == null) {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74768_a("fullLength", 16);
                stack.field_77990_d.func_74768_a("length", 16);
                stack.field_77990_d.func_74757_a("firstConnection", false);
            }
            firstConnection = stack.field_77990_d.func_74767_n("firstConnection");
            if (stack.field_77990_d.func_74762_e("fullLength") < 1) {
                return false;
            }
            if (firstConnection) {
                int l1;
                int z1;
                int y1;
                int x1 = stack.field_77990_d.func_74762_e("connectorX");
                if ((x - x1) * (x - x1) + (y - (y1 = stack.field_77990_d.func_74762_e("connectorY"))) * (y - y1) + (z - (z1 = stack.field_77990_d.func_74762_e("connectorZ"))) * (z - z1) > (l1 = stack.field_77990_d.func_74762_e("fullLength")) * l1) {
                    return false;
                }
                if ((x - x1) * (x - x1) + (y - y1) * (y - y1) + (z - z1) * (z - z1) == 0) {
                    this.cleanUp(world, x, y, z, stack.field_77990_d.func_74762_e("chainUID"));
                    stack.field_77990_d.func_74757_a("firstConnection", false);
                    stack.field_77990_d.func_74768_a("length", l1);
                    return true;
                }
                stack.field_77990_d.func_74757_a("firstConnection", false);
                IEnergyNetNode te1 = (IEnergyNetNode)world.func_147438_o(x1, y1, z1);
                int newGridID = IHLMod.enet.mergeGrids(te.getGridID(), te1.getGridID());
                int l2 = stack.field_77990_d.func_74762_e("length");
                IHLCable cable = new IHLCable(stack.field_77990_d.func_74762_e("chainUID"), l1 - l2, this.resistivity, this.voltageLimit, this.registryName);
                if (te.addCable(cable) && te1.addCable(cable)) {
                    te.setGrid(newGridID);
                    te1.setGrid(newGridID);
                }
                if (l2 > 0) {
                    stack.field_77990_d.func_74768_a("fullLength", l2);
                } else {
                    --stack.field_77994_a;
                }
            } else {
                stack.field_77990_d.func_74757_a("firstConnection", true);
            }
            stack.field_77990_d.func_74768_a("connectorX", x);
            stack.field_77990_d.func_74768_a("connectorY", y);
            stack.field_77990_d.func_74768_a("connectorZ", z);
            double ppx = te.getConnectionX();
            double ppy = te.getConnectionY();
            double ppz = te.getConnectionZ();
            NodeEntity node = new NodeEntity(world);
            node.func_70107_b(ppx, ppy, ppz);
            node.isFixed = true;
            node.setAnchor(x, y, z);
            node.field_70129_M = (float)(te.getConnectionY() - Math.ceil(te.getConnectionY()));
            world.func_72838_d((Entity)node);
            if (stack.field_77990_d.func_74767_n("firstConnection")) {
                int cuid = node.getPersistentID().hashCode();
                stack.field_77990_d.func_74768_a("chainUID", cuid);
                node.setChainUniqueID(cuid);
                node.chainArrangeNumber = 0;
                stack.field_77990_d.func_74768_a("chainArrangeNumber", 0);
            } else {
                node.setChainUniqueID(stack.field_77990_d.func_74762_e("chainUID"));
                node.chainArrangeNumber = stack.field_77990_d.func_74762_e("chainArrangeNumber") + 1;
                node.attachedItem = stack;
            }
            stack.field_77990_d.func_74780_a("prevNodePosX", ppx);
            stack.field_77990_d.func_74780_a("prevNodePosY", ppy);
            stack.field_77990_d.func_74780_a("prevNodePosZ", ppz);
            return true;
        }
        return false;
    }

    private void cleanUp(World worldObj, int xCoord, int yCoord, int zCoord, int chainUID) {
        double range = 128.0;
        AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)xCoord - range), (double)((double)yCoord - range), (double)((double)zCoord - range), (double)((double)xCoord + range), (double)((double)yCoord + range), (double)((double)zCoord + range));
        List nodeList = worldObj.func_72872_a(NodeEntity.class, searchArea);
        if (!nodeList.isEmpty()) {
            for (NodeEntity ne : nodeList) {
                if (ne.getChainUniqueID() != chainUID) continue;
                ne.func_70106_y();
            }
        }
    }

    protected MovingObjectPosition returnMOPFromPlayer(EntityPlayer entityplayer, World world) {
        float f9;
        float f6;
        double d3;
        float f5;
        float f = 1.0f;
        float f1 = entityplayer.field_70127_C + (entityplayer.field_70125_A - entityplayer.field_70127_C) * f;
        float f2 = entityplayer.field_70126_B + (entityplayer.field_70177_z - entityplayer.field_70126_B) * f;
        double d = entityplayer.field_70169_q + (entityplayer.field_70165_t - entityplayer.field_70169_q) * (double)f;
        double d1 = entityplayer.field_70167_r + (entityplayer.field_70163_u - entityplayer.field_70167_r) * (double)f + (double)entityplayer.func_70047_e();
        if (world.field_72995_K) {
            d1 -= (double)entityplayer.getDefaultEyeHeight();
        }
        double d2 = entityplayer.field_70166_s + (entityplayer.field_70161_v - entityplayer.field_70166_s) * (double)f;
        Vec3 vec3d = Vec3.func_72443_a((double)d, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * 0.01745329f - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * 0.01745329f - (float)Math.PI));
        float f7 = f4 * (f5 = -MathHelper.func_76134_b((float)(-f1 * 0.01745329f)));
        Vec3 vec3d1 = vec3d.func_72441_c((double)f7 * (d3 = 5.0), (double)(f6 = MathHelper.func_76126_a((float)(-f1 * 0.01745329f))) * d3, (double)(f9 = f3 * f5) * d3);
        MovingObjectPosition movingobjectposition = world.func_72901_a(vec3d, vec3d1, true);
        if (movingobjectposition == null) {
            return null;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return movingobjectposition;
        }
        return null;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotIndex, boolean isCurrentItem) {
        int leight;
        if (!world.field_72995_K && stack.field_77990_d != null && stack.field_77990_d.func_74767_n("firstConnection") && (leight = stack.field_77990_d.func_74762_e("length")) > 0) {
            double sqd;
            double pnpx = stack.field_77990_d.func_74769_h("prevNodePosX");
            double pnpy = stack.field_77990_d.func_74769_h("prevNodePosY");
            double pnpz = stack.field_77990_d.func_74769_h("prevNodePosZ");
            double ppx = entity.field_70165_t;
            double ppy = entity.field_70163_u;
            double ppz = entity.field_70161_v;
            if (pnpx != 0.0 && pnpy != 0.0 && pnpz != 0.0 && (sqd = (ppx - pnpx) * (ppx - pnpx) + (ppy - pnpy) * (ppy - pnpy) + (ppz - pnpz) * (ppz - pnpz)) > 1.0) {
                int can = stack.field_77990_d.func_74762_e("chainArrangeNumber") + 1;
                NodeEntity node = new NodeEntity(world);
                node.func_70107_b(ppx, ppy, ppz);
                world.func_72838_d((Entity)node);
                int cuid = stack.field_77990_d.func_74762_e("chainUID");
                node.setChainUniqueID(cuid);
                node.chainArrangeNumber = can;
                node.attachedItem = stack;
                int cx = stack.field_77990_d.func_74762_e("connectorX");
                int cy = stack.field_77990_d.func_74762_e("connectorY");
                int cz = stack.field_77990_d.func_74762_e("connectorZ");
                node.setAnchor(cx, cy, cz);
                stack.field_77990_d.func_74768_a("chainArrangeNumber", can);
                stack.field_77990_d.func_74780_a("prevNodePosX", ppx);
                stack.field_77990_d.func_74780_a("prevNodePosY", ppy);
                stack.field_77990_d.func_74780_a("prevNodePosZ", ppz);
                stack.field_77990_d.func_74768_a("length", --leight);
            }
        }
    }

    @Override
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List info, boolean flag) {
        info.addAll(this.info);
        if (itemStack.field_77990_d != null) {
            info.add("Length " + itemStack.field_77990_d.func_74762_e("length") + "m");
        }
        info.add("Resistivity: " + (float)this.resistivity / 1000.0f + " V^2/(EU*m)");
        info.add("Isolation breakdown voltage: ");
        info.add("" + this.voltageLimit / 1000 + " kV");
    }

    @Override
    public String getTag() {
        return "length";
    }

    @Override
    public int getDefaultLength() {
        return 16;
    }

    @Override
    public String getTagSecondary() {
        return "fullLength";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("ihl:" + this.registryName);
    }

    public ItemStack getUninsulatedResult() {
        return this.material.wiresMap.get(Float.valueOf(this.ts.value * (float)this.leadsNum)).func_77946_l();
    }

    public static enum InsulationMaterial {
        Rubber("NonVulcanizedRubber", 5000),
        VulcanizedRubber("VulcanizedRubber", 10000);

        public Map<Float, ItemStack> wiresMap;
        public Map<Float, ItemStack> cablesMap;
        public String description;
        int voltageLimit;

        private InsulationMaterial(String description1, int voltageLimit1) {
            this.description = description1;
            this.voltageLimit = voltageLimit1;
        }
    }
}

