/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.chemistry;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotOutput;
import ihl.processing.chemistry.ApparatusProcessableInvSlot;
import ihl.processing.chemistry.ChemicalReactorContainer;
import ihl.processing.chemistry.ChemicalReactorGui;
import ihl.processing.chemistry.CryogenicDistillerTileEntity;
import ihl.processing.invslots.IHLInvSlotOutput;
import ihl.processing.invslots.InvSlotConsumableLiquidIHL;
import ihl.processing.metallurgy.BasicElectricMotorTileEntity;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLFluidTank;
import ihl.utils.IHLUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class ChemicalReactorTileEntity
extends BasicElectricMotorTileEntity
implements IFluidHandler {
    private static final UniversalRecipeManager recipeManager = new UniversalRecipeManager();
    public final ApparatusProcessableInvSlot input;
    public final IHLInvSlotOutput outputSlot;
    public final InvSlotConsumableLiquidIHL drainInputSlot;
    public final InvSlotConsumableLiquidIHL fillInputSlot;
    public final InvSlotOutput emptyFluidItemsSlot;
    private final IHLFluidTank fluidTank = new IHLFluidTank(8000);
    public short temperature = (short)20;

    public ChemicalReactorTileEntity() {
        this.outputSlot = new IHLInvSlotOutput(this, "output", 0, 2);
        this.drainInputSlot = new InvSlotConsumableLiquidIHL(this, "drainInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain);
        this.fillInputSlot = new InvSlotConsumableLiquidIHL(this, "fillInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Fill);
        this.emptyFluidItemsSlot = new InvSlotOutput((TileEntityInventory)this, "fluidCellsOutput", 2, 1);
        this.input = new ApparatusProcessableInvSlot(this, "input", 3, InvSlot.Access.IO, 2, 64);
        this.isGuiScreenOpened = true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("chemicalReactor");
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        IHLUtils.handleFluidSlotsBehaviour(this.fillInputSlot, this.drainInputSlot, this.emptyFluidItemsSlot, this.fluidTank);
    }

    public FluidStack drain(ForgeDirection from, int amount, boolean doDrain) {
        FluidStack fstack = this.fluidTank.drain(amount, doDrain);
        return fstack;
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return true;
    }

    public boolean canFill(ForgeDirection direction, Fluid arg1) {
        return direction.equals((Object)ForgeDirection.getOrientation((int)this.getFacing()).getOpposite());
    }

    @Override
    public String func_145825_b() {
        return "chemicalReactor";
    }

    private int mX() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    private int mZ() {
        switch (this.getFacing()) {
            case 3: {
                return 1;
            }
            case 2: {
                return -1;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
        }
        return -1;
    }

    private short getFacingFromXZ(int x, int z) {
        switch (x) {
            case -1: {
                return 4;
            }
            case 1: {
                return 5;
            }
        }
        switch (z) {
            case 1: {
                return 3;
            }
            case -1: {
                return 2;
            }
        }
        return 2;
    }

    public float getRenderLiquidLevel() {
        return (float)this.fluidTank.getFluidAmount() / (float)this.fluidTank.getCapacity();
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
    }

    @Override
    public int gaugeProgressScaled(int i) {
        return this.progress * i / this.operationLength;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean arg1) {
        return new ChemicalReactorGui(new ChemicalReactorContainer(player, this));
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        this.fluidTank.sortFluidsByDensity();
        return new ChemicalReactorContainer(player, this);
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canOperate() {
        UniversalRecipeOutput output = this.getOutput();
        if (output != null && this.outputSlot.canAdd(this.getOutput().getItemOutputs())) {
            if (output.specialConditions) {
                return this.checkSpecialConditions();
            }
            return true;
        }
        return false;
    }

    private boolean checkSpecialConditions() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing());
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ);
        if (te instanceof CryogenicDistillerTileEntity) {
            CryogenicDistillerTileEntity cgte = (CryogenicDistillerTileEntity)te;
            return cgte.getFacing() == this.getFacing() && cgte.canProcess();
        }
        return false;
    }

    public UniversalRecipeOutput getOutput() {
        return recipeManager.getOutputFor(this.getInput()[0], this.getInput()[1], false, false);
    }

    @Override
    public List[] getInput() {
        for (int i = 0; i < this.fluidTank.getNumberOfFluids(); ++i) {
            for (int i1 = 0; i1 < this.fluidTank.getNumberOfFluids(); ++i1) {
                if (i == i1) continue;
                if (recipeManager.getOutputFor(Arrays.asList(this.fluidTank.getFluid(i), this.fluidTank.getFluid(i1)), this.input.getItemStackList(), false, false) == null) continue;
                return new List[]{Arrays.asList(this.fluidTank.getFluid(i), this.fluidTank.getFluid(i1)), this.input.getItemStackList()};
            }
        }
        return new List[]{Arrays.asList(this.fluidTank.getFluid()), this.input.getItemStackList()};
    }

    @Override
    public void operate() {
        UniversalRecipeInput recipeInput = recipeManager.getRecipeInput(this.getInput()[0], this.getInput()[1]);
        UniversalRecipeOutput output1 = this.getOutput();
        for (int i = 0; i < recipeInput.getItemInputs().size(); ++i) {
            this.input.consume(i, recipeInput.getItemInputs().get(i).getAmount());
        }
        this.fluidTank.drain(recipeInput.getFluidInputs(), true);
        this.fluidTank.fill(output1.getFluidOutputs(), true);
        this.outputSlot.add(output1.getItemOutputs());
        if (output1.specialConditions) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing());
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ);
            if (te instanceof CryogenicDistillerTileEntity) {
                CryogenicDistillerTileEntity cgte = (CryogenicDistillerTileEntity)te;
                int filled = cgte.fill(ForgeDirection.getOrientation((int)this.getFacing()), recipeInput.getFluidInputs().get(1).copy(), true);
            }
        }
    }

    public FluidStack drain(ForgeDirection arg0, FluidStack fluidStack, boolean doDrain) {
        if (this.fluidTank.getFluid().containsFluid(fluidStack)) {
            return this.fluidTank.drain(fluidStack.amount, doDrain);
        }
        return null;
    }

    public int fill(ForgeDirection arg0, FluidStack arg1, boolean arg2) {
        return this.fluidTank.fill(arg1, arg2);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection arg0) {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    public boolean needsFluid() {
        return this.fluidTank.getFluidAmount() <= this.fluidTank.getCapacity();
    }

    public FluidStack getFluidStackfromTank() {
        return this.fluidTank.getFluid();
    }

    public int getTankAmount() {
        return this.fluidTank.getFluidAmount();
    }

    public int gaugeLiquidScaled(int i, int index) {
        return this.fluidTank.getFluidAmount() <= 0 ? 0 : this.fluidTank.getFluidAmount(index) * i / this.fluidTank.getCapacity();
    }

    public static void addRecipe(UniversalRecipeInput input, UniversalRecipeOutput output) {
        recipeManager.addRecipe(input, output);
    }

    public void setFluid(FluidStack fluidStack, int index) {
        this.fluidTank.setFluid(fluidStack, index);
    }

    public void setFluidAmount(int amount, int index) {
        this.fluidTank.setFluidAmount(amount, index);
    }

    public int getNumberOfFluidsInTank() {
        return this.fluidTank.getNumberOfFluids();
    }

    public int getFluidAmount(int i) {
        return this.fluidTank.getFluidAmount(i);
    }

    public int getFluidID(int i) {
        return this.fluidTank.getFluidID(i);
    }

    public FluidStack getFluid(int i) {
        return this.fluidTank.getFluid(i);
    }

    public void removeFluid(int i) {
        this.fluidTank.removeFluid(i);
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }

    public static void addRecipe(FluidStack fluidStackInput1, FluidStack fluidStackInput2, ItemStack itemStackInput, FluidStack fluidStackOutput, ItemStack itemStackOutput1, ItemStack itemStackOutput2) {
        ChemicalReactorTileEntity.addRecipe(new UniversalRecipeInput(Arrays.asList(fluidStackInput1, fluidStackInput2), Arrays.asList(itemStackInput)), new UniversalRecipeOutput(Arrays.asList(fluidStackOutput), Arrays.asList(itemStackOutput1, itemStackOutput2), 200));
    }

    public static void addSpecialConditionsRecipe(FluidStack fluidStackInput1, FluidStack fluidStackInput2, ItemStack itemStackInput, FluidStack fluidStackOutput, ItemStack itemStackOutput1, ItemStack itemStackOutput2) {
        ChemicalReactorTileEntity.addRecipe(new UniversalRecipeInput(Arrays.asList(fluidStackInput1, fluidStackInput2), Arrays.asList(itemStackInput)), new UniversalRecipeOutput(Arrays.asList(fluidStackOutput), Arrays.asList(itemStackOutput1, itemStackOutput2), 200, true));
    }

    public IHLFluidTank getFluidTank() {
        return this.fluidTank;
    }
}

