/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.chemistry;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotOutput;
import ihl.processing.chemistry.CryogenicDistillerContainer;
import ihl.processing.chemistry.CryogenicDistillerGui;
import ihl.processing.invslots.InvSlotConsumableLiquidIHL;
import ihl.processing.metallurgy.BasicElectricMotorTileEntity;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLFluidTank;
import ihl.utils.IHLUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class CryogenicDistillerTileEntity
extends BasicElectricMotorTileEntity
implements IFluidHandler {
    public final InvSlotConsumableLiquidIHL fillInputSlotInput;
    public final InvSlotOutput fluidItemsSlot;
    public final InvSlotConsumableLiquidIHL fillInputSlotProducts;
    private int processTimer = 0;
    private IHLFluidTank fluidTankInput = new IHLFluidTank(8000);
    public IHLFluidTank fluidTankProducts = new IHLFluidTank(8000);
    protected static final UniversalRecipeManager recipeManager = new UniversalRecipeManager();

    public CryogenicDistillerTileEntity() {
        this.isGuiScreenOpened = true;
        this.fillInputSlotInput = new InvSlotConsumableLiquidIHL(this, "fillInputSlotInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Fill);
        this.fillInputSlotProducts = new InvSlotConsumableLiquidIHL(this, "fillInputSlotProducts", -1, InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Fill);
        this.fluidItemsSlot = new InvSlotOutput((TileEntityInventory)this, "fluidCellsOutput", 2, 2);
    }

    @Override
    public String func_145825_b() {
        return "CryogenicDistiller";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing());
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        if (this.processTimer++ > 20 && this.engine.correctContent()) {
            this.getClass();
            if (this.energy >= 0.1 / (double)this.engine.getEfficiency()) {
                IFluidHandler frontFH;
                IFluidHandler topFH;
                TileEntity teOnTop;
                this.getClass();
                this.energy -= 0.1 / (double)this.engine.getEfficiency();
                this.processTimer = 0;
                dir = dir.getOpposite();
                Block block = this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                if (block != null && block.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) && this.fluidTankInput.getFluidAmount() < 1000 && (this.fluidTankInput.getFluid() == null || this.fluidTankInput.getNumberOfFluids() <= 1 && this.fluidTankInput.getFluid().getFluid() == FluidRegistry.getFluid((String)"air"))) {
                    this.fluidTankInput.fill(IHLUtils.getFluidStackWithSize("air", 1000 - (this.fluidTankInput.getFluid() != null ? this.fluidTankInput.getFluid().amount : 0)), true);
                }
                if ((teOnTop = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) instanceof IFluidHandler && this.fluidTankProducts.getLigthestFluid() != null && (topFH = (IFluidHandler)teOnTop).canFill(ForgeDirection.DOWN, this.fluidTankProducts.getLigthestFluid().getFluid())) {
                    FluidStack fsToDrain = this.fluidTankProducts.getLigthestFluid().copy();
                    fsToDrain.amount = topFH.fill(ForgeDirection.DOWN, fsToDrain, true);
                    this.fluidTankProducts.drain(fsToDrain, true);
                }
                ForgeDirection orientation = ForgeDirection.getOrientation((int)this.getFacing());
                TileEntity teOnFront = this.field_145850_b.func_147438_o(this.field_145851_c + orientation.offsetX, this.field_145848_d, this.field_145849_e + orientation.offsetZ);
                if (teOnFront instanceof IFluidHandler && this.fluidTankProducts.getFluid() != null && (frontFH = (IFluidHandler)teOnFront).canFill(orientation, this.fluidTankProducts.getFluid().getFluid())) {
                    FluidStack fsToDrain = this.fluidTankProducts.getFluid().copy();
                    fsToDrain.amount = frontFH.fill(orientation, fsToDrain, true);
                    this.fluidTankProducts.drain(fsToDrain, true);
                }
            }
        }
        IHLUtils.handleFluidSlotsBehaviour(this.fillInputSlotProducts, null, this.fluidItemsSlot, this.fluidTankProducts);
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        return IHLUtils.getThisModItemStack("cryogenicDistiller");
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean arg1) {
        return new CryogenicDistillerGui(new CryogenicDistillerContainer(player, this));
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        return new CryogenicDistillerContainer(player, this);
    }

    @Override
    public void operate() {
        if (!this.fillInputSlotInput.isEmpty() && this.fluidTankInput.getFluid().getFluid() == FluidRegistry.getFluid((String)"air")) {
            IHLUtils.handleFluidSlotsBehaviour(this.fillInputSlotInput, null, this.fluidItemsSlot, this.fluidTankInput);
        } else {
            UniversalRecipeInput ri = recipeManager.getRecipeInput(this.getInput());
            Iterator<FluidStack> listFluidOutputsIterator = this.getOutput().getFluidOutputs().iterator();
            while (listFluidOutputsIterator.hasNext()) {
                this.fluidTankProducts.fill(listFluidOutputsIterator.next(), true);
            }
            this.fluidTankInput.drain(ri.getFluidInputs().get(0), true);
        }
    }

    public UniversalRecipeOutput getOutput() {
        return recipeManager.getOutputFor(this.getInput(), false, false);
    }

    @Override
    public List[] getInput() {
        return new List[]{Arrays.asList(this.fluidTankInput.getLigthestFluid()), null};
    }

    @Override
    public boolean canOperate() {
        return this.engine.correctContent() && this.getOutput() != null;
    }

    @Override
    public void onGuiClosed(EntityPlayer arg0) {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fluidTankInput.readFromNBT(nbttagcompound.func_74775_l("fluidTankInput"));
        this.fluidTankProducts.readFromNBT(nbttagcompound.func_74775_l("fluidTankProducts"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound fluidTankInputTag = new NBTTagCompound();
        this.fluidTankInput.writeToNBT(fluidTankInputTag);
        nbttagcompound.func_74782_a("fluidTankInput", (NBTBase)fluidTankInputTag);
        NBTTagCompound fluidTankProductsTag = new NBTTagCompound();
        this.fluidTankProducts.writeToNBT(fluidTankProductsTag);
        nbttagcompound.func_74782_a("fluidTankProducts", (NBTBase)fluidTankProductsTag);
    }

    public static void addRecipe(FluidStack input, FluidStack output, FluidStack output2, boolean specialCondition) {
        if (output2 != null) {
            recipeManager.addRecipe(new UniversalRecipeInput(Arrays.asList(input), null), new UniversalRecipeOutput(Arrays.asList(output, output2), null, 20, specialCondition));
        } else {
            recipeManager.addRecipe(new UniversalRecipeInput(Arrays.asList(input), null), new UniversalRecipeOutput(Arrays.asList(output), null, 20, specialCondition));
        }
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }

    public boolean canProcess() {
        return this.engine.correctContent() && this.energy >= (double)this.maxStorage && this.fluidTankInput.getFluidAmount() < 1000;
    }

    public boolean canDrain(ForgeDirection dir, Fluid arg1) {
        return dir.getOpposite().equals((Object)ForgeDirection.getOrientation((int)this.getFacing())) || dir.equals((Object)ForgeDirection.UP);
    }

    public boolean canFill(ForgeDirection dir, Fluid fluid) {
        return dir.equals((Object)ForgeDirection.getOrientation((int)this.getFacing()));
    }

    public FluidStack drain(ForgeDirection dir, FluidStack fstack, boolean doDrain) {
        if (this.canDrain(dir, null)) {
            return this.fluidTankProducts.drain(fstack, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection dir, int amount, boolean doDrain) {
        if (this.canDrain(dir, null)) {
            if (dir.equals((Object)ForgeDirection.UP)) {
                return this.fluidTankProducts.drainLightest(amount, doDrain);
            }
            return this.fluidTankProducts.drain(amount, doDrain);
        }
        return null;
    }

    public int fill(ForgeDirection dir, FluidStack fstack, boolean doFill) {
        if (fstack != null && fstack.getFluid() != null && this.canFill(dir, fstack.getFluid())) {
            this.fluidTankInput.drain(IHLUtils.getFluidStackWithSize("air", this.fluidTankInput.getCapacity()), true);
            return this.fluidTankInput.fill(fstack, doFill);
        }
        return 0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection dir) {
        return new FluidTankInfo[]{this.fluidTankInput.getInfo(), this.fluidTankProducts.getInfo()};
    }
}

