/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.chemistry;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.network.NetworkManager;
import ihl.IHLMod;
import ihl.flexible_cable.IEnergyNetNode;
import ihl.flexible_cable.IHLCable;
import ihl.flexible_cable.IHLCableSet;
import ihl.flexible_cable.IHLGrid;
import ihl.flexible_cable.NodeEntity;
import ihl.processing.chemistry.ApparatusProcessableInvSlot;
import ihl.processing.chemistry.ElectrolysisBathContainer;
import ihl.processing.chemistry.ElectrolysisBathGui;
import ihl.processing.invslots.InvSlotConsumableLiquidIHL;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLFluidTank;
import ihl.utils.IHLUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class ElectrolysisBathTileEntity
extends TileEntityInventory
implements IHasGui,
INetworkClientTileEntityEventListener,
IFluidHandler,
IEnergyNetNode {
    private static final UniversalRecipeManager recipeManager = new UniversalRecipeManager();
    public final ApparatusProcessableInvSlot input;
    public final InvSlotConsumableLiquidIHL drainInputSlot;
    public final InvSlotConsumableLiquidIHL fillInputSlot;
    public final InvSlotOutput emptyFluidItemsSlot;
    public short progress;
    protected short operationLength = (short)20000;
    private final IHLFluidTank fluidTank = new IHLFluidTank(2000);
    public short temperature = (short)20;
    private ItemStack fractionalOutput;
    private int fractionalOutputAmount = 0;
    private double connectionX;
    private double connectionY;
    private double connectionZ;
    private int gridID = -1;
    private final IHLCableSet cableList = new IHLCableSet();
    private int countdownTimer = 200;
    private boolean startCableBurning = false;
    private IHLCable cableToBurn;
    private static final double resistance = 5.0;

    public ElectrolysisBathTileEntity() {
        this.drainInputSlot = new InvSlotConsumableLiquidIHL(this, "drainInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.TOP, InvSlotConsumableLiquid.OpType.Drain);
        this.fillInputSlot = new InvSlotConsumableLiquidIHL(this, "fillInput", -1, InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Fill);
        this.emptyFluidItemsSlot = new InvSlotOutput((TileEntityInventory)this, "fluidCellsOutput", 2, 1);
        this.input = new ApparatusProcessableInvSlot(this, "input", 3, InvSlot.Access.IO, 1, 64);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.cableList.loadFromNBT(nbttagcompound);
        this.gridID = nbttagcompound.func_74762_e("gridID");
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
        if (nbttagcompound.func_74764_b("fractionalOutput")) {
            this.fractionalOutput.func_77963_c(nbttagcompound.func_74775_l("fractionalOutput"));
            this.fractionalOutputAmount = nbttagcompound.func_74762_e("fractionalOutputAmount");
        }
        this.setConnectionX(nbttagcompound.func_74769_h("connectionX"));
        this.setConnectionY(nbttagcompound.func_74769_h("connectionY"));
        this.setConnectionZ(nbttagcompound.func_74769_h("connectionZ"));
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.cableList.saveToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("gridID", this.gridID);
        nbttagcompound.func_74780_a("connectionX", this.getConnectionX());
        nbttagcompound.func_74780_a("connectionY", this.getConnectionY());
        nbttagcompound.func_74780_a("connectionZ", this.getConnectionZ());
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
        NBTTagCompound fractionalOutputNBT = new NBTTagCompound();
        if (this.fractionalOutput != null) {
            this.fractionalOutput.func_77955_b(fractionalOutputNBT);
            nbttagcompound.func_74782_a("fractionalOutput", (NBTBase)fractionalOutputNBT);
            nbttagcompound.func_74768_a("fractionalOutputAmount", this.fractionalOutputAmount);
        }
    }

    public void onLoaded() {
        super.onLoaded();
        if (this.gridID != -1) {
            IHLGrid grid = IHLMod.enet.getGrid(this.gridID);
            grid.telist.add(this);
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("electrolysisBath");
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void setFacing(short facing1) {
        short facing2 = (short)Math.max(facing1, 2);
        double range = 0.1;
        AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)(this.getConnectionX() - range), (double)(this.getConnectionY() - range), (double)(this.getConnectionZ() - range), (double)(this.getConnectionX() + range), (double)(this.getConnectionY() + range), (double)(this.getConnectionZ() + range));
        List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
        super.setFacing(facing2);
        this.setConnectionX((double)this.field_145851_c + 0.5);
        this.setConnectionY((double)this.field_145848_d + 1.5);
        this.setConnectionZ((double)this.field_145849_e + 0.5);
        if (!nodeList.isEmpty()) {
            for (NodeEntity ne : nodeList) {
                if (!ne.isFixed || !this.cableList.containsID(ne.getChainUniqueID())) continue;
                ne.func_70107_b(this.getConnectionX(), this.getConnectionY(), this.getConnectionZ());
            }
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.startCableBurning) {
            --this.countdownTimer;
            if (this.countdownTimer <= 0) {
                double range = (double)this.cableToBurn.length * 2.0 + 32.0;
                AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
                List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
                if (!nodeList.isEmpty()) {
                    for (NodeEntity ne : nodeList) {
                        if (ne.getChainUniqueID() != this.cableToBurn.cableID) continue;
                        ne.func_70106_y();
                    }
                }
                IHLMod.enet.removeCableAndSplitGrids(this.gridID, this.cableToBurn);
                this.startCableBurning = false;
                this.countdownTimer = 200;
            }
        }
        this.temperature = (short)(this.fluidTank.getTemperature() - 273);
        IHLUtils.handleFluidSlotsBehaviour(this.fillInputSlot, this.drainInputSlot, this.emptyFluidItemsSlot, this.fluidTank);
        boolean needsInvUpdate = false;
        if (this.canOperate()) {
            this.setActive(true);
            if (this.progress == 0) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 0, true);
            }
            if (this.getGrid().energy > 0.0) {
                double voltage = this.getGrid().getSinkVoltage(this);
                double drawEnergy = voltage * voltage / 5.0;
                this.progress = (short)((double)this.progress + drawEnergy);
                this.getGrid().drawEnergy(drawEnergy, this);
            }
            if (this.progress >= this.operationLength) {
                this.operate();
                needsInvUpdate = true;
                this.progress = 0;
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 2, true);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 1, true);
            }
            if (!this.canOperate()) {
                this.progress = 0;
            }
            this.setActive(false);
        }
    }

    public FluidStack drain(ForgeDirection from, int amount, boolean doDrain) {
        FluidStack fstack = this.fluidTank.drain(amount, doDrain);
        return fstack;
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return true;
    }

    public boolean canFill(ForgeDirection direction, Fluid arg1) {
        return true;
    }

    public String func_145825_b() {
        return "impregnatingMachine";
    }

    private int mX() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    private int mZ() {
        switch (this.getFacing()) {
            case 3: {
                return 1;
            }
            case 2: {
                return -1;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
        }
        return -1;
    }

    private short getFacingFromXZ(int x, int z) {
        switch (x) {
            case -1: {
                return 4;
            }
            case 1: {
                return 5;
            }
        }
        switch (z) {
            case 1: {
                return 3;
            }
            case -1: {
                return 2;
            }
        }
        return 2;
    }

    public float getRenderLiquidLevel() {
        return (float)this.fluidTank.getFluidAmount() / (float)this.fluidTank.getCapacity();
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        IFluidHandler ifhte;
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (te instanceof IFluidHandler && this.fluidTank.getFluid() != null && (ifhte = (IFluidHandler)te).canFill(ForgeDirection.UP, this.fluidTank.getFluid().getFluid())) {
            int filled = ifhte.fill(ForgeDirection.UP, this.fluidTank.drain(this.getTankAmount(), false), true);
            this.fluidTank.drain(filled, true);
        }
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / this.operationLength;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean arg1) {
        return new ElectrolysisBathGui(new ElectrolysisBathContainer(player, this));
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        this.fluidTank.sortFluidsByDensity();
        return new ElectrolysisBathContainer(player, this);
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public boolean canOperate() {
        return this.getOutput() != null;
    }

    public UniversalRecipeOutput getOutput() {
        return recipeManager.getOutputFor(this.getInput(), false, false);
    }

    public List[] getInput() {
        for (int i = 0; i < this.fluidTank.getNumberOfFluids(); ++i) {
            List[] rInput = new List[]{Arrays.asList(this.fluidTank.getFluid(i)), this.input.getItemStackList()};
            if (recipeManager.getOutputFor(rInput, false, false) == null) continue;
            return rInput;
        }
        return new List[]{Arrays.asList(this.fluidTank.getFluid()), this.input.getItemStackList()};
    }

    public void operate() {
        UniversalRecipeInput recipeInput = recipeManager.getRecipeInput(this.getInput());
        UniversalRecipeOutput output1 = this.getOutput();
        for (int i = 0; i < recipeInput.getItemInputs().size(); ++i) {
            this.input.consume(i, recipeInput.getItemInputs().get(i).getAmount());
        }
        this.fluidTank.fill(output1.getFluidOutputs(), true);
    }

    public FluidStack drain(ForgeDirection arg0, FluidStack fluidStack, boolean doDrain) {
        if (this.fluidTank.getFluid().containsFluid(fluidStack)) {
            return this.fluidTank.drain(fluidStack.amount, doDrain);
        }
        return null;
    }

    public int fill(ForgeDirection arg0, FluidStack arg1, boolean arg2) {
        return this.fluidTank.fill(arg1, arg2);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection arg0) {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    public boolean needsFluid() {
        return this.fluidTank.getFluidAmount() <= this.fluidTank.getCapacity();
    }

    public FluidStack getFluidStackfromTank() {
        return this.fluidTank.getFluid();
    }

    public int getTankAmount() {
        return this.fluidTank.getFluidAmount();
    }

    public int gaugeLiquidScaled(int i, int index) {
        return this.fluidTank.getFluidAmount() <= 0 ? 0 : this.fluidTank.getFluidAmount(index) * i / this.fluidTank.getCapacity();
    }

    public static void addRecipe(UniversalRecipeInput input, UniversalRecipeOutput output) {
        recipeManager.addRecipe(input, output);
    }

    public void setFluid(FluidStack fluidStack, int index) {
        this.fluidTank.setFluid(fluidStack, index);
    }

    public void setFluidAmount(int amount, int index) {
        this.fluidTank.setFluidAmount(amount, index);
    }

    public int getNumberOfFluidsInTank() {
        return this.fluidTank.getNumberOfFluids();
    }

    public int getFluidAmount(int i) {
        return this.fluidTank.getFluidAmount(i);
    }

    public int getFluidID(int i) {
        return this.fluidTank.getFluidID(i);
    }

    public FluidStack getFluid(int i) {
        return this.fluidTank.getFluid(i);
    }

    public void removeFluid(int i) {
        this.fluidTank.removeFluid(i);
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }

    public IHLFluidTank getFluidTank() {
        return this.fluidTank;
    }

    @Override
    public double getMaxAllowableVoltage() {
        return 64000.0;
    }

    @Override
    public void initiateCableBurnout(IHLCable cable) {
        this.cableToBurn = cable;
        double range = (double)cable.length * 2.0 + 32.0;
        AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
        List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
        if (!nodeList.isEmpty()) {
            for (NodeEntity ne : nodeList) {
                if (ne.getChainUniqueID() != cable.cableID) continue;
                ne.func_70015_d(10);
            }
        }
        this.startCableBurning = true;
    }

    @Override
    public double getConnectionX() {
        return this.connectionX;
    }

    public void setConnectionX(double connectionX) {
        this.connectionX = connectionX;
    }

    @Override
    public double getConnectionY() {
        return this.connectionY;
    }

    public void setConnectionY(double connectionY) {
        this.connectionY = connectionY;
    }

    @Override
    public double getConnectionZ() {
        return this.connectionZ;
    }

    public void setConnectionZ(double connectionZ) {
        this.connectionZ = connectionZ;
    }

    @Override
    public boolean addCable(IHLCable cable) {
        return this.cableList.add(cable);
    }

    @Override
    public IHLCableSet getCableList() {
        return this.cableList;
    }

    @Override
    public void setGrid(int newGridID) {
        if (newGridID != -1) {
            this.gridID = newGridID;
            IHLMod.enet.getGrid((int)newGridID).telist.add(this);
            IHLMod.enet.getGrid((int)newGridID).isGridValid = true;
        } else {
            this.gridID = -1;
        }
    }

    @Override
    public int getGridID() {
        return this.gridID;
    }

    @Override
    public IHLGrid getGrid() {
        return IHLMod.enet.getGrid(this.gridID);
    }

    @Override
    public void removeAttachedChains() {
        if (!this.getCableList().isEmpty()) {
            double range = 128.0;
            AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
            List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
            if (!nodeList.isEmpty()) {
                for (NodeEntity ne : nodeList) {
                    if (!this.cableList.containsID(ne.getChainUniqueID())) continue;
                    ne.func_70106_y();
                }
            }
            for (IHLCable c : this.getCableList()) {
                ItemStack is = IHLUtils.getThisModItemStack(c.itemName);
                is.field_77990_d = new NBTTagCompound();
                is.field_77990_d.func_74757_a("firstConnection", false);
                is.field_77990_d.func_74768_a("length", c.length);
                is.field_77990_d.func_74768_a("fullLength", c.length);
                EntityItem eitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, is);
                this.field_145850_b.func_72838_d((Entity)eitem);
            }
            if (this.gridID != -1) {
                IHLMod.enet.splitGrids(this.gridID, this);
            }
            this.getCableList().clear();
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }
}

