/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.metallurgy;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.network.NetworkManager;
import ihl.flexible_cable.IWire;
import ihl.processing.metallurgy.BasicElectricMotorTileEntity;
import ihl.processing.metallurgy.CoilerContainer;
import ihl.processing.metallurgy.CoilerGui;
import ihl.processing.metallurgy.IProductionLine;
import ihl.utils.IHLUtils;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class CoilerTileEntity
extends BasicElectricMotorTileEntity
implements IProductionLine {
    public final InvSlotOutput output = new InvSlotOutput((TileEntityInventory)this, "output", 1, 1);
    private int activeTimer = 0;
    public boolean hasCoil = false;
    public boolean hasEngine = false;

    public CoilerTileEntity() {
        this.isGuiScreenOpened = true;
    }

    @Override
    public String func_145825_b() {
        return "Coiler";
    }

    public List<String> getNetworkedFields() {
        List fields = super.getNetworkedFields();
        fields.add("hasCoil");
        fields.add("hasEngine");
        return fields;
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        return IHLUtils.getThisModItemStack("coiler");
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean arg1) {
        return new CoilerGui(new CoilerContainer(player, this));
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        return new CoilerContainer(player, this);
    }

    @Override
    public boolean canOperate() {
        return false;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.activeTimer > 0) {
            --this.activeTimer;
        } else {
            this.setActive(false);
        }
        if (this.output.isEmpty() && this.hasCoil) {
            this.hasCoil = false;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "hasCoil");
        } else if (!this.output.isEmpty() && !this.hasCoil) {
            this.hasCoil = true;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "hasCoil");
        }
        if (this.engine.isEmpty() && this.hasEngine) {
            this.hasEngine = false;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "hasEngine");
        } else if (this.engine.correctContent() && !this.hasEngine) {
            this.hasEngine = true;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "hasEngine");
        }
    }

    @Override
    public void operate() {
    }

    @Override
    public List[] getInput() {
        return null;
    }

    @Override
    public boolean canProcess(ItemStack cable) {
        if (this.engine.correctContent() && this.energy > 1.0 / (double)this.engine.getEfficiency() && cable.func_77973_b() instanceof IWire) {
            if (this.output.isEmpty()) {
                return true;
            }
            return this.output.get().func_77969_a(cable);
        }
        return false;
    }

    @Override
    public void process(ItemStack cable) {
        if (cable.func_77973_b() instanceof IWire) {
            this.energy -= 1.0 / (double)this.engine.getEfficiency();
            if (this.output.isEmpty()) {
                this.setActive(true);
                this.activeTimer = 800;
                this.output.put(cable);
                this.hasCoil = true;
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "hasCoil");
            } else {
                this.setActive(true);
                this.activeTimer = 800;
                int length = this.output.get().field_77990_d.func_74762_e(((IWire)this.output.get().func_77973_b()).getTag());
                int fullLength = this.output.get().field_77990_d.func_74762_e(((IWire)this.output.get().func_77973_b()).getTagSecondary());
                int lengthToAdd = cable.field_77990_d.func_74762_e(((IWire)cable.func_77973_b()).getTag());
                int fullLengthToAdd = cable.field_77990_d.func_74762_e(((IWire)cable.func_77973_b()).getTagSecondary());
                this.output.get().field_77990_d.func_74768_a(((IWire)this.output.get().func_77973_b()).getTag(), length + lengthToAdd);
                this.output.get().field_77990_d.func_74768_a(((IWire)this.output.get().func_77973_b()).getTagSecondary(), fullLength + fullLengthToAdd);
            }
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }
}

