/*
 * Decompiled with CFR 0.152.
 */
package ihl.tunneling_shield;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.IC2Items;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.IUpgradableBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableId;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.network.NetworkManager;
import ic2.core.util.StackUtil;
import ihl.IHLMod;
import ihl.tunneling_shield.DriverContainer;
import ihl.tunneling_shield.DriverEntity;
import ihl.tunneling_shield.DriverGui;
import ihl.tunneling_shield.HorizontalMiningPipe;
import ihl.tunneling_shield.HydrotransportPulpRegeneratorTileEntity;
import ihl.tunneling_shield.IMultiBlock;
import ihl.tunneling_shield.MultiBlockSpacerBlock;
import ihl.utils.IHLInvSlotDischarge;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class DriverTileEntity
extends TileEntityInventory
implements IEnergySink,
IHasGui,
INetworkClientTileEntityEventListener,
IUpgradableBlock,
IMultiBlock {
    private AudioSource audioSource;
    private AudioSource startAS;
    private AudioSource loopAS;
    private AudioSource stopAS;
    private int startUpCounter = 0;
    public final InvSlotConsumableId miningPipesSlot;
    public final InvSlotUpgrade upgradeSlot;
    public final IHLInvSlotDischarge dischargeSlot;
    public int tier;
    private int defaultTier;
    public int maxStorage;
    private int defaultMaxStorage;
    public boolean hasShield = false;
    private boolean prevHasShield = false;
    public int shaftDestroyedAtA = 0;
    private int prevShaftDestroyedAtA = 0;
    public int shaftDestroyedAtB = 0;
    private int prevShaftDestroyedAtB = 0;
    public int modelShift = 0;
    public int modelShiftSpeed;
    private int defaultModelShiftSpeed;
    public int blockShift = 1;
    private int lastBlockShift = 1;
    private double energy = 0.0;
    private double energyConsume;
    private double defaultEnergyConsume;
    private boolean addedToEnergyNet = false;
    public int xShaftMin;
    public int xShaftMax;
    public int yShaft;
    public int zShaftMin;
    public int zShaftMax;
    public int xShieldMin;
    public int xShieldMax;
    public int yShieldMin;
    public int yShieldMax;
    public int zShieldMin;
    public int zShieldMax;
    private int updateChecksum = 0;
    private boolean renderHelperExist = false;
    public DriverEntity renderHelper;
    public boolean reverseModeOn = false;
    public boolean autoReverseModeOn = true;
    private float lastModelShiftAmount = 1.0f;
    private List<Block> blockBlackList = new ArrayList<Block>();
    private List<Block> blockWhiteList = new ArrayList<Block>();
    public boolean advancedShield = false;

    public DriverTileEntity() {
        ItemStack stack;
        Block block;
        String blockName;
        this.miningPipesSlot = new InvSlotConsumableId((TileEntityInventory)this, "miningPipesSlot", 1, 12, new Item[]{Ic2Items.miningPipe.func_77973_b()});
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 2, 4);
        this.dischargeSlot = new IHLInvSlotDischarge(this, 1, InvSlot.Access.IO, this.tier, InvSlot.InvSide.BOTTOM);
        this.defaultTier = IHLMod.config.ts02DefaultTier;
        this.defaultMaxStorage = IHLMod.config.ts02DefaultMaxEnergyStorage;
        this.defaultModelShiftSpeed = IHLMod.config.ts02DefaultSpeed;
        this.defaultEnergyConsume = IHLMod.config.ts02DefaultOperationEUCost;
        this.tier = this.defaultTier;
        this.maxStorage = this.defaultMaxStorage;
        this.modelShiftSpeed = this.defaultModelShiftSpeed;
        this.energyConsume = this.defaultEnergyConsume;
        for (int i6 = 0; i6 < IHLMod.config.ts02BlockBlackListString.length; ++i6) {
            blockName = IHLMod.config.ts02BlockBlackListString[i6];
            block = Block.func_149684_b((String)blockName);
            if (block == null && (stack = IC2Items.getItem((String)blockName)) != null) {
                block = StackUtil.getBlock((ItemStack)stack);
            }
            if (block == null) continue;
            this.blockBlackList.add(block);
        }
        for (int i7 = 0; i7 < IHLMod.config.ts02BlockWhiteListString.length; ++i7) {
            blockName = IHLMod.config.ts02BlockWhiteListString[i7];
            block = Block.func_149684_b((String)blockName);
            if (block == null && (stack = IC2Items.getItem((String)blockName)) != null) {
                block = StackUtil.getBlock((ItemStack)stack);
            }
            if (block == null) continue;
            this.blockWhiteList.add(block);
        }
        this.blockWhiteList.add(IHLMod.multiBlockSpacerBlock);
        this.blockWhiteList.add(IHLMod.horizontalMiningPipeX);
        this.blockWhiteList.add(IHLMod.horizontalMiningPipeZ);
        this.blockWhiteList.add(Blocks.field_150350_a);
    }

    public List<String> getNetworkedFields() {
        List fields = super.getNetworkedFields();
        fields.add("hasShield");
        fields.add("modelShift");
        fields.add("shaftDestroyedAtA");
        fields.add("shaftDestroyedAtB");
        fields.add("tier");
        fields.add("modelShiftSpeed");
        fields.add("maxStorage");
        fields.add("reverseModeOn");
        fields.add("autoReverseModeOn");
        fields.add("advancedShield");
        return fields;
    }

    public boolean enableUpdateEntity() {
        return true;
    }

    public String getShieldSoundFile() {
        return "Machines/MinerOp.ogg";
    }

    public String getStartSoundFile() {
        return "Machines/IHL Tunneling Shield/TS02Start.ogg";
    }

    public String getLoopSoundFile() {
        return "Machines/IHL Tunneling Shield/TS02Loop.ogg";
    }

    public String getStopSoundFile() {
        return "Machines/IHL Tunneling Shield/TS02Stop.ogg";
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
        if (IC2.platform.isRendering() && (this.startAS == null || this.loopAS == null || this.stopAS == null)) {
            this.startAS = IC2.audioManager.createSource((Object)this, PositionSpec.Center, this.getStartSoundFile(), false, false, 0.5f);
            this.loopAS = IC2.audioManager.createSource((Object)this, PositionSpec.Center, this.getLoopSoundFile(), true, false, 0.5f);
            this.stopAS = IC2.audioManager.createSource((Object)this, PositionSpec.Center, this.getStopSoundFile(), false, false, 0.5f);
        }
    }

    public void onUnloaded() {
        super.onUnloaded();
        if (IC2.platform.isRendering() && this.audioSource != null) {
            this.audioSource.stop();
            this.audioSource = null;
            this.startAS.stop();
            this.loopAS.stop();
            this.stopAS.stop();
            this.startAS = null;
            this.loopAS = null;
            this.stopAS = null;
            IC2.audioManager.removeSources((Object)this);
        }
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
    }

    public void func_145845_h() {
        Block block;
        int i;
        super.func_145845_h();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
        if (this.dischargeSlot.tier != this.tier) {
            this.dischargeSlot.tier = this.tier;
        }
        int[] xyz = new int[]{0, 0, 1, 0, -1, -1, 1, 1, -1, 2, 0, 2, 1, 2, -1, -2, 0, -2, 1, -2, -1, 0};
        boolean freeToDigForward = true;
        boolean freeToMoveBack = true;
        if (this.blockShift >= 127) {
            freeToDigForward = false;
            if (this.autoReverseModeOn && !this.reverseModeOn && this.field_145850_b.field_72995_K) {
                this.reverseModeOn = true;
                ((NetworkManager)IC2.network.get()).initiateClientTileEntityEvent((TileEntity)this, 0);
            }
        } else {
            for (i = 0; i < 21; ++i) {
                block = this.field_145850_b.func_147439_a(this.field_145851_c + xyz[i + 1] * this.mZ() + (this.blockShift + 1) * this.mX(), this.field_145848_d + xyz[i], this.field_145849_e + xyz[i + 1] * this.mX() + (this.blockShift + 1) * this.mZ());
                if (!this.blockBlackList.contains(block)) continue;
                freeToDigForward = false;
            }
        }
        if (this.blockShift <= 3) {
            freeToMoveBack = false;
        } else {
            for (i = 0; i < 21; ++i) {
                block = this.field_145850_b.func_147439_a(this.field_145851_c + xyz[i + 1] * this.mZ() + (this.blockShift - 3) * this.mX(), this.field_145848_d + xyz[i], this.field_145849_e + xyz[i + 1] * this.mX() + (this.blockShift - 3) * this.mZ());
                if (block.func_149668_a(this.field_145850_b, this.field_145851_c + xyz[i + 1] * this.mZ() + (this.blockShift - 3) * this.mX(), this.field_145848_d + xyz[i], this.field_145849_e + xyz[i + 1] * this.mX() + (this.blockShift - 3) * this.mZ()) != null && !block.func_149688_o().func_76224_d() && !this.blockWhiteList.contains(block)) {
                    freeToMoveBack = false;
                }
                if ((block = this.field_145850_b.func_147439_a(this.field_145851_c + xyz[i + 1] * this.mZ() + (this.blockShift - 2) * this.mX(), this.field_145848_d + xyz[i], this.field_145849_e + xyz[i + 1] * this.mX() + (this.blockShift - 2) * this.mZ())).func_149668_a(this.field_145850_b, this.field_145851_c + xyz[i + 1] * this.mZ() + (this.blockShift - 2) * this.mX(), this.field_145848_d + xyz[i], this.field_145849_e + xyz[i + 1] * this.mX() + (this.blockShift - 2) * this.mZ()) == null || block.func_149688_o().func_76224_d() || this.blockWhiteList.contains(block)) continue;
                freeToMoveBack = false;
            }
        }
        if (IC2.platform.isSimulating()) {
            if (this.hasShield && this.shaftDestroyedAtA == 0 && this.energy >= this.energyConsume) {
                if (this.reverseModeOn && freeToMoveBack) {
                    this.energy -= this.energyConsume;
                    this.setActive(true);
                } else if (!this.reverseModeOn && freeToDigForward && this.miningPipesSlot.get() != null && this.miningPipesSlot.get().field_77994_a >= 1) {
                    this.energy -= this.energyConsume;
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            } else {
                this.setActive(false);
            }
        }
        if (this.getActive()) {
            if (this.reverseModeOn && this.modelShift > 0) {
                --this.modelShift;
                List entityList = this.field_145850_b.func_72872_a(Entity.class, this.getShieldBladesZone(0.0));
                double velocity = -0.5;
                if (entityList.size() > 0) {
                    for (int i0 = 0; i0 < entityList.size(); ++i0) {
                        ((Entity)entityList.get(i0)).func_70024_g(velocity * (double)this.mX(), 0.25, velocity * (double)this.mZ());
                    }
                }
            } else {
                ++this.modelShift;
                List entityLivingList = this.field_145850_b.func_72872_a(EntityLivingBase.class, this.getShieldBladesZone(2.5));
                float damage = 800.0f / (float)this.modelShiftSpeed;
                double velocity = 0.1 * (double)damage;
                if (entityLivingList.size() > 0) {
                    for (int i1 = 0; i1 < entityLivingList.size(); ++i1) {
                        ((EntityLivingBase)entityLivingList.get(i1)).func_70097_a(DamageSource.field_82729_p, damage);
                        ((EntityLivingBase)entityLivingList.get(i1)).func_70024_g(velocity * (double)this.mX(), 0.25 * velocity, velocity * (double)this.mZ());
                    }
                }
                List entityLivingList2 = this.field_145850_b.func_72872_a(EntityLiving.class, this.getShieldBladesZone(2.5));
                velocity *= 0.1;
                if (entityLivingList2.size() > 0) {
                    for (int i2 = 0; i2 < entityLivingList2.size(); ++i2) {
                        ((EntityLiving)entityLivingList2.get(i2)).func_70097_a(DamageSource.field_82729_p, damage);
                        ((EntityLiving)entityLivingList2.get(i2)).func_70024_g(velocity * (double)this.mX(), 0.25 * velocity, velocity * (double)this.mZ());
                    }
                }
            }
        }
        this.blockShift = Math.round(this.getModelShiftAmount() + 1.0f + (this.reverseModeOn ? 2.0f : 0.0f));
        if (IC2.platform.isSimulating()) {
            if (this.prevHasShield != this.hasShield) {
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "hasShield");
                this.prevHasShield = this.hasShield;
            }
            if (this.prevShaftDestroyedAtA != this.shaftDestroyedAtA) {
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "shaftDestroyedAtA");
                this.prevShaftDestroyedAtA = this.shaftDestroyedAtA;
            }
            if (this.prevShaftDestroyedAtB != this.shaftDestroyedAtB) {
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "shaftDestroyedAtB");
                this.prevShaftDestroyedAtB = this.shaftDestroyedAtB;
            }
            if (this.getDemandedEnergy() > 1.0) {
                double amount = this.dischargeSlot.discharge(this.getDemandedEnergy(), false);
                this.energy += amount;
            }
            if (this.energy > (double)this.maxStorage) {
                this.energy = this.maxStorage;
            }
        }
        if (!this.renderHelperExist && IC2.platform.isRendering()) {
            List deList = this.field_145850_b.func_72872_a(DriverEntity.class, this.getOperationZone());
            if (deList.size() > 0) {
                for (DriverEntity rh : deList) {
                    if (rh.field_70128_L) continue;
                    this.renderHelper = rh;
                    rh.parent = this;
                    this.renderHelperExist = true;
                    break;
                }
                if (!this.renderHelperExist) {
                    this.renderHelper = new DriverEntity(this.field_145850_b, this, this.field_145851_c + this.blockShift * this.mX(), this.field_145848_d, this.field_145849_e + this.blockShift * this.mZ());
                    this.renderHelperExist = true;
                }
            } else {
                this.renderHelper = new DriverEntity(this.field_145850_b, this, this.field_145851_c + this.blockShift * this.mX(), this.field_145848_d, this.field_145849_e + this.blockShift * this.mZ());
                this.renderHelperExist = true;
            }
        }
        if (IC2.platform.isRendering() && this.renderHelper != null && !this.renderHelper.field_70128_L && !this.field_145850_b.field_72996_f.contains((Object)this.renderHelper)) {
            this.field_145850_b.func_72838_d((Entity)this.renderHelper);
        }
        if (this.audioSource == null && IC2.platform.isRendering() && this.renderHelper != null) {
            this.audioSource = IC2.audioManager.createSource((Object)this.renderHelper, PositionSpec.Center, this.getShieldSoundFile(), true, false, 1.0f);
        }
        if (this.field_145850_b.field_72995_K && this.audioSource != null) {
            this.audioSource.updatePosition();
        }
        if (this.blockShift != this.lastBlockShift) {
            if (this.getActive() && this.reverseModeOn && IC2.platform.isSimulating() && this.lastModelShiftAmount - this.getModelShiftAmount() < 1.0f) {
                if (this.miningPipesSlot.get() == null) {
                    this.miningPipesSlot.put(Ic2Items.miningPipe.func_77946_l());
                } else if (this.miningPipesSlot.get().field_77994_a < 64) {
                    ++this.miningPipesSlot.get().field_77994_a;
                } else {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.miningPipesSlot.get()));
                    this.miningPipesSlot.put(Ic2Items.miningPipe.func_77946_l());
                }
                this.lastModelShiftAmount -= 1.0f;
            } else if (this.getActive() && IC2.platform.isSimulating() && this.getModelShiftAmount() - this.lastModelShiftAmount > 1.0f) {
                this.miningPipesSlot.consume(1);
                this.lastModelShiftAmount += 1.0f;
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "modelShift");
            }
            this.defineTechBlockVariables();
            if (this.getActive() && IC2.platform.isSimulating()) {
                if (this.reverseModeOn) {
                    for (int i2 = 0; i2 < 21; ++i2) {
                        if (this.blockShift >= 2) {
                            this.field_145850_b.func_147468_f(this.field_145851_c + xyz[i2 + 1] * this.mZ() + this.blockShift * this.mX(), this.field_145848_d + xyz[i2], this.field_145849_e + xyz[i2 + 1] * this.mX() + this.blockShift * this.mZ());
                        }
                        if (this.blockShift < 3) continue;
                        block = this.field_145850_b.func_147439_a(this.field_145851_c + xyz[i2 + 1] * this.mZ() + (this.blockShift - 2) * this.mX(), this.field_145848_d + xyz[i2], this.field_145849_e + xyz[i2 + 1] * this.mX() + (this.blockShift - 2) * this.mZ());
                        if (block != IHLMod.multiBlockSpacerBlock && block != IHLMod.horizontalMiningPipeX && block != IHLMod.horizontalMiningPipeZ) {
                            this.harvestDrops(block, this.field_145851_c + xyz[i2 + 1] * this.mZ() + (this.blockShift - 2) * this.mX(), this.field_145848_d + xyz[i2], this.field_145849_e + xyz[i2 + 1] * this.mX() + (this.blockShift - 2) * this.mZ(), this.field_145851_c + xyz[i2 + 1] * this.mZ() + (this.blockShift - 3) * this.mX(), this.field_145848_d + xyz[i2], this.field_145849_e + xyz[i2 + 1] * this.mX() + (this.blockShift - 3) * this.mZ(), IHLMod.multiBlockSpacerBlock);
                            continue;
                        }
                        this.field_145850_b.func_147449_b(this.field_145851_c + xyz[i2 + 1] * this.mZ() + (this.blockShift - 2) * this.mX(), this.field_145848_d + xyz[i2], this.field_145849_e + xyz[i2 + 1] * this.mX() + (this.blockShift - 2) * this.mZ(), IHLMod.multiBlockSpacerBlock);
                    }
                } else {
                    for (int i3 = 0; i3 < 21; ++i3) {
                        block = this.field_145850_b.func_147439_a(this.field_145851_c + xyz[i3 + 1] * this.mZ() + this.blockShift * this.mX(), this.field_145848_d + xyz[i3], this.field_145849_e + xyz[i3 + 1] * this.mX() + this.blockShift * this.mZ());
                        this.harvestMiningDrops(block, this.field_145851_c + xyz[i3 + 1] * this.mZ() + this.blockShift * this.mX(), this.field_145848_d + xyz[i3], this.field_145849_e + xyz[i3 + 1] * this.mX() + this.blockShift * this.mZ(), this.field_145851_c + xyz[i3 + 1] * this.mZ() + (this.blockShift - 2) * this.mX(), this.field_145848_d + xyz[i3], this.field_145849_e + xyz[i3 + 1] * this.mX() + (this.blockShift - 2) * this.mZ(), IHLMod.multiBlockSpacerBlock);
                        if (this.blockShift < 3) continue;
                        if (i3 != 0) {
                            this.field_145850_b.func_147468_f(this.field_145851_c + xyz[i3 + 1] * this.mZ() + (this.blockShift - 2) * this.mX(), this.field_145848_d + xyz[i3], this.field_145849_e + xyz[i3 + 1] * this.mX() + (this.blockShift - 2) * this.mZ());
                            continue;
                        }
                        this.field_145850_b.func_147449_b(this.field_145851_c + (this.blockShift - 2) * this.mX(), this.field_145848_d, this.field_145849_e + (this.blockShift - 2) * this.mZ(), this.mX() != 0 ? IHLMod.horizontalMiningPipeZ : IHLMod.horizontalMiningPipeX);
                    }
                }
            }
            this.lastBlockShift = this.blockShift;
        }
        if (IC2.platform.isRendering() && this.audioSource != null) {
            if (this.getActive()) {
                if (this.startUpCounter > 62) {
                    this.startUpCounter = 0;
                }
                if (this.startUpCounter == 0) {
                    this.stopAS.stop();
                    this.startAS.play();
                }
                if (this.startUpCounter < 60) {
                    ++this.startUpCounter;
                } else if (this.startUpCounter == 60) {
                    this.startAS.stop();
                    this.loopAS.play();
                    this.audioSource.play();
                    ++this.startUpCounter;
                }
            } else if (this.startUpCounter > 0) {
                this.startAS.stop();
                this.loopAS.stop();
                this.audioSource.stop();
                this.stopAS.play();
                if (this.startUpCounter < 100) {
                    ++this.startUpCounter;
                } else {
                    this.startUpCounter = 0;
                    this.stopAS.stop();
                }
            }
        } else if (IC2.platform.isRendering() && !this.getActive() && this.audioSource != null) {
            this.audioSource.stop();
        }
    }

    private void harvestMiningDrops(Block block, int x, int y, int z, int x1, int y1, int z1, Block setToBlock) {
        int meta;
        ArrayList drops;
        if (!(block == null || block == Blocks.field_150350_a || block == Blocks.field_150357_h || (drops = block.getDrops(this.field_145850_b, x, y, z, meta = this.field_145850_b.func_72805_g(x, y, z), 0)).size() <= 0 || this.advancedShield && this.handleDropsByHydrotransport(drops))) {
            for (int i1 = 0; i1 < drops.size(); ++i1) {
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)x1, (double)y1, (double)z1, (ItemStack)drops.get(i1)));
            }
        }
        this.field_145850_b.func_147449_b(x, y, z, setToBlock);
    }

    public void setOverclockRates() {
        int speedUp = 0;
        int tierUp = 0;
        int capacityUp = 0;
        int checksum = 0;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            if (this.upgradeSlot.get(i) == null) continue;
            if (this.upgradeSlot.get(i).func_77960_j() == IC2Items.getItem((String)"overclockerUpgrade").func_77960_j()) {
                speedUp += this.upgradeSlot.get((int)i).field_77994_a;
            }
            if (this.upgradeSlot.get(i).func_77960_j() == IC2Items.getItem((String)"transformerUpgrade").func_77960_j()) {
                tierUp += this.upgradeSlot.get((int)i).field_77994_a;
            }
            if (this.upgradeSlot.get(i).func_77960_j() != IC2Items.getItem((String)"energyStorageUpgrade").func_77960_j()) continue;
            capacityUp += this.upgradeSlot.get((int)i).field_77994_a;
        }
        checksum = speedUp * 4096 + tierUp * 64 + capacityUp;
        if (this.updateChecksum != checksum) {
            double correction = this.reverseModeOn ? 0.1 : 1.0;
            float newModelShiftSpeed = (float)Math.max(correction * (double)this.defaultModelShiftSpeed * Math.pow(0.7, speedUp), 10.0);
            this.modelShift = Math.round((float)this.modelShift * newModelShiftSpeed / (float)this.modelShiftSpeed);
            this.modelShiftSpeed = Math.round(newModelShiftSpeed);
            this.tier = this.defaultTier + tierUp;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "tier");
            this.maxStorage = this.defaultMaxStorage + capacityUp * 10000;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "maxStorage");
            this.energyConsume = Math.min(correction * this.defaultEnergyConsume * Math.pow(1.6, speedUp), (double)this.maxStorage);
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "modelShift");
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "modelShiftSpeed");
            this.updateChecksum = checksum;
        }
    }

    public void func_145841_b(NBTTagCompound var1) {
        super.func_145841_b(var1);
        var1.func_74780_a("energy", this.energy);
        var1.func_74757_a("hasShield", this.hasShield);
        var1.func_74757_a("autoReverseModeOn", this.autoReverseModeOn);
        var1.func_74757_a("reverseModeOn", this.reverseModeOn);
        var1.func_74757_a("advancedShield", this.advancedShield);
        var1.func_74768_a("modelShift", this.modelShift);
        var1.func_74768_a("shaftDestroyedAtA", this.shaftDestroyedAtA);
        var1.func_74768_a("shaftDestroyedAtB", this.shaftDestroyedAtB);
        var1.func_74768_a("modelShiftSpeed", this.modelShiftSpeed);
    }

    public void func_145839_a(NBTTagCompound var1) {
        super.func_145839_a(var1);
        this.hasShield = var1.func_74767_n("hasShield");
        this.autoReverseModeOn = var1.func_74767_n("autoReverseModeOn");
        this.reverseModeOn = var1.func_74767_n("reverseModeOn");
        this.advancedShield = var1.func_74767_n("advancedShield");
        this.modelShift = var1.func_74762_e("modelShift");
        this.modelShiftSpeed = var1.func_74762_e("modelShiftSpeed");
        this.energy = var1.func_74769_h("energy");
        this.shaftDestroyedAtA = var1.func_74762_e("shaftDestroyedAtA");
        this.shaftDestroyedAtB = var1.func_74762_e("shaftDestroyedAtB");
        if (this.hasShield) {
            MultiBlockSpacerBlock cfr_ignored_0 = (MultiBlockSpacerBlock)IHLMod.multiBlockSpacerBlock;
            if (!MultiBlockSpacerBlock.teList.contains(this)) {
                MultiBlockSpacerBlock cfr_ignored_1 = (MultiBlockSpacerBlock)IHLMod.multiBlockSpacerBlock;
                MultiBlockSpacerBlock.teList.add(this);
            }
            if (this.mX() == 0) {
                HorizontalMiningPipe cfr_ignored_2 = (HorizontalMiningPipe)IHLMod.horizontalMiningPipeX;
                if (!HorizontalMiningPipe.teList.contains(this)) {
                    HorizontalMiningPipe cfr_ignored_3 = (HorizontalMiningPipe)IHLMod.horizontalMiningPipeX;
                    HorizontalMiningPipe.teList.add(this);
                }
            } else {
                HorizontalMiningPipe cfr_ignored_4 = (HorizontalMiningPipe)IHLMod.horizontalMiningPipeZ;
                if (!HorizontalMiningPipe.teList.contains(this)) {
                    HorizontalMiningPipe cfr_ignored_5 = (HorizontalMiningPipe)IHLMod.horizontalMiningPipeZ;
                    HorizontalMiningPipe.teList.add(this);
                }
            }
        }
        float shift = (float)this.modelShift / (float)this.modelShiftSpeed + 1.0f;
        this.lastBlockShift = this.blockShift = Math.round(shift);
        this.defineTechBlockVariables();
        this.lastModelShiftAmount = this.getModelShiftAmount();
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return !this.hasShield && this.getFacing() != (short)side;
    }

    public short getFacing() {
        return super.getFacing();
    }

    public void setFacing(short facing) {
        short newFacing = (short)Math.max(2, facing);
        super.setFacing(newFacing);
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        this.cleanUp();
        if (this.hasShield) {
            if (this.advancedShield) {
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)(this.field_145851_c + (this.blockShift - 2) * this.mX()), (double)this.field_145848_d, (double)(this.field_145849_e + (this.blockShift - 2) * this.mZ()), IHLUtils.getThisModItemStack("advancedShieldAssemblyUnitBlock")));
            } else {
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)(this.field_145851_c + (this.blockShift - 2) * this.mX()), (double)this.field_145848_d, (double)(this.field_145849_e + (this.blockShift - 2) * this.mZ()), IHLUtils.getThisModItemStack("IHLShieldAssemblyUnitBlock")));
            }
        }
        if (this.miningPipesSlot.get() != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.miningPipesSlot.get()));
        }
        if (this.dischargeSlot.get() != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.dischargeSlot.get()));
        }
        if (this.upgradeSlot.get(0) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(0)));
        }
        if (this.upgradeSlot.get(1) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(1)));
        }
        if (this.upgradeSlot.get(2) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(2)));
        }
        if (this.upgradeSlot.get(3) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(3)));
        }
        return new ItemStack(IHLMod.driverBlock, 1);
    }

    public String func_145825_b() {
        return "IHL TS-002";
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer arg0, boolean arg1) {
        return new DriverGui(new DriverContainer(arg0, this));
    }

    public ContainerBase getGuiContainer(EntityPlayer arg0) {
        return new DriverContainer(arg0, this);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public boolean getGui(EntityPlayer player) {
        return this instanceof IHasGui ? (IC2.platform.isSimulating() ? IC2.platform.launchGui(player, (IHasGui)this) : true) : false;
    }

    public boolean canPlaceShield() {
        if (this.hasShield) {
            return false;
        }
        int[] xyz = new int[]{0, 0, 1, 0, -1, -1, 1, 1, -1, 2, 0, 2, 1, 2, -1, -2, 0, -2, 1, -2, -1, 0};
        for (int i = 0; i < 21; ++i) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + xyz[i + 1] * this.mZ() + this.mX(), this.field_145848_d + xyz[i], this.field_145849_e + xyz[i + 1] * this.mX() + this.mZ());
            if (block.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c + xyz[i + 1] * this.mZ() + this.mX(), this.field_145848_d + xyz[i], this.field_145849_e + xyz[i + 1] * this.mX() + this.mZ())) continue;
            return false;
        }
        return true;
    }

    public int mX() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    public int mZ() {
        switch (this.getFacing()) {
            case 3: {
                return 1;
            }
            case 2: {
                return -1;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
        }
        return -1;
    }

    public float getModelShiftAmount() {
        return (float)this.modelShift / (float)this.modelShiftSpeed;
    }

    private AxisAlignedBB getOperationZone() {
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        double extension = (double)this.getModelShiftAmount() + 1.0;
        return AxisAlignedBB.func_72330_a((double)((double)x + extension * (double)Math.min(this.mX(), 0) - 2.0), (double)((double)y - 2.0), (double)((double)z + extension * (double)Math.min(this.mZ(), 0) - 2.0), (double)((double)x + 3.0 + extension * (double)Math.max(this.mX(), 0)), (double)((double)y + 3.0), (double)((double)z + 3.0 + extension * (double)Math.max(this.mZ(), 0)));
    }

    private AxisAlignedBB getShieldBladesZone(double offset) {
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        double extension = (double)this.getModelShiftAmount() + offset;
        double xShieldMinD = (double)this.field_145851_c + extension * (double)this.mX() - 1.0 * (double)Math.max(this.mX(), 0) - 2.0 * (double)Math.abs(this.mZ());
        double xShieldMaxD = (double)this.field_145851_c + extension * (double)this.mX() - 1.0 * (double)Math.min(this.mX(), 0) + 3.0 * (double)Math.abs(this.mZ());
        double yShieldMinD = (double)this.field_145848_d - 2.0;
        double yShieldMaxD = (double)this.field_145848_d + 3.0;
        double zShieldMinD = (double)this.field_145849_e + extension * (double)this.mZ() - 1.0 * (double)Math.max(this.mZ(), 0) - 2.0 * (double)Math.abs(this.mX());
        double zShieldMaxD = (double)this.field_145849_e + extension * (double)this.mZ() - 1.0 * (double)Math.min(this.mZ(), 0) + 3.0 * (double)Math.abs(this.mX());
        return AxisAlignedBB.func_72330_a((double)xShieldMinD, (double)yShieldMinD, (double)zShieldMinD, (double)xShieldMaxD, (double)yShieldMaxD, (double)zShieldMaxD);
    }

    public int getStored() {
        return Math.round((float)this.energy);
    }

    public void setStored(int value) {
        this.energy = value;
    }

    public void onGuiClosed(EntityPlayer arg0) {
    }

    public void installShield() {
        if (IC2.platform.isSimulating()) {
            this.hasShield = true;
            int x = this.field_145851_c;
            int y = this.field_145848_d;
            int z = this.field_145849_e;
            MultiBlockSpacerBlock cfr_ignored_0 = (MultiBlockSpacerBlock)IHLMod.multiBlockSpacerBlock;
            MultiBlockSpacerBlock.teList.add(this);
            this.defineTechBlockVariables();
            if (this.mX() == 0) {
                HorizontalMiningPipe cfr_ignored_1 = (HorizontalMiningPipe)IHLMod.horizontalMiningPipeX;
                HorizontalMiningPipe.teList.add(this);
            } else {
                HorizontalMiningPipe cfr_ignored_2 = (HorizontalMiningPipe)IHLMod.horizontalMiningPipeZ;
                HorizontalMiningPipe.teList.add(this);
            }
            int[] xyz = new int[]{0, 0, 1, 0, -1, -1, 1, 1, -1, 2, 0, 2, 1, 2, -1, -2, 0, -2, 1, -2, -1, 0};
            for (int i1 = 0; i1 < 21; ++i1) {
                this.field_145850_b.func_147465_d(x + xyz[i1 + 1] * this.mZ() + this.mX(), y + xyz[i1], z + xyz[i1 + 1] * this.mX() + this.mZ(), IHLMod.multiBlockSpacerBlock, 0, 3);
            }
        }
    }

    public boolean isShaftCoord(int x, int y, int z) {
        if (IC2.platform.isSimulating() && y == this.yShaft && x >= this.xShaftMin && x <= this.xShaftMax && z >= this.zShaftMin && z <= this.zShaftMax) {
            int sda = (x - this.field_145851_c) * this.mX() + (z - this.field_145849_e) * this.mZ();
            if (this.shaftDestroyedAtA == 0 && this.shaftDestroyedAtB == 0) {
                this.shaftDestroyedAtA = this.shaftDestroyedAtB = sda;
            } else if (sda > this.shaftDestroyedAtB) {
                for (int i4 = this.shaftDestroyedAtB; i4 < sda; ++i4) {
                    int z1;
                    int y1;
                    int x1 = this.field_145851_c + i4 * this.mX();
                    Block block = this.field_145850_b.func_147439_a(x1, y1 = this.field_145848_d, z1 = this.field_145849_e + i4 * this.mZ());
                    if (!(block instanceof HorizontalMiningPipe)) continue;
                    this.harvestDrops(block, x1, y1, z1, x1, y1, z1, Blocks.field_150350_a);
                }
                this.shaftDestroyedAtB = sda;
            } else if (sda < this.shaftDestroyedAtA) {
                for (int i4 = sda; i4 < this.shaftDestroyedAtA; ++i4) {
                    int z1;
                    int y1;
                    int x1 = this.field_145851_c + i4 * this.mX();
                    Block block = this.field_145850_b.func_147439_a(x1, y1 = this.field_145848_d, z1 = this.field_145849_e + i4 * this.mZ());
                    if (!(block instanceof HorizontalMiningPipe)) continue;
                    this.harvestDrops(block, x1, y1, z1, x1, y1, z1, Blocks.field_150350_a);
                }
                this.shaftDestroyedAtA = sda;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isAPartOfStructure(int x, int y, int z, boolean onBlockBeak) {
        if (IC2.platform.isSimulating() && y >= this.yShieldMin && y <= this.yShieldMax && x >= this.xShieldMin && x <= this.xShieldMax && z >= this.zShieldMin && z <= this.zShieldMax) {
            if (onBlockBeak) {
                this.hasShield = false;
                this.advancedShield = false;
                this.modelShift = 0;
                this.blockShift = 1;
                this.lastBlockShift = 1;
                this.shaftDestroyedAtA = 0;
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "modelShift");
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "advancedShield");
                this.cleanUp();
            }
            return true;
        }
        return false;
    }

    public boolean isShaftCoordNN(int x, int y, int z) {
        return y == this.yShaft && x >= this.xShaftMin && x <= this.xShaftMax && z >= this.zShaftMin && z <= this.zShaftMax;
    }

    public void cleanUp() {
        int[] xyz = new int[]{0, 0, 1, 0, -1, -1, 1, 1, -1, 2, 0, 2, 1, 2, -1, -2, 0, -2, 1, -2, -1, 0};
        for (int shift = 0; shift <= this.blockShift + 1; ++shift) {
            for (int i = 0; i < 21; ++i) {
                Block block = this.field_145850_b.func_147439_a(this.field_145851_c + xyz[i + 1] * this.mZ() + shift * this.mX(), this.field_145848_d + xyz[i], this.field_145849_e + xyz[i + 1] * this.mX() + shift * this.mZ());
                if (block instanceof HorizontalMiningPipe) {
                    ArrayList drops = block.getDrops(this.field_145850_b, this.field_145851_c + xyz[i + 1] * this.mZ() + shift * this.mX(), this.field_145848_d + xyz[i], this.field_145849_e + xyz[i + 1] * this.mX() + shift * this.mZ(), 0, 3);
                    if (drops.size() > 0) {
                        for (int i1 = 0; i1 < drops.size(); ++i1) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)(this.field_145851_c + xyz[i + 1] * this.mZ() + shift * this.mX()), (double)(this.field_145848_d + xyz[i]), (double)(this.field_145849_e + xyz[i + 1] * this.mX() + shift * this.mZ()), (ItemStack)drops.get(i1)));
                        }
                    }
                    this.field_145850_b.func_147468_f(this.field_145851_c + xyz[i + 1] * this.mZ() + shift * this.mX(), this.field_145848_d + xyz[i], this.field_145849_e + xyz[i + 1] * this.mX() + shift * this.mZ());
                    continue;
                }
                if (!(block instanceof MultiBlockSpacerBlock)) continue;
                this.field_145850_b.func_147468_f(this.field_145851_c + xyz[i + 1] * this.mZ() + shift * this.mX(), this.field_145848_d + xyz[i], this.field_145849_e + xyz[i + 1] * this.mX() + shift * this.mZ());
            }
        }
    }

    private boolean handleDropsByHydrotransport(ArrayList<ItemStack> drops) {
        HydrotransportPulpRegeneratorTileEntity hprte;
        ForgeDirection direction = ForgeDirection.getOrientation((int)this.getFacing()).getOpposite();
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
        if (te instanceof HydrotransportPulpRegeneratorTileEntity && (hprte = (HydrotransportPulpRegeneratorTileEntity)te).getActive()) {
            ArrayList<ItemStack> drops1 = new ArrayList<ItemStack>();
            for (ItemStack stack : drops) {
                RecipeOutput maceratorOut = Recipes.macerator.getOutputFor(stack, false);
                if (maceratorOut != null && !maceratorOut.items.isEmpty()) {
                    Iterator maceratorOutIterator = maceratorOut.items.iterator();
                    while (maceratorOutIterator.hasNext()) {
                        drops1.add(((ItemStack)maceratorOutIterator.next()).func_77946_l());
                    }
                    continue;
                }
                drops1.add(stack);
            }
            if (hprte.outputSlot.canAdd(drops1)) {
                hprte.outputSlot.add(drops1);
            } else {
                for (int i1 = 0; i1 < drops1.size(); ++i1) {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)(this.field_145851_c + direction.offsetX), (double)(this.field_145848_d + direction.offsetY), (double)(this.field_145849_e + direction.offsetZ), (ItemStack)drops1.get(i1)));
                }
            }
            return true;
        }
        return false;
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            case 0: {
                this.reverseModeOn = !this.reverseModeOn;
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "reverseModeOn");
                this.updateChecksum = -1;
                this.setOverclockRates();
                break;
            }
            case 1: {
                this.autoReverseModeOn = !this.autoReverseModeOn;
                ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "autoReverseModeOn");
                break;
            }
        }
    }

    public void defineTechBlockVariables() {
        this.xShaftMin = this.field_145851_c + this.blockShift * Math.min(this.mX(), 0);
        this.xShaftMax = this.field_145851_c + this.blockShift * Math.max(this.mX(), 0);
        this.yShaft = this.field_145848_d;
        this.zShaftMin = this.field_145849_e + this.blockShift * Math.min(this.mZ(), 0);
        this.zShaftMax = this.field_145849_e + this.blockShift * Math.max(this.mZ(), 0);
        this.xShieldMin = this.field_145851_c + this.blockShift * this.mX() - 3 * Math.max(this.mX(), 0) - 2 * Math.abs(this.mZ());
        this.xShieldMax = this.field_145851_c + this.blockShift * this.mX() - 3 * Math.min(this.mX(), 0) + 2 * Math.abs(this.mZ());
        this.yShieldMin = this.field_145848_d - 2;
        this.yShieldMax = this.field_145848_d + 2;
        this.zShieldMin = this.field_145849_e + this.blockShift * this.mZ() - 3 * Math.max(this.mZ(), 0) - 2 * Math.abs(this.mX());
        this.zShieldMax = this.field_145849_e + this.blockShift * this.mZ() - 3 * Math.min(this.mZ(), 0) + 2 * Math.abs(this.mX());
    }

    public void harvestDrops(Block block, int x, int y, int z, int x1, int y1, int z1, Block setToBlock) {
        int meta;
        ArrayList drops;
        if (block != null && block != Blocks.field_150350_a && block != Blocks.field_150357_h && (drops = block.getDrops(this.field_145850_b, x, y, z, meta = this.field_145850_b.func_72805_g(x, y, z), 0)).size() > 0) {
            for (int i1 = 0; i1 < drops.size(); ++i1) {
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)x1, (double)y1, (double)z1, (ItemStack)drops.get(i1)));
            }
        }
        this.field_145850_b.func_147449_b(x, y, z, setToBlock);
    }

    public double getDemandedEnergy() {
        return (double)this.maxStorage - this.energy;
    }

    public int getSinkTier() {
        return this.tier;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= (double)this.maxStorage) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    public List<ItemStack> getCompatibleUpgradeList() {
        ArrayList<ItemStack> compatibleUpgrades = new ArrayList<ItemStack>();
        compatibleUpgrades.add(IC2Items.getItem((String)"overclockerUpgrade"));
        compatibleUpgrades.add(IC2Items.getItem((String)"transformerUpgrade"));
        compatibleUpgrades.add(IC2Items.getItem((String)"energyStorageUpgrade"));
        return compatibleUpgrades;
    }

    public double getEnergy() {
        return this.energy;
    }

    public void setRedstonePowered(boolean arg0) {
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    @Override
    public boolean getIsInvalid() {
        return this.func_145837_r();
    }

    public void installAdvancedShield() {
        this.installShield();
        this.advancedShield = true;
        ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "advancedShield");
    }

    public ItemStack getOutput(int arg0) {
        return null;
    }

    public int getOutputSize() {
        return 0;
    }

    public void setOutput(int arg0, ItemStack arg1) {
    }
}

