/*
 * Decompiled with CFR 0.152.
 */
package ihl.tunneling_shield;

import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.PositionSpec;
import ic2.core.item.tool.ItemToolWrench;
import ihl.tunneling_shield.DriverTileEntity;
import ihl.tunneling_shield.IMultiBlock;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class MultiBlockSpacerBlock
extends Block {
    public static Set<IMultiBlock> teList = new HashSet<IMultiBlock>();

    public MultiBlockSpacerBlock() {
        super(Material.field_151573_f);
    }

    public int func_149645_b() {
        return -2;
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        super.func_149723_a(world, x, y, z, explosion);
        this.checkIfMachinePart(world, x, y, z);
    }

    public void func_149664_b(World world, int x, int y, int z, int meta) {
        super.func_149664_b(world, x, y, z, meta);
        this.checkIfMachinePart(world, x, y, z);
    }

    private boolean checkIfMachinePart(World world, int x, int y, int z) {
        if (!teList.isEmpty()) {
            Iterator<IMultiBlock> i = teList.iterator();
            while (i.hasNext()) {
                IMultiBlock te = i.next();
                if (te != null && !te.getIsInvalid()) {
                    if (!te.isAPartOfStructure(x, y, z, true)) continue;
                    return true;
                }
                teList.remove(i);
            }
        }
        return false;
    }

    private IMultiBlock getLinkedTileEntity(World world, int x, int y, int z) {
        if (!teList.isEmpty()) {
            Iterator<IMultiBlock> i = teList.iterator();
            while (i.hasNext()) {
                IMultiBlock te = i.next();
                if (te != null && !te.getIsInvalid()) {
                    if (!te.isAPartOfStructure(x, y, z, false)) continue;
                    return te;
                }
                teList.remove(i);
            }
        }
        return null;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int flag) {
        ArrayList<ItemStack> nothing = new ArrayList<ItemStack>();
        nothing.clear();
        return nothing;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.func_149674_a(world, x, y, z, world.field_73012_v);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        if (!world.field_72995_K) {
            boolean setToAir = true;
            if (teList.size() > 0 && !teList.isEmpty()) {
                Iterator<IMultiBlock> i = teList.iterator();
                while (i.hasNext()) {
                    IMultiBlock te = i.next();
                    if (te != null && !te.getIsInvalid()) {
                        if (!te.isAPartOfStructure(x, y, z, false)) continue;
                        setToAir = false;
                        continue;
                    }
                    teList.remove(i);
                }
            }
            if (setToAir) {
                world.func_147468_f(x, y, z);
            }
        }
    }

    public int func_149738_a(World world) {
        return 200;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int i, float pos_x, float pos_y, float pos_z) {
        IMultiBlock te = this.getLinkedTileEntity(world, x, y, z);
        ItemStack currentIS = entityPlayer.field_71071_by.func_70448_g();
        if (currentIS != null && currentIS.func_77973_b() instanceof ItemToolWrench) {
            if (((ItemToolWrench)currentIS.func_77973_b()).canTakeDamage(currentIS, 10)) {
                if (IC2.platform.isRendering()) {
                    IC2.audioManager.playOnce((Object)entityPlayer, PositionSpec.Hand, "Tools/wrench.ogg", true, 1.0f);
                } else if (IC2.platform.isSimulating()) {
                    if (te instanceof DriverTileEntity) {
                        DriverTileEntity dte = (DriverTileEntity)te;
                        if (dte.hasShield) {
                            if (dte.advancedShield) {
                                world.func_72838_d((Entity)new EntityItem(world, (double)x, (double)y, (double)z, IHLUtils.getThisModItemStack("advancedShieldAssemblyUnitBlock")));
                            } else {
                                world.func_72838_d((Entity)new EntityItem(world, (double)x, (double)y, (double)z, IHLUtils.getThisModItemStack("IHLShieldAssemblyUnitBlock")));
                            }
                        }
                        dte.isAPartOfStructure(x, y, z, true);
                        world.func_147468_f(x, y, z);
                    }
                    ((ItemToolWrench)currentIS.func_77973_b()).damage(currentIS, 10, entityPlayer);
                }
            }
            return true;
        }
        return te instanceof IHasGui ? (IC2.platform.isSimulating() ? IC2.platform.launchGui(entityPlayer, (IHasGui)te) : true) : false;
    }
}

