/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import ihl.IHLMod;
import ihl.flexible_cable.FrequencyGeneratorTileEntity;
import ihl.flexible_cable.GroundingTileEntity;
import ihl.flexible_cable.IEnergyNetNode;
import ihl.flexible_cable.IHLCable;
import ihl.flexible_cable.IHLCableSet;
import ihl.flexible_cable.IHLGrid;
import ihl.flexible_cable.NodeEntity;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class BatterySwitchUnitTileEntity
extends TileEntityBlock
implements INetworkClientTileEntityEventListener,
IEnergyNetNode,
IEnergySource {
    public short progress;
    protected short operationLength = (short)200;
    public boolean isGuiScreenOpened = false;
    private double connectionX;
    private double connectionY;
    private double connectionZ;
    private int gridID = -1;
    private final IHLCableSet cableList;
    private int countdownTimer = 200;
    private boolean startCableBurning = false;
    private IHLCable cableToBurn;
    protected final double energyConsume = 128.0;
    public double energy;
    public int maxStorage = 65536;
    private boolean addedToEnergyNet = false;
    public byte mode = 0;
    private FrequencyGeneratorTileEntity frequencyGenerator;
    private Set<BatterySwitchUnitTileEntity> batteryChain = new HashSet<BatterySwitchUnitTileEntity>();
    private GroundingTileEntity grounding;
    private BatterySwitchUnitTileEntity batteryChainMaster;
    private boolean chargingMode = true;

    public BatterySwitchUnitTileEntity() {
        this.cableList = new IHLCableSet();
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
        if (this.gridID != -1) {
            IHLGrid grid = IHLMod.enet.getGrid(this.gridID);
            grid.telist.add(this);
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public void setFacing(short facing1) {
        short facing2 = (short)Math.max(facing1, 2);
        double range = 0.1;
        AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)(this.getConnectionX() - range), (double)(this.getConnectionY() - range), (double)(this.getConnectionZ() - range), (double)(this.getConnectionX() + range), (double)(this.getConnectionY() + range), (double)(this.getConnectionZ() + range));
        List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
        super.setFacing(facing2);
        this.setConnectionX((double)this.field_145851_c + 0.5);
        this.setConnectionY((double)this.field_145848_d + 1.5);
        this.setConnectionZ((double)this.field_145849_e + 0.5);
        if (!nodeList.isEmpty()) {
            for (NodeEntity ne : nodeList) {
                if (!ne.isFixed || !this.cableListContains(ne.getChainUniqueID())) continue;
                ne.func_70107_b(this.getConnectionX(), this.getConnectionY(), this.getConnectionZ());
            }
        }
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        return IHLUtils.getThisModItemStack("batterySwitchUnit");
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.cableList.saveToNBT(nbt);
        nbt.func_74780_a("connectionX", this.getConnectionX());
        nbt.func_74780_a("connectionY", this.getConnectionY());
        nbt.func_74780_a("connectionZ", this.getConnectionZ());
        nbt.func_74768_a("gridID", this.gridID);
        nbt.func_74777_a("progress", this.progress);
        nbt.func_74780_a("energy", this.energy);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cableList.loadFromNBT(nbt);
        this.setConnectionX(nbt.func_74769_h("connectionX"));
        this.setConnectionY(nbt.func_74769_h("connectionY"));
        this.setConnectionZ(nbt.func_74769_h("connectionZ"));
        this.gridID = nbt.func_74762_e("gridID");
        this.progress = nbt.func_74765_d("progress");
        this.energy = nbt.func_74769_h("energy");
    }

    @Override
    public void removeAttachedChains() {
        if (!this.getCableList().isEmpty()) {
            double range = 128.0;
            AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
            List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
            if (!nodeList.isEmpty()) {
                for (NodeEntity ne : nodeList) {
                    if (!this.cableListContains(ne.getChainUniqueID())) continue;
                    ne.func_70106_y();
                }
            }
            for (IHLCable c : this.getCableList()) {
                ItemStack is = IHLUtils.getThisModItemStack(c.itemName);
                is.field_77990_d = new NBTTagCompound();
                is.field_77990_d.func_74757_a("firstConnection", false);
                is.field_77990_d.func_74768_a("length", c.length);
                is.field_77990_d.func_74768_a("fullLength", c.length);
                EntityItem eitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, is);
                this.field_145850_b.func_72838_d((Entity)eitem);
            }
            if (this.gridID != -1) {
                IHLMod.enet.splitGrids(this.gridID, this);
            }
            this.getCableList().clear();
        }
    }

    private boolean cableListContains(int chainUniqueID) {
        for (IHLCable c : this.getCableList()) {
            if (c.cableID != chainUniqueID) continue;
            return true;
        }
        return false;
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            case 0: {
                this.isGuiScreenOpened = false;
            }
        }
    }

    public void func_145845_h() {
        if (IC2.platform.isSimulating()) {
            super.func_145845_h();
            if (this.chargingMode && this.gridID != -1 && this.energy < (double)this.maxStorage && this.grounding != null && !this.grounding.func_145837_r() && !this.batteryChain.isEmpty() && this.getGrid().energy > 0.0 && this.getGrid().getSinkVoltage(this) / (double)this.batteryChain.size() > 410.0) {
                this.energy += 128.0;
                this.getGrid().drawEnergy(128.0, this);
                if (this.getGrid().getSinkVoltage(this) / (double)this.batteryChain.size() > 500.0) {
                    this.createChainOfExplosions();
                }
            }
            if (this.chargingMode && this.batteryChainMaster != null && this.gridID == -1 && this.batteryChainMaster.gridID != -1 && this.batteryChainMaster.energy > 0.0 && this.energy < (double)this.maxStorage && this.batteryChainMaster.grounding != null && !this.batteryChainMaster.grounding.func_145837_r() && !this.batteryChainMaster.batteryChain.isEmpty() && this.batteryChainMaster.getGrid().getSinkVoltage(this.batteryChainMaster) / (double)this.batteryChainMaster.batteryChain.size() > 410.0) {
                this.energy += 128.0;
                this.batteryChainMaster.drawEnergy(128.0);
            }
            if (this.chargingMode && this.gridID != -1 && MinecraftServer.func_71276_C().func_71259_af() % 40 == 0) {
                this.checkBatteryChain();
            }
            if (this.energy >= (double)this.maxStorage) {
                this.chargingMode = false;
            }
            if (!this.chargingMode) {
                this.energy -= 0.01;
                if (this.energy < 128.0) {
                    this.chargingMode = true;
                }
            }
            if (this.startCableBurning) {
                --this.countdownTimer;
                if (this.countdownTimer <= 0) {
                    double range = (double)this.cableToBurn.length * 2.0 + 32.0;
                    AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
                    List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
                    if (!nodeList.isEmpty()) {
                        for (NodeEntity ne : nodeList) {
                            if (ne.getChainUniqueID() != this.cableToBurn.cableID) continue;
                            ne.func_70106_y();
                        }
                    }
                    IHLMod.enet.removeCableAndSplitGrids(this.gridID, this.cableToBurn);
                    this.startCableBurning = false;
                    this.countdownTimer = 200;
                }
            }
        }
    }

    private void createChainOfExplosions() {
        for (BatterySwitchUnitTileEntity bsu : this.batteryChain) {
            ExplosionIC2 explosion = new ExplosionIC2(bsu.field_145850_b, null, (double)bsu.field_145851_c + 0.5, (double)bsu.field_145848_d + 0.5, (double)bsu.field_145849_e + 0.5, 2.0f, 0.3f, ExplosionIC2.Type.Normal, null, 0);
            explosion.doExplosion();
        }
    }

    private boolean checkBatteryChain() {
        boolean allright = true;
        if (!this.batteryChain.isEmpty() && this.grounding != null && !this.grounding.func_145837_r()) {
            for (BatterySwitchUnitTileEntity section : this.batteryChain) {
                if (section != null && !section.func_145837_r()) continue;
                allright = false;
            }
        } else {
            allright = false;
        }
        if (allright) {
            return true;
        }
        this.batteryChain.clear();
        this.grounding = null;
        boolean checking = true;
        int x = this.field_145851_c;
        int z = this.field_145849_e;
        ArrayList<Integer> xs = new ArrayList<Integer>();
        ArrayList<Integer> zs = new ArrayList<Integer>();
        xs.add(this.field_145851_c);
        zs.add(this.field_145849_e);
        this.batteryChain.add(this);
        while (checking) {
            if (xs.isEmpty() || zs.isEmpty()) {
                checking = false;
                break;
            }
            x = (Integer)xs.remove(0);
            z = (Integer)zs.remove(0);
            int[] xz = new int[]{0, 1, 0, -1, 0};
            for (int i = 0; i < xz.length - 1; ++i) {
                TileEntity te = this.field_145850_b.func_147438_o(x + xz[i], this.field_145848_d, z + xz[i + 1]);
                if (te instanceof BatterySwitchUnitTileEntity) {
                    BatterySwitchUnitTileEntity section = (BatterySwitchUnitTileEntity)te;
                    if (!this.batteryChain.add(section)) continue;
                    xs.add(section.field_145851_c);
                    zs.add(section.field_145849_e);
                    section.batteryChain.add(this);
                    section.batteryChainMaster = this;
                    continue;
                }
                if (!(te instanceof GroundingTileEntity)) continue;
                this.grounding = (GroundingTileEntity)te;
            }
        }
        return this.grounding != null && !this.grounding.func_145837_r();
    }

    @Override
    public void initiateCableBurnout(IHLCable cable) {
        this.cableToBurn = cable;
        double range = (double)cable.length * 2.0 + 32.0;
        AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
        List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
        if (!nodeList.isEmpty()) {
            for (NodeEntity ne : nodeList) {
                if (ne.getChainUniqueID() != cable.cableID) continue;
                ne.func_70015_d(10);
            }
        }
        this.startCableBurning = true;
    }

    @Override
    public double getConnectionX() {
        return this.connectionX;
    }

    public void setConnectionX(double connectionX) {
        this.connectionX = connectionX;
    }

    @Override
    public double getConnectionY() {
        return this.connectionY;
    }

    public void setConnectionY(double connectionY) {
        this.connectionY = connectionY;
    }

    @Override
    public double getConnectionZ() {
        return this.connectionZ;
    }

    public void setConnectionZ(double connectionZ) {
        this.connectionZ = connectionZ;
    }

    @Override
    public boolean addCable(IHLCable cable) {
        return this.cableList.add(cable);
    }

    @Override
    public IHLCableSet getCableList() {
        return this.cableList;
    }

    @Override
    public void setGrid(int newGridID) {
        if (newGridID != -1) {
            this.gridID = newGridID;
            IHLMod.enet.getGrid((int)newGridID).telist.add(this);
            IHLMod.enet.getGrid((int)newGridID).isGridValid = true;
        } else {
            this.gridID = -1;
        }
    }

    @Override
    public int getGridID() {
        return this.gridID;
    }

    @Override
    public IHLGrid getGrid() {
        return IHLMod.enet.getGrid(this.gridID);
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    public double getOfferedEnergy() {
        return this.chargingMode ? 0.0 : this.energy;
    }

    public void drawEnergy(double amount) {
        this.energy -= amount;
    }

    public int getSourceTier() {
        return 4;
    }

    @Override
    public double getMaxAllowableVoltage() {
        return 64000.0;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }
}

