/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.metallurgy;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerBase;
import ihl.IHLMod;
import ihl.processing.chemistry.GaedesMercuryRotaryPumpTileEntity;
import ihl.processing.metallurgy.InjectionMoldTileEntity;
import ihl.processing.metallurgy.MachineBaseTileEntity;
import ihl.processing.metallurgy.VacuumInductionMeltingFurnaceContainer;
import ihl.processing.metallurgy.VacuumInductionMeltingFurnaceGui;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.tunneling_shield.IMultiBlock;
import ihl.tunneling_shield.MultiBlockSpacerBlock;
import ihl.utils.IHLFluidTank;
import ihl.utils.IHLUtils;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class VacuumInductionMeltingFurnaceTileEntity
extends MachineBaseTileEntity
implements INetworkClientTileEntityEventListener,
IMultiBlock {
    protected static UniversalRecipeManager recipeManager = new UniversalRecipeManager();
    public final IHLFluidTank fluidTank = new IHLFluidTank(864);
    public boolean vacuumPumpConnected = false;
    private GaedesMercuryRotaryPumpTileEntity lastGMRP;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    public VacuumInductionMeltingFurnaceTileEntity() {
        super(1);
    }

    @Override
    public void setFacing(short facing1) {
        short facing2 = (short)Math.max(facing1, 2);
        super.setFacing(facing2);
        switch (facing2) {
            case 0: {
                this.setupMultiblockStructure(-1, -2, 0);
                break;
            }
            case 1: {
                this.setupMultiblockStructure(-1, 0, 0);
                break;
            }
            case 2: {
                this.setupMultiblockStructure(-1, 0, -2);
                break;
            }
            case 3: {
                this.setupMultiblockStructure(-1, 0, 0);
                break;
            }
            case 4: {
                this.setupMultiblockStructure(-2, 0, -1);
                break;
            }
            case 5: {
                this.setupMultiblockStructure(0, 0, -1);
            }
        }
    }

    @Override
    public String getStartSoundFile() {
        return null;
    }

    @Override
    public String getLoopSoundFile() {
        return null;
    }

    @Override
    public String getStopSoundFile() {
        return null;
    }

    @Override
    public String func_145825_b() {
        return "VacuumInductionMeltingFurnace";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean arg1) {
        return new VacuumInductionMeltingFurnaceGui(new VacuumInductionMeltingFurnaceContainer(player, this));
    }

    @Override
    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        return new VacuumInductionMeltingFurnaceContainer(player, this);
    }

    @Override
    public void operate() {
        UniversalRecipeOutput routput;
        ItemStack content = this.input.get();
        if (content != null && (routput = recipeManager.getOutputFor(null, Arrays.asList(content), false, false)) != null && !routput.getFluidOutputs().isEmpty()) {
            FluidStack fluidStack = routput.getFluidOutputs().get(0).copy();
            fluidStack.amount *= content.field_77994_a;
            this.input.clear();
            this.fluidTank.fill(fluidStack, true);
            this.useVacuumPump();
        }
    }

    @Override
    public boolean canOperate() {
        return this.checkSpecialConditionVacuumPump() && this.getOutput() != null;
    }

    private void useVacuumPump() {
        if (this.lastGMRP != null && !this.lastGMRP.func_145837_r() && this.lastGMRP.ready) {
            this.lastGMRP.ready = false;
        }
    }

    private boolean checkSpecialConditionVacuumPump() {
        if (this.lastGMRP != null && !this.lastGMRP.func_145837_r() && this.lastGMRP.ready) {
            this.vacuumPumpConnected = true;
            return true;
        }
        int[] xz = new int[]{0, 1, 1, 0, -1, -1, 0};
        for (int i0 = -1; i0 <= 0; ++i0) {
            for (int i = 0; i < xz.length - 1; ++i) {
                GaedesMercuryRotaryPumpTileEntity gmrp;
                TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + xz[i], this.field_145848_d + i0, this.field_145849_e + xz[i + 1]);
                if (!(te instanceof GaedesMercuryRotaryPumpTileEntity)) continue;
                this.lastGMRP = gmrp = (GaedesMercuryRotaryPumpTileEntity)te;
                this.vacuumPumpConnected = gmrp.ready;
                return gmrp.ready;
            }
        }
        this.vacuumPumpConnected = false;
        return false;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("vacuumInductionMeltingFurnace");
    }

    public static void addRecipe(ItemStack input, FluidStack output) {
        recipeManager.addRecipe(new UniversalRecipeInput(null, Arrays.asList(input)), new UniversalRecipeOutput(Arrays.asList(output), null, 20));
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }

    @Override
    public UniversalRecipeOutput getOutput() {
        return recipeManager.getOutputFor(this.getInput(), false, false);
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            case 0: {
                TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (!(te instanceof InjectionMoldTileEntity)) break;
                InjectionMoldTileEntity im = (InjectionMoldTileEntity)te;
                im.fill(ForgeDirection.UP, this.fluidTank.drain(this.fluidTank.getCapacity(), true), true);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        block2: {
            super.func_145839_a(nbttagcompound);
            try {
                this.energy = nbttagcompound.func_74769_h("energy");
            }
            catch (Exception var3) {
                this.energy = nbttagcompound.func_74762_e("energy");
                if (this.maxStorage <= Integer.MAX_VALUE) break block2;
                this.energy *= 10.0;
            }
        }
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
    }

    private void setupMultiblockStructure(int x0, int y0, int z0) {
        this.minX = this.field_145851_c + x0;
        this.maxX = this.field_145851_c + x0 + 3;
        this.minY = this.field_145848_d + y0;
        this.maxY = this.field_145848_d + y0 + 3;
        this.minZ = this.field_145849_e + z0;
        this.maxZ = this.field_145849_e + z0 + 3;
        for (int ix = this.field_145851_c + x0; ix < this.field_145851_c + x0 + 3; ++ix) {
            for (int iy = this.field_145848_d + y0; iy < this.field_145848_d + y0 + 3; ++iy) {
                for (int iz = this.field_145849_e + z0; iz < this.field_145849_e + z0 + 3; ++iz) {
                    if (this.field_145850_b.func_147438_o(ix, iy, iz) instanceof VacuumInductionMeltingFurnaceTileEntity) continue;
                    this.field_145850_b.func_147449_b(ix, iy, iz, IHLMod.multiBlockSpacerBlock);
                }
            }
        }
        MultiBlockSpacerBlock cfr_ignored_0 = (MultiBlockSpacerBlock)IHLMod.multiBlockSpacerBlock;
        MultiBlockSpacerBlock.teList.add(this);
    }

    @Override
    public boolean isAPartOfStructure(int x, int y, int z, boolean onBlockBeak) {
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ;
    }

    @Override
    public boolean getIsInvalid() {
        return this.func_145837_r();
    }
}

