/*
 * Decompiled with CFR 0.152.
 */
package ihl.worldgen;

import ihl.i_hate_liquids.XYZ;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMinableMeta
extends WorldGenerator {
    private final Block mineableBlock;
    private final List<Block> replaceableBlocks;
    private final Block liquidBedBlock;
    private final int mineableBlockMeta;
    private final int numberOfBlocks;
    private final int veinMaxHeightLimit;
    private final int veinMinHeightLimit;
    public int lastX;
    public int lastY;
    public int lastZ;

    public WorldGenMinableMeta(Block block, int meta, int numberOfBlocks1, Block ... replacedBlock1) {
        this.mineableBlock = block;
        this.replaceableBlocks = Arrays.asList(replacedBlock1);
        this.mineableBlockMeta = meta;
        this.liquidBedBlock = Blocks.field_150435_aG;
        this.numberOfBlocks = numberOfBlocks1;
        this.veinMaxHeightLimit = 256;
        this.veinMinHeightLimit = 256;
    }

    public WorldGenMinableMeta(Block block, Block liquidBedBlock1, int meta, int numberOfBlocks1, int veinMinHeightLimit1, int veinMaxHeightLimit1, Block ... replacedBlock1) {
        this.mineableBlock = block;
        this.replaceableBlocks = Arrays.asList(replacedBlock1);
        this.mineableBlockMeta = meta;
        this.liquidBedBlock = liquidBedBlock1;
        this.numberOfBlocks = numberOfBlocks1;
        this.veinMaxHeightLimit = veinMaxHeightLimit1;
        this.veinMinHeightLimit = veinMinHeightLimit1;
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        boolean hasGenerated = false;
        float randomBase = random.nextFloat() * 3.141593f;
        double d = (float)(i + 8) + MathHelper.func_76126_a((float)randomBase) * (float)this.numberOfBlocks / 8.0f;
        double d1 = (float)(i + 8) - MathHelper.func_76126_a((float)randomBase) * (float)this.numberOfBlocks / 8.0f;
        double d2 = (float)(k + 8) + MathHelper.func_76134_b((float)randomBase) * (float)this.numberOfBlocks / 8.0f;
        double d3 = (float)(k + 8) - MathHelper.func_76134_b((float)randomBase) * (float)this.numberOfBlocks / 8.0f;
        double d4 = j + random.nextInt(3) - 2;
        double d5 = j + random.nextInt(3) - 2;
        HashSet<XYZ> blocks_xyz = new HashSet<XYZ>();
        for (int l = 0; l <= this.numberOfBlocks; ++l) {
            double d6 = d + (d1 - d) * (double)l / (double)this.numberOfBlocks;
            double d7 = d4 + (d5 - d4) * (double)l / (double)this.numberOfBlocks;
            double d8 = d2 + (d3 - d2) * (double)l / (double)this.numberOfBlocks;
            double d9 = random.nextFloat() * (float)this.numberOfBlocks / 16.0f;
            float f1 = (float)l / (float)this.numberOfBlocks;
            double d10 = (double)(4.0f * f1 - 4.0f * f1 * f1 + 1.0f) * d9 + 1.0;
            int xStart = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int yStart = MathHelper.func_76128_c((double)(d7 - Math.min(d10 / 4.0, (double)(this.veinMinHeightLimit - 1))));
            int zStart = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int xEnd = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int yEnd = MathHelper.func_76128_c((double)(d7 + Math.min(d10 / 4.0, (double)(this.veinMaxHeightLimit - 1))));
            int zEnd = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int targetX = xStart; targetX <= xEnd; ++targetX) {
                double d12 = ((double)targetX + 0.5 - d6) / (d10 / 2.0);
                if (d12 * d12 >= 1.0) continue;
                for (int targetY = Math.max(2, yStart); targetY <= yEnd; ++targetY) {
                    double d13 = ((double)targetY + 0.5 - d7) / (d10 / 2.0);
                    if (d12 * d12 + d13 * d13 >= 1.0) continue;
                    for (int targetZ = zStart; targetZ <= zEnd; ++targetZ) {
                        double d14 = ((double)targetZ + 0.5 - d8) / (d10 / 2.0);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0) || !this.replaceableBlocks.contains(world.func_147439_a(targetX, targetY, targetZ))) continue;
                        world.func_147465_d(targetX, targetY, targetZ, this.mineableBlock, this.mineableBlockMeta, 2);
                        hasGenerated = true;
                        this.lastX = targetX;
                        this.lastY = targetY;
                        this.lastZ = targetZ;
                        if (this.mineableBlock.func_149688_o() != Material.field_151586_h) continue;
                        blocks_xyz.add(new XYZ(targetX, targetY, targetZ));
                    }
                }
            }
        }
        if (hasGenerated) {
            for (XYZ blockXYZ : blocks_xyz) {
                int[] xyz = new int[]{0, 0, 1, 0, 0, -1, 0, 0};
                for (int i1 = 0; i1 <= 5; ++i1) {
                    int x = blockXYZ.x + xyz[i1];
                    int y = blockXYZ.y + xyz[i1 + 1];
                    int z = blockXYZ.z + xyz[i1 + 2];
                    Block block = world.func_147439_a(x, y, z);
                    if (block == this.mineableBlock) continue;
                    if (block.func_149688_o() == Material.field_151587_i) {
                        world.func_147465_d(x, y, z, Blocks.field_150343_Z, 0, 2);
                        continue;
                    }
                    if (block.isAir((IBlockAccess)world, x, y, z) && xyz[i1 + 1] > 0) continue;
                    world.func_147465_d(x, y, z, this.liquidBedBlock, 0, 2);
                }
            }
        }
        return hasGenerated;
    }
}

