/*
 * Decompiled with CFR 0.152.
 */
package ihl.worldgen.ores;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ihl.IHLCreativeTab;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockOre
extends Block {
    private Type type;
    private static List<BlockOre> instances = new ArrayList<BlockOre>();
    private static Map<Type, IIcon> iconMap = new HashMap<Type, IIcon>();

    public BlockOre(Type type1) {
        super(Material.field_151576_e);
        this.type = type1;
        this.func_149647_a(IHLCreativeTab.tab);
        this.func_149663_c(this.type.unLocalizedName);
        instances.add(this);
        this.func_149711_c(2.0f).func_149752_b(4.0f);
    }

    public static void init() {
        Type[] var1 = Type.values();
        for (int i = 0; i < var1.length; ++i) {
            new BlockOre(var1[i]);
        }
        for (BlockOre instance : instances) {
            GameRegistry.registerBlock((Block)instance, (String)instance.type.unLocalizedName);
            OreDictionary.registerOre((String)instance.type.unLocalizedName, (Block)instance);
        }
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float chance, int flag) {
        super.func_149690_a(world, x, y, z, meta, chance, flag);
        this.func_149657_c(world, x, y, z, MathHelper.func_76136_a((Random)world.field_73012_v, (int)1, (int)4));
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int fortmod = world.field_73012_v.nextInt(fortune + 2) - 1;
        if (fortmod < 0 || !this.type.fortuneAffectsDrops) {
            fortmod = 0;
        }
        ItemStack drop = null;
        int amount = 1;
        amount = (this.type.amountFrom + (this.type.amountTo > 0 ? world.field_73012_v.nextInt(this.type.amountTo) : 0)) * (fortmod + 1);
        drop = (ItemStack)OreDictionary.getOres((String)this.type.oreDrop).get(0);
        if (drop != null && amount > 0) {
            drop.field_77994_a = amount;
            drops.add(drop);
        }
        return drops;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        iconMap.put(this.type, register.func_94245_a("ihl:" + this.type.unLocalizedName));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int i, int j) {
        return iconMap.get((Object)this.type);
    }

    public static enum Type {
        Bischofite("oreBischofite", "dustBischofite", 1, 2),
        Datolite("oreDatolite", "dustDatolite", 1, 2),
        Stibnite("oreStibnite"),
        Chromite("oreChromite"),
        Muscovite("oreMica"),
        Bauxite("oreBauxite"),
        Cinnabar("oreCinnabar"),
        RockSalt("oreRockSalt", "dustRockSalt", 1, 2),
        Limestone("oreLimestone", "dustCalcite", 1, 2),
        Gypsum("oreGypsum"),
        Gyubnera("oreGyubnera"),
        OreTrona("oreTrona", "dustTrona", 1, 2),
        PotassiumFeldspar("orePotassiumFeldspar"),
        Apatite("oreApatite", "gemApatite", 2, 5),
        Saltpeter("oreSaltpeter", "dustSaltpeter", 1, 2);

        String unLocalizedName;
        String oreDrop;
        int amountFrom;
        int amountTo;
        boolean fortuneAffectsDrops = true;

        private Type(String unlocalizedName1, String oreDrop1, int amountFrom1, int amountTo1) {
            this.unLocalizedName = unlocalizedName1;
            this.oreDrop = oreDrop1;
            this.amountFrom = amountFrom1;
            this.amountTo = amountTo1;
        }

        private Type(String unlocalizedName1) {
            this.unLocalizedName = unlocalizedName1;
            this.oreDrop = unlocalizedName1;
            this.amountFrom = 1;
            this.amountTo = 0;
            this.fortuneAffectsDrops = false;
        }
    }
}

