/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ihl.IHLMod;
import ihl.flexible_cable.IWire;
import ihl.flexible_cable.InvSlotOutputInProgress;
import ihl.flexible_cable.InvSlotProcessableIronWorkbench;
import ihl.flexible_cable.InvSlotTool;
import ihl.flexible_cable.InvSlotWorkspaceElement;
import ihl.flexible_cable.IronWorkbenchContainer;
import ihl.flexible_cable.IronWorkbenchGui;
import ihl.items_blocks.FlexibleCableItem;
import ihl.items_blocks.WireItem;
import ihl.processing.chemistry.GaedesMercuryRotaryPumpTileEntity;
import ihl.processing.metallurgy.GasWeldingStationTileEntity;
import ihl.recipes.IronWorkbenchRecipe;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class IronWorkbenchTileEntity
extends TileEntityInventory
implements IHasGui,
INetworkClientTileEntityEventListener,
INetworkTileEntityEventListener {
    public static List<IronWorkbenchRecipe> recipes = new ArrayList<IronWorkbenchRecipe>();
    public int progress;
    public int currentSlot = -1;
    public final int maxProgress;
    public final InvSlotTool tools;
    public final InvSlotWorkspaceElement workspaceElements;
    public final InvSlotProcessableIronWorkbench inputMaterial;
    public final InvSlotOutputInProgress output;
    public boolean isGuiScreenOpened = false;
    private boolean startProcess = false;
    private boolean outputDefined = false;
    private EntityPlayer crafter;
    public ContainerBase<?> container;
    private Map<Integer, IronWorkbenchRecipe> slotRecipeMap = new HashMap<Integer, IronWorkbenchRecipe>();
    private GaedesMercuryRotaryPumpTileEntity lastGMRP;
    private GasWeldingStationTileEntity lastGWS;

    public IronWorkbenchTileEntity() {
        this.maxProgress = 80;
        this.workspaceElements = new InvSlotWorkspaceElement(this, "workspaceElements", 3, InvSlot.Access.NONE, 6);
        this.tools = new InvSlotTool(this, "tools", 0, InvSlot.Access.IO, 12);
        this.inputMaterial = new InvSlotProcessableIronWorkbench(this, "input", 1, InvSlot.Access.IO, 12);
        this.output = new InvSlotOutputInProgress(this, "output", 2, 18);
    }

    public static void addRecipe(IronWorkbenchRecipe recipe) {
        recipes.add(recipe);
    }

    public String func_145825_b() {
        return "ironWorkbench";
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        return new ItemStack(IHLMod.ironWorkbench);
    }

    public void func_145845_h() {
        if (this.isGuiScreenOpened) {
            if (this.output.isEmpty() && !this.outputDefined) {
                this.workspaceElements.reset();
                for (IronWorkbenchRecipe recipe : recipes) {
                    short slot;
                    if (!recipe.isCanBeCrafted(this.tools.getItemStackList(), this.inputMaterial.getItemStackList(), this.workspaceElements.getItemStackList())) continue;
                    if (recipe.workspaceElements != null && !recipe.workspaceElements.isEmpty()) {
                        if (!this.workspaceElements.containsAndCanUse(recipe.workspaceElements)) continue;
                        slot = this.output.put(recipe.outputs);
                        if (slot < 0) break;
                        this.slotRecipeMap.put(Integer.valueOf(slot), recipe);
                        this.startProcess = false;
                        continue;
                    }
                    slot = this.output.put(recipe.outputs);
                    if (slot < 0) break;
                    this.slotRecipeMap.put(Integer.valueOf(slot), recipe);
                    this.startProcess = false;
                }
                ArrayList processingMaterials = new ArrayList();
                for (int i = 0; i < this.inputMaterial.size(); ++i) {
                    ItemStack stack = this.inputMaterial.get(i);
                    if (stack == null || !(stack.func_77973_b() instanceof IWire)) continue;
                    int fullLength = this.getFullLengthOfSameItems(stack);
                    List<ItemStack> list = this.getListOfSameItems(stack);
                    ItemStack result = IHLUtils.getThisModWireItemStackWithLength(stack, fullLength);
                    IronWorkbenchRecipe recipe = new IronWorkbenchRecipe(null, list, Arrays.asList(result));
                    short slot = this.output.put(recipe.outputs);
                    if (slot < 0) break;
                    this.slotRecipeMap.put(Integer.valueOf(slot), recipe);
                    this.startProcess = false;
                    int rubberAmount = this.inputMaterial.getAmountOf(Ic2Items.rubber);
                    if (stack.func_77973_b() instanceof WireItem && !(stack.func_77973_b() instanceof FlexibleCableItem)) {
                        ItemStack result2 = ((WireItem)stack.func_77973_b()).getInsulatedResult();
                        if (rubberAmount <= 0 || result2 == null) break;
                        if (rubberAmount >= fullLength) {
                            result2 = IHLUtils.getThisModWireItemStackWithLength(result2, fullLength);
                            List<ItemStack> list2 = this.getListOfSameItems(stack);
                            ItemStack rubber = Ic2Items.rubber.func_77946_l();
                            rubber.field_77994_a = fullLength;
                            list2.add(rubber);
                            IronWorkbenchRecipe recipe2 = new IronWorkbenchRecipe(null, list2, Arrays.asList(result2));
                            short slot2 = this.output.put(recipe2.outputs);
                            if (slot2 < 0) break;
                            this.slotRecipeMap.put(Integer.valueOf(slot2), recipe2);
                            break;
                        }
                        result2 = IHLUtils.getThisModWireItemStackWithLength(result2, rubberAmount);
                        ItemStack result2_2 = IHLUtils.getThisModWireItemStackWithLength(stack, fullLength - rubberAmount);
                        List<ItemStack> list2 = this.getListOfSameItems(stack);
                        ItemStack rubber = Ic2Items.rubber.func_77946_l();
                        rubber.field_77994_a = rubberAmount;
                        list2.add(rubber);
                        IronWorkbenchRecipe recipe2 = new IronWorkbenchRecipe(null, list2, Arrays.asList(result2, result2_2));
                        short slot2 = this.output.put(recipe2.outputs);
                        if (slot2 < 0) break;
                        this.slotRecipeMap.put(Integer.valueOf(slot2), recipe2);
                        break;
                    }
                    if (!(stack.func_77973_b() instanceof FlexibleCableItem) || !this.tools.contain(IHLUtils.getThisModItemStack("sharpenedCarvingKnifeBronze"))) break;
                    ArrayList<ItemStack> result2 = new ArrayList<ItemStack>();
                    result2.add(IHLUtils.getThisModWireItemStackWithLength(((FlexibleCableItem)stack.func_77973_b()).getUninsulatedResult(), fullLength));
                    if (((FlexibleCableItem)stack.func_77973_b()).insulationMaterial.equals((Object)FlexibleCableItem.InsulationMaterial.Rubber) && fullLength >= 2) {
                        ItemStack rubber = Ic2Items.rubber.func_77946_l();
                        rubber.field_77994_a = fullLength - 1;
                        result2.add(rubber);
                    }
                    List<ItemStack> list2 = this.getListOfSameItems(stack);
                    IronWorkbenchRecipe recipe2 = new IronWorkbenchRecipe(Arrays.asList(IHLUtils.getThisModItemStack("sharpenedCarvingKnifeBronze")), list2, result2);
                    short slot2 = this.output.put(recipe2.outputs);
                    if (slot2 < 0) break;
                    this.slotRecipeMap.put(Integer.valueOf(slot2), recipe2);
                    break;
                }
                this.outputDefined = true;
            } else if (!this.output.isEmpty()) {
                List<Integer> crafterEmptyInventorySlotsList = this.getCrafterEmptyInventorySlotsList();
                if (this.startProcess && crafterEmptyInventorySlotsList.size() >= this.slotRecipeMap.get((Object)Integer.valueOf((int)this.currentSlot)).outputs.size() && ++this.progress >= this.maxProgress) {
                    IronWorkbenchRecipe crecipe = this.slotRecipeMap.get(this.currentSlot);
                    List<ItemStack> opts = crecipe.outputs;
                    Iterator<ItemStack> optsi = opts.iterator();
                    Iterator<Integer> emptySlotsIterator = crafterEmptyInventorySlotsList.iterator();
                    while (optsi.hasNext()) {
                        int slot = emptySlotsIterator.next();
                        ItemStack stack = optsi.next();
                        this.crafter.field_71071_by.field_70462_a[slot] = stack.func_77946_l();
                    }
                    this.crafter.field_71069_bz.func_75142_b();
                    this.inputMaterial.substract(crecipe.materials);
                    this.tools.damage(crecipe.tools);
                    if (!crecipe.workspaceElements.isEmpty()) {
                        this.workspaceElements.use(crecipe.workspaceElements);
                    }
                    this.resetOutput();
                }
            }
        }
    }

    private List<Integer> getCrafterEmptyInventorySlotsList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (this.crafter != null) {
            for (int var1 = 0; var1 < this.crafter.field_71071_by.field_70462_a.length; ++var1) {
                if (this.crafter.field_71071_by.field_70462_a[var1] != null) continue;
                list.add(var1);
            }
        }
        return list;
    }

    private List<ItemStack> getListOfSameItems(ItemStack stack1) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inputMaterial.size(); ++i) {
            ItemStack stack = this.inputMaterial.get(i);
            if (stack == null || stack.func_77973_b() != stack1.func_77973_b()) continue;
            list.add(stack);
        }
        return list;
    }

    private int getFullLengthOfSameItems(ItemStack stack1) {
        int fullLength = 0;
        for (int i = 0; i < this.inputMaterial.size(); ++i) {
            ItemStack stack = this.inputMaterial.get(i);
            if (stack == null || stack.func_77973_b() != stack1.func_77973_b()) continue;
            fullLength += IHLUtils.getWireLength(stack);
        }
        return fullLength;
    }

    public boolean getGui(EntityPlayer player) {
        this.isGuiScreenOpened = this instanceof IHasGui ? (IC2.platform.isSimulating() ? IC2.platform.launchGui(player, (IHasGui)this) : true) : false;
        return this.isGuiScreenOpened;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean arg1) {
        return new IronWorkbenchGui(new IronWorkbenchContainer(player, this));
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        this.resetOutput();
        this.crafter = player;
        this.container = new IronWorkbenchContainer(player, this);
        return this.container;
    }

    public void onGuiClosed(EntityPlayer arg0) {
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        if (event == 16) {
            this.isGuiScreenOpened = false;
            this.crafter = null;
            this.container = null;
            return;
        }
        for (int i = event; i >= 0; --i) {
            if (!this.slotRecipeMap.containsKey(i)) continue;
            if (!this.slotRecipeMap.get(i).isCanBeCrafted(this.tools.getItemStackList(), this.inputMaterial.getItemStackList(), this.workspaceElements.getItemStackList())) {
                this.resetOutput();
                continue;
            }
            this.currentSlot = i;
            this.startProcess = true;
            return;
        }
    }

    public void resetOutput() {
        this.output.clear();
        this.slotRecipeMap.clear();
        this.progress = 0;
        this.startProcess = false;
        this.currentSlot = -1;
        this.outputDefined = false;
    }

    public void dropContents() {
        int i;
        for (i = 0; i < this.tools.size(); ++i) {
            if (this.tools.get(i) == null) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.tools.get(i)));
        }
        for (i = 0; i < this.inputMaterial.size(); ++i) {
            if (this.inputMaterial.get(i) == null) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.inputMaterial.get(i)));
        }
    }

    public void onNetworkEvent(int event) {
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / this.maxProgress;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }
}

