/*
 * Decompiled with CFR 0.152.
 */
package ihl.nei_integration;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ic2.api.recipe.IRecipeInput;
import ic2.core.Ic2Items;
import ic2.core.item.ItemFluidCell;
import ihl.flexible_cable.IWire;
import ihl.nei_integration.IHLPositionedStack;
import ihl.recipes.RecipeOutputItemStack;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.lwjgl.opengl.GL11;

public abstract class MachineRecipeHandler
extends TemplateRecipeHandler {
    protected int ticks;

    public abstract String getRecipeName();

    public abstract String getRecipeId();

    public abstract String getGuiTexture();

    public abstract String getOverlayIdentifier();

    public abstract Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipeList();

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)140, (int)65);
    }

    public void drawExtras(int recipeNumber) {
        CachedIORecipe recipe = (CachedIORecipe)((Object)this.arecipes.get(recipeNumber));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (recipe.output instanceof IHLPositionedStack) {
            IHLPositionedStack rOutput = (IHLPositionedStack)recipe.output;
            this.drawFormattedString(rOutput);
        }
        for (PositionedStack rOutPS : recipe.otherStacks) {
            if (!(rOutPS instanceof IHLPositionedStack)) continue;
            IHLPositionedStack rOutput = (IHLPositionedStack)rOutPS;
            this.drawFormattedString(rOutput);
        }
        GuiDraw.changeTexture((String)this.getGuiTexture());
    }

    public void drawFormattedString(IHLPositionedStack rOutput) {
        if (Math.abs(rOutput.sQuantity - (float)Math.round(rOutput.sQuantity)) < 0.01f) {
            if (Math.round(rOutput.sQuantity) != 1) {
                GuiDraw.fontRenderer.func_78261_a(String.format("%d", Math.round(rOutput.sQuantity)), rOutput.relx + 11, rOutput.rely + 9, 0xFFFFFF);
            }
        } else {
            GuiDraw.fontRenderer.func_78261_a(String.format("%.1f", Float.valueOf(rOutput.sQuantity)), rOutput.relx + 3, rOutput.rely + 9, 0xFFFFFF);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticks;
    }

    public void loadTransferRects() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<UniversalRecipeInput, UniversalRecipeOutput> entry : this.getRecipeList().entrySet()) {
                this.arecipes.add(new CachedIORecipe(entry.getKey(), entry.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        Map.Entry<UniversalRecipeInput, UniversalRecipeOutput> entry;
        Fluid fluid;
        Block blockfluid;
        Iterator<Map.Entry<UniversalRecipeInput, UniversalRecipeOutput>> i$ = this.getRecipeList().entrySet().iterator();
        FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)result);
        if (fluidStack == null && result.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem ifc = (IFluidContainerItem)result.func_77973_b();
            fluidStack = ifc.getFluid(result);
        } else if (result.func_77973_b() instanceof ItemBlock && (blockfluid = ((ItemBlock)result.func_77973_b()).field_150939_a) instanceof BlockFluidBase && (fluid = ((BlockFluidBase)blockfluid).getFluid()) != null) {
            fluidStack = new FluidStack(fluid, 1000);
        }
        if (fluidStack != null) {
            block0: while (i$.hasNext()) {
                entry = i$.next();
                for (FluidStack output : entry.getValue().getFluidOutputs()) {
                    if (output == null || output.getFluid() != fluidStack.getFluid()) continue;
                    this.arecipes.add(new CachedIORecipe(entry.getKey(), entry.getValue()));
                    continue block0;
                }
            }
        } else {
            block2: while (i$.hasNext()) {
                entry = i$.next();
                for (RecipeOutputItemStack output : entry.getValue().getItemOutputs()) {
                    if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)output.itemStack, (ItemStack)result) && !IHLUtils.isItemsHaveSameOreDictionaryEntry(output.itemStack, result)) continue;
                    this.arecipes.add(new CachedIORecipe(entry.getKey(), entry.getValue()));
                    continue block2;
                }
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Map.Entry<UniversalRecipeInput, UniversalRecipeOutput> entry;
        Fluid fluid;
        Block blockfluid;
        Iterator<Map.Entry<UniversalRecipeInput, UniversalRecipeOutput>> i$ = this.getRecipeList().entrySet().iterator();
        FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)ingredient);
        if (fluidStack == null && ingredient.func_77973_b() instanceof IFluidContainerItem) {
            IFluidContainerItem ifc = (IFluidContainerItem)ingredient.func_77973_b();
            fluidStack = ifc.getFluid(ingredient);
        } else if (ingredient.func_77973_b() instanceof ItemBlock && (blockfluid = ((ItemBlock)ingredient.func_77973_b()).field_150939_a) instanceof BlockFluidBase && (fluid = ((BlockFluidBase)blockfluid).getFluid()) != null) {
            fluidStack = new FluidStack(fluid, 1000);
        }
        if (fluidStack != null && fluidStack.getFluid() != null) {
            while (i$.hasNext()) {
                entry = i$.next();
                if (!entry.getKey().containFluidStack(fluidStack)) continue;
                this.arecipes.add(new CachedIORecipe(entry.getKey(), entry.getValue()));
            }
        } else {
            while (i$.hasNext()) {
                entry = i$.next();
                if (!entry.getKey().containItemStack(ingredient)) continue;
                this.arecipes.add(new CachedIORecipe(entry.getKey(), entry.getValue()));
            }
        }
    }

    protected int[] getFluidInputPosX() {
        return null;
    }

    protected int[] getFluidInputPosY() {
        return null;
    }

    protected int[] getFluidOutputPosX() {
        return null;
    }

    protected int[] getFluidOutputPosY() {
        return null;
    }

    protected abstract int[] getInputPosX();

    protected abstract int[] getInputPosY();

    protected abstract int[] getOutputPosX();

    protected abstract int[] getOutputPosY();

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> ingredients;
        public PositionedStack output;
        public final List<PositionedStack> otherStacks;
        public boolean specialConditions;

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(MachineRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.otherStacks;
        }

        public CachedIORecipe(UniversalRecipeInput input, UniversalRecipeOutput output1) {
            Iterator<RecipeOutputItemStack> i;
            super((TemplateRecipeHandler)MachineRecipeHandler.this);
            this.ingredients = new ArrayList<PositionedStack>();
            this.otherStacks = new ArrayList<PositionedStack>();
            this.specialConditions = false;
            if (input == null) {
                throw new NullPointerException("Input must not be null (recipe " + input + " -> " + output1 + ").");
            }
            if (output1 == null) {
                throw new NullPointerException("Output must not be null (recipe " + input + " -> " + output1 + ").");
            }
            if ((output1.getFluidOutputs() == null || output1.getFluidOutputs().isEmpty()) && (output1.getItemOutputs() == null || output1.getItemOutputs().isEmpty())) {
                throw new NullPointerException("Output must not be null (recipe " + input + " -> " + output1 + ").");
            }
            this.specialConditions = output1.specialConditions;
            ArrayList items = new ArrayList();
            ArrayList<ItemStack> fluidItems = new ArrayList<ItemStack>();
            if (input.getFluidInputs() != null && !input.getFluidInputs().isEmpty()) {
                for (FluidStack fstack : input.getFluidInputs()) {
                    ItemStack stack = Ic2Items.FluidCell.func_77946_l();
                    ((ItemFluidCell)Ic2Items.FluidCell.func_77946_l().func_77973_b()).fill(stack, fstack, true);
                    if (fstack.amount > 1000) {
                        stack.field_77994_a = fstack.amount / 1000;
                    }
                    fluidItems.add(stack);
                }
            }
            if (input.getItemInputs() != null && !input.getItemInputs().isEmpty()) {
                for (IRecipeInput rInput : input.getItemInputs()) {
                    Iterator rInputsi = rInput.getInputs().iterator();
                    ArrayList<ItemStack> itemInputs = new ArrayList<ItemStack>();
                    while (rInputsi.hasNext()) {
                        ItemStack stack = ((ItemStack)rInputsi.next()).func_77946_l();
                        if (!(stack.func_77973_b() instanceof IWire)) {
                            stack.field_77994_a = rInput.getAmount();
                        }
                        itemInputs.add(stack);
                    }
                    items.add(itemInputs);
                }
            }
            int var7 = 0;
            boolean skipOneFluidOutput = false;
            if (output1.getItemOutputs() != null && !output1.getItemOutputs().isEmpty()) {
                int x = MachineRecipeHandler.this.getOutputPosX()[0];
                int y = MachineRecipeHandler.this.getOutputPosY()[0];
                if (output1.getItemOutputs().get(0) != null) {
                    this.output = new IHLPositionedStack(output1.getItemOutputs().get(0), x, y);
                }
                i = output1.getItemOutputs().iterator();
                i.next();
                while (i.hasNext()) {
                    RecipeOutputItemStack rOut = i.next();
                    if (++var7 < MachineRecipeHandler.this.getOutputPosX().length) {
                        x = MachineRecipeHandler.this.getOutputPosX()[var7];
                    }
                    if (var7 < MachineRecipeHandler.this.getOutputPosY().length) {
                        y = MachineRecipeHandler.this.getOutputPosY()[var7];
                    }
                    if (rOut == null) continue;
                    this.otherStacks.add(new IHLPositionedStack(rOut, x, y));
                }
            } else {
                ItemStack fluidCellStack = Ic2Items.FluidCell.func_77946_l();
                ((ItemFluidCell)fluidCellStack.func_77973_b()).fill(fluidCellStack, output1.getFluidOutputs().get(0).copy(), true);
                if (output1.getFluidOutputs().get((int)0).amount > 1000) {
                    fluidCellStack.field_77994_a = output1.getFluidOutputs().get((int)0).amount / 1000;
                }
                this.output = MachineRecipeHandler.this.getFluidOutputPosX() != null ? new PositionedStack((Object)fluidCellStack, MachineRecipeHandler.this.getFluidOutputPosX()[0], MachineRecipeHandler.this.getFluidOutputPosY()[0]) : new PositionedStack((Object)fluidCellStack, MachineRecipeHandler.this.getOutputPosX()[0], MachineRecipeHandler.this.getOutputPosY()[0]);
                skipOneFluidOutput = true;
            }
            if (output1.getFluidOutputs() != null && !output1.getFluidOutputs().isEmpty()) {
                int x = MachineRecipeHandler.this.getOutputPosX()[0];
                int y = MachineRecipeHandler.this.getOutputPosY()[0];
                if (MachineRecipeHandler.this.getFluidOutputPosX() != null) {
                    x = MachineRecipeHandler.this.getFluidOutputPosX()[0];
                    y = MachineRecipeHandler.this.getFluidOutputPosY()[0];
                }
                i = output1.getFluidOutputs().iterator();
                if (skipOneFluidOutput) {
                    i.next();
                }
                while (i.hasNext()) {
                    FluidStack fstack = (FluidStack)i.next();
                    ItemStack stack1 = Ic2Items.FluidCell.func_77946_l();
                    ((ItemFluidCell)stack1.func_77973_b()).fill(stack1, fstack, true);
                    if (fstack.amount > 1000) {
                        stack1.field_77994_a = fstack.amount / 1000;
                    }
                    ++var7;
                    if (MachineRecipeHandler.this.getFluidOutputPosX() != null) {
                        if (var7 < MachineRecipeHandler.this.getFluidOutputPosX().length) {
                            x = MachineRecipeHandler.this.getFluidOutputPosX()[var7];
                        }
                        if (var7 < MachineRecipeHandler.this.getFluidOutputPosY().length) {
                            y = MachineRecipeHandler.this.getFluidOutputPosY()[var7];
                        }
                    } else {
                        if (var7 < MachineRecipeHandler.this.getOutputPosX().length) {
                            x = MachineRecipeHandler.this.getOutputPosX()[var7];
                        }
                        if (var7 < MachineRecipeHandler.this.getOutputPosY().length) {
                            y = MachineRecipeHandler.this.getOutputPosY()[var7];
                        }
                    }
                    this.otherStacks.add(new PositionedStack((Object)stack1, x, y));
                }
            }
            if (MachineRecipeHandler.this.getFluidInputPosX() != null) {
                int i2;
                int x = MachineRecipeHandler.this.getFluidInputPosX()[0];
                int y = MachineRecipeHandler.this.getFluidInputPosY()[0];
                for (i2 = 0; i2 < fluidItems.size(); ++i2) {
                    if (i2 < MachineRecipeHandler.this.getFluidInputPosX().length) {
                        x = MachineRecipeHandler.this.getFluidInputPosX()[i2];
                    }
                    if (i2 < MachineRecipeHandler.this.getFluidInputPosY().length) {
                        y = MachineRecipeHandler.this.getFluidInputPosY()[i2];
                    }
                    this.ingredients.add(new PositionedStack(fluidItems.get(i2), x, y));
                }
                x = MachineRecipeHandler.this.getInputPosX()[0];
                y = MachineRecipeHandler.this.getInputPosY()[0];
                for (i2 = 0; i2 < items.size(); ++i2) {
                    if (i2 < MachineRecipeHandler.this.getInputPosX().length) {
                        x = MachineRecipeHandler.this.getInputPosX()[i2];
                    }
                    if (i2 < MachineRecipeHandler.this.getInputPosY().length) {
                        y = MachineRecipeHandler.this.getInputPosY()[i2];
                    }
                    this.ingredients.add(new PositionedStack(items.get(i2), x, y));
                }
            } else {
                int x = MachineRecipeHandler.this.getInputPosX()[0];
                int y = MachineRecipeHandler.this.getInputPosY()[0];
                for (int i3 = 0; i3 < fluidItems.size() + items.size(); ++i3) {
                    if (i3 < MachineRecipeHandler.this.getInputPosX().length) {
                        x = MachineRecipeHandler.this.getInputPosX()[i3];
                    }
                    if (i3 < MachineRecipeHandler.this.getInputPosY().length) {
                        y = MachineRecipeHandler.this.getInputPosY()[i3];
                    }
                    if (i3 < fluidItems.size()) {
                        this.ingredients.add(new PositionedStack(fluidItems.get(i3), x, y));
                        continue;
                    }
                    this.ingredients.add(new PositionedStack(items.get(i3 - fluidItems.size()), x, y));
                }
            }
        }
    }
}

