/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.chemistry;

import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLFluidTank;
import ihl.utils.IHLUtils;
import ihl.worldgen.ores.IHLFluid;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PrecipitatorCondenserTileEntity
extends TileEntityInventory
implements IFluidHandler {
    private static final UniversalRecipeManager recipeManager = new UniversalRecipeManager();
    private static float kF = 24000.0f;
    private static float gasC = 1.0f;
    private static float fluidC = 4.0f;
    private static float H = 2256.0f;
    private final IHLFluidTank gasBuffer = new IHLFluidTank(10000);
    private final IHLFluidTank fluidTank = new IHLFluidTank(100);
    private ForgeDirection gasInputDirection = ForgeDirection.WEST;
    private int amountOfGasCondensed = 0;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
        this.gasBuffer.readFromNBT(nbttagcompound.func_74775_l("gasBuffer"));
        this.amountOfGasCondensed = nbttagcompound.func_74762_e("amountOfGasCondensed");
    }

    public static void addRecipe(String fluidNameIn, String fluidNameOut, int conversionRateToGas) {
        recipeManager.addRecipe(new UniversalRecipeInput(Arrays.asList(IHLUtils.getFluidStackWithSize(fluidNameIn, conversionRateToGas)), null), new UniversalRecipeOutput(Arrays.asList(IHLUtils.getFluidStackWithSize(fluidNameOut, 1)), null, 2));
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
        NBTTagCompound gasBufferTag = new NBTTagCompound();
        this.gasBuffer.writeToNBT(gasBufferTag);
        nbttagcompound.func_74782_a("gasBuffer", (NBTBase)gasBufferTag);
        nbttagcompound.func_74768_a("amountOfGasCondensed", this.amountOfGasCondensed);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side && side != 0 && side != 1;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("goldPrecipitatorCondenser");
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_145845_h() {
        super.func_145845_h();
        FluidStack fluidStack = this.fluidTank.getFluid();
        FluidStack gasStack = this.gasBuffer.getFluid();
        if (fluidStack != null && gasStack != null && fluidStack.amount > 0 && gasStack.amount > 0) {
            int t1 = this.fluidTank.getTemperature();
            float densityOfCoolant = IHLFluid.getRealDensity(fluidStack.getFluid());
            float densityOfGas = IHLFluid.getRealDensity(gasStack.getFluid());
            int boilingPointOfGas = IHLFluid.getBoilingPoint(gasStack.getFluid());
            this.amountOfGasCondensed += this.getAmountOfCondensedGas(fluidStack.amount, this.gasBuffer.getFluidAmount(), boilingPointOfGas, t1, densityOfGas, densityOfCoolant);
        }
        if (this.amountOfGasCondensed > 10000) {
            UniversalRecipeOutput rOutput = null;
            UniversalRecipeInput rInput = null;
            FluidStack fs = null;
            for (int i = 0; i < this.gasBuffer.getNumberOfFluids(); ++i) {
                FluidStack fs1 = this.gasBuffer.getFluid(i);
                UniversalRecipeOutput rOutput1 = recipeManager.getOutputFor(Arrays.asList(fs1), null, false, false);
                if (rOutput1 == null) {
                    this.gasBuffer.removeFluid(i);
                    continue;
                }
                rOutput = rOutput1;
                rInput = recipeManager.getRecipeInput(Arrays.asList(fs1), null);
                fs = fs1;
            }
            if (rOutput != null) {
                this.gasBuffer.drain(fs, true);
                FluidStack inputFluid = rInput.getFluidInputs().get(0).copy();
                FluidStack outputFluid = rOutput.getFluidOutputs().get(0).copy();
                outputFluid.amount = this.amountOfGasCondensed / inputFluid.amount;
                this.fillCondensateOutputApparatus(ForgeDirection.UP, outputFluid, true);
            }
            this.amountOfGasCondensed = 0;
        }
        if (this.gasBuffer.getFluidAmount() * 3 > this.gasBuffer.getCapacity() * 2) {
            FluidStack passingGas = this.gasBuffer.drainLightest(this.gasBuffer.getCapacity() / 2, true);
            this.fillGaseousOutputApparatus(this.gasInputDirection, passingGas, true);
        }
        if (this.fluidTank.getFluid() != null) {
            FluidStack coolant = this.fluidTank.drain(5, true);
            this.fillHeatTransferAgentOutputApparatus(ForgeDirection.UP, coolant, true);
        }
    }

    private int getAmountOfCondensedGas(int amountOfCoolant, int amountOfGas, int boilingPointOfGas, int temperatureOfCoolant, float densityOfGas, float densityOfCoolant) {
        float Q2;
        int dt2;
        float deltaT;
        float Q1;
        if (amountOfCoolant <= 0 || amountOfGas <= 0 || boilingPointOfGas - 20 < temperatureOfCoolant) {
            return 0;
        }
        int L = amountOfGas;
        int t2 = boilingPointOfGas;
        int t1 = temperatureOfCoolant;
        int dt1 = t2 - t1;
        float maxQ = H * (float)L * densityOfGas;
        int t1_1 = t1;
        for (int i = 0; i < 10 && !((Q1 = kF * (deltaT = dt1 > 2 * (dt2 = t2 - (t1_1 = t1 + (int)((Q2 = H * (float)L * densityOfGas) / fluidC / (float)amountOfCoolant / densityOfCoolant))) ? (float)((double)(dt1 - dt2) / Math.log((double)dt2 / (double)dt1)) : (float)(dt1 + dt2) * 0.5f)) >= maxQ); ++i) {
            int next_L = (int)(Q1 / H / densityOfGas);
            if (Math.abs(next_L - L) < 4) {
                L = next_L;
                break;
            }
            L = next_L;
        }
        if (t1_1 > t1) {
            this.fluidTank.setTemperature(t1_1);
        } else {
            this.fluidTank.setTemperature(t1 + 1);
        }
        return L;
    }

    public String func_145825_b() {
        return "precipitatorCondenser";
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int mX() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    public int mZ() {
        switch (this.getFacing()) {
            case 2: {
                return -1;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public int mLZ() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    public int mLX() {
        switch (this.getFacing()) {
            case 2: {
                return 1;
            }
            case 3: {
                return -1;
            }
        }
        return 0;
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return false;
    }

    public boolean canFill(ForgeDirection direction, Fluid fluid) {
        return direction == ForgeDirection.UP || this.gasCanPass(direction) && fluid.isGaseous();
    }

    public int fill(ForgeDirection direction, FluidStack fluidStack, boolean doFill) {
        if (fluidStack != null && fluidStack.getFluid() != null && fluidStack.amount > 0) {
            if (this.gasCanPass(direction) && fluidStack != null && fluidStack.getFluid() != null && fluidStack.amount > 0) {
                this.gasInputDirection = direction;
                if (fluidStack.getFluid().isGaseous() && fluidStack.getFluid().getDensity() < 40) {
                    return this.gasBuffer.fill(fluidStack, doFill);
                }
                return this.fillCondensateOutputApparatus(ForgeDirection.UP, fluidStack, doFill);
            }
            if (direction == ForgeDirection.UP) {
                return this.fluidTank.fill(fluidStack, doFill);
            }
        }
        return 0;
    }

    private int fillCondensateOutputApparatus(ForgeDirection direction, FluidStack fluidStack, boolean doFill) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + this.mLX(), this.field_145848_d - 1, this.field_145849_e + this.mLZ());
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).fill(direction, fluidStack, doFill);
        }
        return 0;
    }

    private int fillHeatTransferAgentOutputApparatus(ForgeDirection direction, FluidStack fluidStack, boolean doFill) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).fill(direction, fluidStack, doFill);
        }
        return 0;
    }

    private int fillGaseousOutputApparatus(ForgeDirection direction, FluidStack fluidStack, boolean doFill) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c - direction.offsetX, this.field_145848_d, this.field_145849_e - direction.offsetZ);
        if (te instanceof IFluidHandler) {
            int amountFilled = ((IFluidHandler)te).fill(direction, fluidStack, doFill);
            return amountFilled;
        }
        return 0;
    }

    public boolean gasCanPass(ForgeDirection direction) {
        switch (this.getFacing()) {
            case 4: {
                return direction == ForgeDirection.WEST || direction == ForgeDirection.EAST;
            }
            case 5: {
                return direction == ForgeDirection.WEST || direction == ForgeDirection.EAST;
            }
            case 2: {
                return direction == ForgeDirection.NORTH || direction == ForgeDirection.SOUTH;
            }
            case 3: {
                return direction == ForgeDirection.NORTH || direction == ForgeDirection.SOUTH;
            }
        }
        return direction == ForgeDirection.NORTH || direction == ForgeDirection.SOUTH;
    }

    public void setFacing(short facing1) {
        super.setFacing((short)Math.max(facing1, 2));
    }

    public FluidStack drain(ForgeDirection arg0, FluidStack arg1, boolean arg2) {
        return null;
    }

    public FluidStack drain(ForgeDirection arg0, int arg1, boolean arg2) {
        return null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection arg0) {
        return new FluidTankInfo[]{this.fluidTank.getInfo(), this.gasBuffer.getInfo()};
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }
}

