/*
 * Decompiled with CFR 0.152.
 */
package ihl.recipes;

import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ihl.flexible_cable.IWire;
import ihl.recipes.RecipeInputWire;
import ihl.utils.IHLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class UniversalRecipeInput {
    private final List<FluidStack> fluidInputs = new ArrayList<FluidStack>();
    private final List<IRecipeInput> itemInputs = new ArrayList<IRecipeInput>();
    private List<ItemStack> noODItemInputs = new ArrayList<ItemStack>();

    public UniversalRecipeInput(List<FluidStack> fluidInputs1, List itemInputs1) {
        if (fluidInputs1 != null) {
            this.fluidInputs.addAll(fluidInputs1);
        }
        if (itemInputs1 != null) {
            for (Object material : itemInputs1) {
                if (material == null) {
                    throw new NullPointerException("Recipe input cannot be null!");
                }
                if (material instanceof ItemStack) {
                    ItemStack stack = (ItemStack)material;
                    String oreDictName = IHLUtils.getFirstOreDictNameExcludingTagAny(stack);
                    if (stack.func_77973_b() instanceof IWire) {
                        this.itemInputs.add(new RecipeInputWire(stack));
                        continue;
                    }
                    if (!oreDictName.isEmpty() && oreDictName.length() > 3) {
                        this.itemInputs.add((IRecipeInput)new RecipeInputOreDict(oreDictName, stack.field_77994_a));
                        continue;
                    }
                    this.itemInputs.add((IRecipeInput)new RecipeInputItemStack(stack));
                    continue;
                }
                this.itemInputs.add((IRecipeInput)material);
            }
        }
    }

    public boolean matches(List<FluidStack> fluidInputs1, List<ItemStack> itemInputs1) {
        if (this.fluidInputs.size() > 0 && fluidInputs1 == null || this.itemInputs.size() > 0 && itemInputs1 == null || fluidInputs1 != null && this.fluidInputs.size() != fluidInputs1.size() || itemInputs1 != null && this.itemInputs.size() != itemInputs1.size()) {
            return false;
        }
        if (fluidInputs1 != null) {
            Iterator<FluidStack> fi1 = fluidInputs1.iterator();
            for (FluidStack fs : this.fluidInputs) {
                FluidStack fs1 = fi1.next();
                if (fs1 != null && fs.getFluid() == fs1.getFluid()) continue;
                return false;
            }
        }
        if (itemInputs1 != null) {
            Iterator<IRecipeInput> ii = this.itemInputs.iterator();
            Iterator<ItemStack> ii1 = itemInputs1.iterator();
            while (ii.hasNext()) {
                IRecipeInput is = ii.next();
                ItemStack is1 = ii1.next();
                if (is1 != null && is.matches(is1)) continue;
                return false;
            }
        }
        return true;
    }

    public List<FluidStack> getFluidInputs() {
        return this.fluidInputs;
    }

    public List<IRecipeInput> getItemInputs() {
        return this.itemInputs;
    }

    public boolean matches(UniversalRecipeInput input) {
        List<IRecipeInput> rInputs = input.getItemInputs();
        Iterator<IRecipeInput> ii = rInputs.iterator();
        ArrayList<ItemStack> rInputsItems = new ArrayList<ItemStack>();
        while (ii.hasNext()) {
            IRecipeInput is = ii.next();
            rInputsItems.add((ItemStack)is.getInputs().get(0));
        }
        return this.matches(input.getFluidInputs(), rInputsItems);
    }

    public boolean adjustAmounts(List<FluidStack> fluidInputs1, List<ItemStack> itemInputs1, boolean doAdjustAmounts) {
        if (this.fluidInputs.size() > 0 && fluidInputs1 == null || this.itemInputs.size() > 0 && itemInputs1 == null || fluidInputs1 != null && this.fluidInputs.size() != fluidInputs1.size() || itemInputs1 != null && this.itemInputs.size() != itemInputs1.size()) {
            return false;
        }
        if (fluidInputs1 != null) {
            Iterator<FluidStack> fi1 = fluidInputs1.iterator();
            for (FluidStack fs : this.fluidInputs) {
                FluidStack fs1 = fi1.next();
                if (fs.getFluid() != fs1.getFluid() || fs1.amount < fs.amount) {
                    return false;
                }
                if (!doAdjustAmounts) continue;
                fs1.amount -= fs.amount;
                if (fs1.amount > 0) continue;
                fs1 = null;
            }
        }
        if (itemInputs1 != null) {
            Iterator<IRecipeInput> ii = this.itemInputs.iterator();
            Iterator<ItemStack> ii1 = itemInputs1.iterator();
            while (ii.hasNext()) {
                IRecipeInput is = ii.next();
                ItemStack is1 = ii1.next();
                if (is1 == null || !IHLUtils.isIRecipeInputMatchesWithAmount(is, is1)) {
                    return false;
                }
                if (!doAdjustAmounts || !IHLUtils.reduceItemStackAmountUsingIRecipeInput(is, is1)) continue;
                is1 = null;
            }
        }
        return true;
    }

    public boolean adjustAmounts(UniversalRecipeInput input, boolean doAdjustAmounts) {
        List<IRecipeInput> rInputs = input.getItemInputs();
        Iterator<IRecipeInput> ii = rInputs.iterator();
        ArrayList<ItemStack> rInputsItems = new ArrayList<ItemStack>();
        while (ii.hasNext()) {
            IRecipeInput is = ii.next();
            rInputsItems.add((ItemStack)is.getInputs().get(0));
        }
        return this.adjustAmounts(input.getFluidInputs(), rInputsItems, doAdjustAmounts);
    }

    public int getMultiplierAndAdjustAmounts(List<FluidStack> fluidInputs1, List<ItemStack> itemInputs1) {
        int multiplier1;
        int multiplier = Integer.MAX_VALUE;
        if (this.fluidInputs.size() > 0 && fluidInputs1 == null || this.itemInputs.size() > 0 && itemInputs1 == null || fluidInputs1 != null && this.fluidInputs.size() != fluidInputs1.size() || itemInputs1 != null && this.itemInputs.size() != itemInputs1.size()) {
            return 0;
        }
        if (fluidInputs1 != null) {
            Iterator<FluidStack> fi1 = fluidInputs1.iterator();
            for (FluidStack fs : this.fluidInputs) {
                FluidStack fs1 = fi1.next();
                if (fs.getFluid() != fs1.getFluid() || fs1.amount < fs.amount) {
                    return 0;
                }
                if (fs.amount <= 0) continue;
                multiplier1 = fs1.amount / fs.amount;
                if (multiplier1 < multiplier) {
                    multiplier = multiplier1;
                }
                fs1.amount -= fs.amount * multiplier;
                if (fs1.amount > 0) continue;
                fs1 = null;
            }
        }
        if (itemInputs1 != null) {
            Iterator<IRecipeInput> ii = this.itemInputs.iterator();
            Iterator<ItemStack> ii1 = itemInputs1.iterator();
            while (ii.hasNext()) {
                IRecipeInput is = ii.next();
                ItemStack is1 = ii1.next();
                if (is == null) continue;
                if (is1 == null || !IHLUtils.isIRecipeInputMatchesWithAmount(is, is1)) {
                    return 0;
                }
                if (is.getAmount() <= 0) continue;
                multiplier1 = is1.field_77994_a / is.getAmount();
                if (multiplier1 < multiplier) {
                    multiplier = multiplier1;
                }
                is1.field_77994_a -= is.getAmount() * multiplier;
                if (is1.field_77994_a > 0) continue;
                is1 = null;
            }
        }
        if (multiplier < Integer.MAX_VALUE) {
            return multiplier;
        }
        return 1;
    }

    public boolean containItemStack(ItemStack ingredient) {
        if (this.itemInputs == null || this.itemInputs.isEmpty()) {
            return false;
        }
        for (IRecipeInput is : this.itemInputs) {
            if (!is.matches(ingredient)) continue;
            return true;
        }
        return false;
    }

    public boolean containFluidStack(FluidStack fluidStack) {
        if (this.fluidInputs == null || this.fluidInputs.isEmpty()) {
            return false;
        }
        for (FluidStack is : this.fluidInputs) {
            if (is == null || is.getFluid() != fluidStack.getFluid()) continue;
            return true;
        }
        return false;
    }
}

