/*
 * Decompiled with CFR 0.152.
 */
package ihl.crop_harvestors;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.IC2Items;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.IUpgradableBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.network.NetworkManager;
import ihl.IHLMod;
import ihl.crop_harvestors.BlowerContainer;
import ihl.crop_harvestors.BlowerGui;
import ihl.utils.IHLInvSlotDischarge;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class BlowerTileEntity
extends TileEntityInventory
implements IEnergySink,
IHasGui,
IUpgradableBlock {
    private int startUpCounter = 0;
    private int tier = 1;
    private int defaultTier = 1;
    public int maxStorage = 100;
    private int defaultMaxStorage = 100;
    private double energy = 0.0;
    private double defaultEnergyConsume = 5.0;
    private double energyConsume = 5.0;
    private int defaultAirSpeedBase = 100;
    public int airSpeedBase = 100;
    private boolean shouldCalculateAirFlow = true;
    private int sCAFCount = 0;
    public boolean addedToEnergyNet = false;
    private boolean hasEntityInFlow = false;
    private ArrayList<AirSpeedZone> aszlist = new ArrayList();
    public final InvSlotUpgrade upgradeSlot;
    public final IHLInvSlotDischarge dischargeSlot;
    public int updateChecksum = -1;
    private final float lambda = 1.0E-5f;
    private Random rand = new Random();
    public int operationRange = -1;
    public int lastOperationRange = 0;
    private AudioSource startAS;
    private AudioSource loopAS;
    private AudioSource stopAS;

    public BlowerTileEntity() {
        this.defaultTier = IHLMod.config.blowerTier;
        this.defaultMaxStorage = IHLMod.config.blowerMaxEnergyStorage;
        this.defaultEnergyConsume = IHLMod.config.blowerEnergyConsumePerTick;
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 2, 4);
        this.dischargeSlot = new IHLInvSlotDischarge(this, 1, InvSlot.Access.IO, this.tier, InvSlot.InvSide.BOTTOM);
    }

    public List<String> getNetworkedFields() {
        List fields = super.getNetworkedFields();
        fields.add("tier");
        fields.add("airSpeedBase");
        fields.add("maxStorage");
        return fields;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        block2: {
            super.func_145839_a(nbttagcompound);
            try {
                this.energy = nbttagcompound.func_74769_h("energy");
            }
            catch (Exception var3) {
                this.energy = nbttagcompound.func_74762_e("energy");
                if (this.maxStorage <= Integer.MAX_VALUE) break block2;
                this.energy *= 10.0;
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
        if (IC2.platform.isRendering() && (this.startAS == null || this.loopAS == null || this.stopAS == null)) {
            this.startAS = IC2.audioManager.createSource((Object)this, PositionSpec.Center, this.getStartSoundFile(), false, false, 1.0f);
            this.loopAS = IC2.audioManager.createSource((Object)this, PositionSpec.Center, this.getLoopSoundFile(), true, false, 1.0f);
            this.stopAS = IC2.audioManager.createSource((Object)this, PositionSpec.Center, this.getStopSoundFile(), false, false, 1.0f);
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.loopAS != null) {
            this.startAS.stop();
            this.loopAS.stop();
            this.stopAS.stop();
            this.startAS = null;
            this.loopAS = null;
            this.stopAS = null;
            IC2.audioManager.removeSources((Object)this);
        }
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        if (this.dischargeSlot.get() != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.dischargeSlot.get()));
        }
        if (this.upgradeSlot.get(0) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(0)));
        }
        if (this.upgradeSlot.get(1) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(1)));
        }
        if (this.upgradeSlot.get(2) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(2)));
        }
        if (this.upgradeSlot.get(3) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(3)));
        }
        return new ItemStack(IHLMod.blowerBlock, 1);
    }

    public void setFacing(short facing1) {
        super.setFacing(facing1);
        this.updateChecksum = -1;
    }

    public boolean enableUpdateEntity() {
        return true;
    }

    public String getStartSoundFile() {
        return "Machines/IHL Industrial Fan/start.ogg";
    }

    public String getLoopSoundFile() {
        return "Machines/IHL Industrial Fan/loop.ogg";
    }

    public String getStopSoundFile() {
        return "Machines/IHL Industrial Fan/stop.ogg";
    }

    public void func_145845_h() {
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
        if (this.dischargeSlot.tier != this.tier) {
            this.dischargeSlot.tier = this.tier;
        }
        if (this.getDemandedEnergy() > 1.0) {
            double amount = this.dischargeSlot.discharge(this.getDemandedEnergy(), false);
            this.energy += amount;
        }
        if (this.energy > (double)this.maxStorage) {
            this.energy = this.maxStorage;
        }
        if (IC2.platform.isSimulating() && !this.getActive() && this.energy >= this.energyConsume * 2.0) {
            this.setActive(true);
        } else if (IC2.platform.isSimulating() && this.getActive() && this.energy < this.energyConsume) {
            this.setActive(false);
        }
        if (!this.aszlist.isEmpty() && this.getActive()) {
            if (this.energy >= this.energyConsume) {
                this.energy -= this.energyConsume;
            }
            for (AirSpeedZone asz : this.aszlist) {
                List entityList = this.field_145850_b.func_72872_a(Entity.class, asz.getAABB());
                if (entityList.isEmpty()) continue;
                if (this.sCAFCount <= 0) {
                    this.aszlist.clear();
                    this.calculateAirSpeed();
                    this.sCAFCount = 40;
                    break;
                }
                for (Entity ent : entityList) {
                    if (!asz.isEntityMoveable(ent)) continue;
                    if (ent instanceof EntityPlayer) {
                        if (!this.field_145850_b.field_72995_K) continue;
                        ent.func_70024_g((double)this.mX() * 0.1, (double)this.mY() * 0.05, (double)this.mZ() * 0.1);
                        continue;
                    }
                    ent.func_70024_g((double)this.mX() * 0.1, (double)this.mY() * 0.05, (double)this.mZ() * 0.1);
                }
            }
        }
        if (this.sCAFCount > 0) {
            --this.sCAFCount;
        } else {
            this.calculateAirSpeed();
            if (this.operationRange == this.lastOperationRange) {
                this.sCAFCount = 600;
            } else {
                this.sCAFCount = 20;
                this.lastOperationRange = this.operationRange;
            }
        }
        if (IC2.platform.isRendering() && this.loopAS != null) {
            if (this.getActive()) {
                if (this.startUpCounter > 12) {
                    this.startUpCounter = 0;
                }
                if (this.startUpCounter == 0) {
                    this.stopAS.stop();
                    this.startAS.play();
                }
                if (this.startUpCounter < 10) {
                    ++this.startUpCounter;
                } else if (this.startUpCounter == 10) {
                    this.startAS.stop();
                    this.loopAS.play();
                    ++this.startUpCounter;
                }
            } else if (this.startUpCounter > 0) {
                this.startAS.stop();
                this.loopAS.stop();
                this.stopAS.play();
                if (this.startUpCounter < 170) {
                    ++this.startUpCounter;
                } else {
                    this.startUpCounter = 0;
                    this.stopAS.stop();
                }
            }
        } else if (IC2.platform.isRendering() && !this.getActive() && this.loopAS != null) {
            this.loopAS.stop();
        }
    }

    private void calculateAirSpeed() {
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        int airSpeed = this.airSpeedBase;
        int x0 = x;
        int y0 = y;
        int z0 = z;
        int flowExtL = 0;
        int flowExtR = 0;
        int flowExtT = 0;
        int flowExtB = 0;
        int flowCanBeExtL = 0;
        int flowCanBeExtR = 0;
        int flowCanBeExtT = 0;
        int flowCanBeExtB = 0;
        int checkFlowL = 0;
        int checkFlowR = 0;
        int checkFlowT = 0;
        int checkFlowB = 0;
        checkFlowL = Math.max(this.neighborBlowerOperationRange(this.field_145851_c + this.mXL() + this.mX(), this.field_145848_d + this.mYL() + this.mY(), this.field_145849_e + this.mZL() + this.mZ()), this.neighborBlowerOperationRange(this.field_145851_c + this.mXL() - this.mX(), this.field_145848_d + this.mYL() - this.mY(), this.field_145849_e + this.mZL() - this.mZ()));
        checkFlowR = Math.max(this.neighborBlowerOperationRange(this.field_145851_c - this.mXL() + this.mX(), this.field_145848_d - this.mYL() + this.mY(), this.field_145849_e - this.mZL() + this.mZ()), this.neighborBlowerOperationRange(this.field_145851_c - this.mXL() - this.mX(), this.field_145848_d - this.mYL() - this.mY(), this.field_145849_e - this.mZL() - this.mZ()));
        checkFlowT = Math.max(Math.max(this.neighborBlowerOperationRange(this.field_145851_c + this.mXT() + this.mX(), this.field_145848_d + this.mYT() + this.mY(), this.field_145849_e + this.mZT() + this.mZ()), this.neighborBlowerOperationRange(this.field_145851_c + this.mXT() - this.mX(), this.field_145848_d + this.mYT() - this.mY(), this.field_145849_e + this.mZT() - this.mZ())), this.neighborBlowerOperationRange(this.field_145851_c + this.mXT(), this.field_145848_d + this.mYT(), this.field_145849_e + this.mZT()));
        checkFlowB = Math.max(Math.max(this.neighborBlowerOperationRange(this.field_145851_c - this.mXT() + this.mX(), this.field_145848_d - this.mYT() + this.mY(), this.field_145849_e - this.mZT() + this.mZ()), this.neighborBlowerOperationRange(this.field_145851_c - this.mXT() - this.mX(), this.field_145848_d - this.mYT() - this.mY(), this.field_145849_e - this.mZT() - this.mZ())), this.neighborBlowerOperationRange(this.field_145851_c - this.mXT(), this.field_145848_d - this.mYT(), this.field_145849_e - this.mZT()));
        int asg = this.getAirSpeedGrade(airSpeed);
        block0: for (int step = 0; step < 256; ++step) {
            int s1;
            int s0;
            int tb;
            x += this.mX();
            y += this.mY();
            z += this.mZ();
            if ((asg = this.getAirSpeedGrade(airSpeed -= Math.round(1.0E-5f * (float)(airSpeed * airSpeed)) + 1)) == 0) break;
            int i1 = 0;
            int i2 = 0;
            int il = 0;
            int ir = 0;
            int it = 0;
            int ib = 0;
            for (tb = -flowExtB; tb <= flowExtT; ++tb) {
                ++i1;
                if (this.isAirPassable(x + this.mXL() * (flowExtL + 1) + this.mXT() * tb, y + this.mYL() * (flowExtL + 1) + this.mYT() * tb, z + this.mZL() * (flowExtL + 1) + this.mZT() * tb)) {
                    ++il;
                }
                if (!this.isAirPassable(x - this.mXL() * (flowExtR + 1) + this.mXT() * tb, y - this.mYL() * (flowExtR + 1) + this.mYT() * tb, z - this.mZL() * (flowExtR + 1) + this.mZT() * tb)) continue;
                ++ir;
            }
            if (i1 == il && step >= checkFlowL) {
                ++flowCanBeExtL;
            }
            if (i1 == ir && step >= checkFlowR) {
                ++flowCanBeExtR;
            }
            for (int lr = -flowExtL; lr <= flowExtR; ++lr) {
                ++i2;
                if (this.isAirPassable(x + this.mXT() * (flowExtT + 1) + this.mXL() * lr, y + this.mYT() * (flowExtT + 1) + this.mYL() * lr, z + this.mZT() * (flowExtT + 1) + this.mZL() * lr)) {
                    ++it;
                }
                if (!this.isAirPassable(x - this.mXT() * (flowExtB + 1) + this.mXL() * lr, y - this.mYT() * (flowExtB + 1) + this.mYL() * lr, z - this.mZT() * (flowExtB + 1) + this.mZL() * lr)) continue;
                ++ib;
            }
            if (i2 == it && step >= checkFlowT) {
                ++flowCanBeExtT;
            }
            if (i2 == ib && step >= checkFlowB) {
                ++flowCanBeExtB;
            }
            if ((asg = this.getAirSpeedGrade(airSpeed -= Math.round(1.0E-5f * (float)(airSpeed * airSpeed) * (float)(il + ir + it + ib)) + il + ir + it + ib)) == 0) {
                this.operationRange = step;
                break;
            }
            if (flowCanBeExtB >= 4) {
                flowCanBeExtB = 0;
                this.aszlist.add(new AirSpeedZone(asg, x0 - this.mXL() * flowExtR - this.mXT() * flowExtB, y0 - this.mYL() * flowExtR - this.mYT() * flowExtB, z0 - this.mZL() * flowExtR - this.mZT() * flowExtB, x - this.mX() + this.mXL() * flowExtL + this.mXT() * flowExtT, y - this.mY() + this.mYL() * flowExtL + this.mYT() * flowExtT, z - this.mZ() + this.mZL() * flowExtL + this.mZT() * flowExtT));
                x0 = x;
                y0 = y;
                z0 = z;
                s0 = (flowExtR + flowExtL + 1) * (flowExtT + flowExtB + 1);
                s1 = (flowExtR + flowExtL + 1) * (flowExtT + ++flowExtB + 1);
                airSpeed = airSpeed * s0 / s1;
            } else if (flowCanBeExtT >= 4) {
                flowCanBeExtT = 0;
                this.aszlist.add(new AirSpeedZone(asg, x0 - this.mXL() * flowExtR - this.mXT() * flowExtB, y0 - this.mYL() * flowExtR - this.mYT() * flowExtB, z0 - this.mZL() * flowExtR - this.mZT() * flowExtB, x - this.mX() + this.mXL() * flowExtL + this.mXT() * flowExtT, y - this.mY() + this.mYL() * flowExtL + this.mYT() * flowExtT, z - this.mZ() + this.mZL() * flowExtL + this.mZT() * flowExtT));
                x0 = x;
                y0 = y;
                z0 = z;
                s0 = (flowExtR + flowExtL + 1) * (flowExtT + flowExtB + 1);
                s1 = (flowExtR + flowExtL + 1) * (++flowExtT + flowExtB + 1);
                airSpeed = airSpeed * s0 / s1;
            } else if (flowCanBeExtR >= 4) {
                flowCanBeExtR = 0;
                this.aszlist.add(new AirSpeedZone(asg, x0 - this.mXL() * flowExtR - this.mXT() * flowExtB, y0 - this.mYL() * flowExtR - this.mYT() * flowExtB, z0 - this.mZL() * flowExtR - this.mZT() * flowExtB, x - this.mX() + this.mXL() * flowExtL + this.mXT() * flowExtT, y - this.mY() + this.mYL() * flowExtL + this.mYT() * flowExtT, z - this.mZ() + this.mZL() * flowExtL + this.mZT() * flowExtT));
                x0 = x;
                y0 = y;
                z0 = z;
                s0 = (flowExtR + flowExtL + 1) * (flowExtT + flowExtB + 1);
                s1 = (++flowExtR + flowExtL + 1) * (flowExtT + flowExtB + 1);
                airSpeed = airSpeed * s0 / s1;
            } else if (flowCanBeExtL >= 3) {
                flowCanBeExtL = 0;
                this.aszlist.add(new AirSpeedZone(asg, x0 - this.mXL() * flowExtR - this.mXT() * flowExtB, y0 - this.mYL() * flowExtR - this.mYT() * flowExtB, z0 - this.mZL() * flowExtR - this.mZT() * flowExtB, x - this.mX() + this.mXL() * flowExtL + this.mXT() * flowExtT, y - this.mY() + this.mYL() * flowExtL + this.mYT() * flowExtT, z - this.mZ() + this.mZL() * flowExtL + this.mZT() * flowExtT));
                x0 = x;
                y0 = y;
                z0 = z;
                s0 = (flowExtR + flowExtL + 1) * (flowExtT + flowExtB + 1);
                s1 = (flowExtR + ++flowExtL + 1) * (flowExtT + flowExtB + 1);
                airSpeed = airSpeed * s0 / s1;
            } else if (flowCanBeExtR >= 3) {
                flowCanBeExtR = 0;
                this.aszlist.add(new AirSpeedZone(asg, x0 - this.mXL() * flowExtR - this.mXT() * flowExtB, y0 - this.mYL() * flowExtR - this.mYT() * flowExtB, z0 - this.mZL() * flowExtR - this.mZT() * flowExtB, x - this.mX() + this.mXL() * flowExtL + this.mXT() * flowExtT, y - this.mY() + this.mYL() * flowExtL + this.mYT() * flowExtT, z - this.mZ() + this.mZL() * flowExtL + this.mZT() * flowExtT));
                x0 = x;
                y0 = y;
                z0 = z;
                s0 = (flowExtR + flowExtL + 1) * (flowExtT + flowExtB + 1);
                s1 = (++flowExtR + flowExtL + 1) * (flowExtT + flowExtB + 1);
                airSpeed = airSpeed * s0 / s1;
            } else if (flowCanBeExtT >= 3) {
                flowCanBeExtT = 0;
                this.aszlist.add(new AirSpeedZone(asg, x0 - this.mXL() * flowExtR - this.mXT() * flowExtB, y0 - this.mYL() * flowExtR - this.mYT() * flowExtB, z0 - this.mZL() * flowExtR - this.mZT() * flowExtB, x - this.mX() + this.mXL() * flowExtL + this.mXT() * flowExtT, y - this.mY() + this.mYL() * flowExtL + this.mYT() * flowExtT, z - this.mZ() + this.mZL() * flowExtL + this.mZT() * flowExtT));
                x0 = x;
                y0 = y;
                z0 = z;
                s0 = (flowExtR + flowExtL + 1) * (flowExtT + flowExtB + 1);
                s1 = (flowExtR + flowExtL + 1) * (++flowExtT + flowExtB + 1);
                airSpeed = airSpeed * s0 / s1;
            } else if (flowCanBeExtB >= 3) {
                flowCanBeExtB = 0;
                this.aszlist.add(new AirSpeedZone(asg, x0 - this.mXL() * flowExtR - this.mXT() * flowExtB, y0 - this.mYL() * flowExtR - this.mYT() * flowExtB, z0 - this.mZL() * flowExtR - this.mZT() * flowExtB, x - this.mX() + this.mXL() * flowExtL + this.mXT() * flowExtT, y - this.mY() + this.mYL() * flowExtL + this.mYT() * flowExtT, z - this.mZ() + this.mZL() * flowExtL + this.mZT() * flowExtT));
                x0 = x;
                y0 = y;
                z0 = z;
                s0 = (flowExtR + flowExtL + 1) * (flowExtT + flowExtB + 1);
                s1 = (flowExtR + flowExtL + 1) * (flowExtT + ++flowExtB + 1);
                airSpeed = airSpeed * s0 / s1;
            }
            for (tb = -flowExtB; tb <= flowExtT; ++tb) {
                for (int lr = -flowExtR; lr <= flowExtL; ++lr) {
                    if (this.isAirPassable(x + this.mXL() * lr + this.mXT() * tb + this.mX(), y + this.mYL() * lr + this.mYT() * tb + this.mY(), z + this.mZL() * lr + this.mZT() * tb + this.mZ())) continue;
                    if (lr == 0 && tb == 0) {
                        this.operationRange = step;
                        break block0;
                    }
                    this.aszlist.add(new AirSpeedZone(asg, x0 - this.mXL() * flowExtR - this.mXT() * flowExtB, y0 - this.mYL() * flowExtR - this.mYT() * flowExtB, z0 - this.mZL() * flowExtR - this.mZT() * flowExtB, x - this.mX() + this.mXL() * flowExtL + this.mXT() * flowExtT, y - this.mY() + this.mYL() * flowExtL + this.mYT() * flowExtT, z - this.mZ() + this.mZL() * flowExtL + this.mZT() * flowExtT));
                    x0 = x;
                    y0 = y;
                    z0 = z;
                    if (lr > 0) {
                        flowExtL = lr - 1;
                    } else if (lr < 0) {
                        flowExtR = -1 - lr;
                    }
                    if (tb > 0) {
                        flowExtT = tb - 1;
                        continue;
                    }
                    if (tb >= 0) continue;
                    flowExtB = -1 - tb;
                }
            }
        }
        if (asg > 0) {
            this.aszlist.add(new AirSpeedZone(asg, x0 - this.mXL() * flowExtR - this.mXT() * flowExtB, y0 - this.mYL() * flowExtR - this.mYT() * flowExtB, z0 - this.mZL() * flowExtR - this.mZT() * flowExtB, x + this.mXL() * flowExtL + this.mXT() * flowExtT, y + this.mYL() * flowExtL + this.mYT() * flowExtT, z + this.mZL() * flowExtL + this.mZT() * flowExtT));
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        switch (direction) {
            case UP: {
                return this.mY() != 1;
            }
            case DOWN: {
                return this.mY() != -1;
            }
            case NORTH: {
                return this.mZ() != -1 && this.mZL() == 0;
            }
            case EAST: {
                return this.mX() != 1 && this.mXL() == 0;
            }
            case SOUTH: {
                return this.mZ() != 1 && this.mZL() == 0;
            }
            case WEST: {
                return this.mX() != -1 && this.mXL() == 0;
            }
        }
        return false;
    }

    private boolean isCNE(int x, int y, int z, int x1, int y1, int z1) {
        return x != x1 || y != y1 || z != z1;
    }

    private boolean isAirPassable(int x, int y, int z) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if (block != null && !block.isNormalCube((IBlockAccess)this.field_145850_b, x, y, z)) {
            if (!block.func_149703_v() || block.isAir((IBlockAccess)this.field_145850_b, x, y, z) || block.func_149704_x() > 0.15 || block.func_149753_y() < 0.85 || block.func_149665_z() > 0.15 || block.func_149669_A() < 0.85 || block.func_149706_B() > 0.15 || block.func_149693_C() < 0.85) {
                return true;
            }
            AxisAlignedBB cb = block.func_149668_a(this.field_145850_b, x, y, z);
            if (cb != null && cb.field_72336_d <= 1.0 && cb.field_72336_d >= 0.0 && cb.field_72340_a <= 1.0 && cb.field_72340_a >= 0.0 && cb.field_72337_e <= 1.0 && cb.field_72337_e >= 0.0 && cb.field_72338_b <= 1.0 && cb.field_72338_b >= 0.0 && cb.field_72334_f <= 1.0 && cb.field_72334_f >= 0.0 && cb.field_72339_c <= 1.0 && cb.field_72339_c >= 0.0 && (cb.field_72336_d < 0.85 || cb.field_72340_a > 0.15 || cb.field_72337_e < 0.85 || cb.field_72338_b > 0.15 || cb.field_72334_f < 0.85 || cb.field_72339_c > 0.15)) {
                return true;
            }
        }
        return false;
    }

    private int getAirSpeedGrade(int airSpeed) {
        if (airSpeed < 30) {
            return 0;
        }
        if (airSpeed < 100) {
            return 1;
        }
        if (airSpeed < 200) {
            return 2;
        }
        if (airSpeed < 300) {
            return 3;
        }
        if (airSpeed < 400) {
            return 4;
        }
        if (airSpeed < 500) {
            return 5;
        }
        if (airSpeed < 600) {
            return 6;
        }
        return 7;
    }

    private int mX() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    private int mY() {
        switch (this.getFacing()) {
            case 0: {
                return -1;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    private int mZ() {
        switch (this.getFacing()) {
            case 2: {
                return -1;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    private int mXL() {
        switch (this.getFacing()) {
            case 0: {
                return -1;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return -1;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    private int mYL() {
        return 0;
    }

    private int mZL() {
        switch (this.getFacing()) {
            case 4: {
                return 1;
            }
            case 5: {
                return -1;
            }
        }
        return 0;
    }

    private int mXT() {
        return 0;
    }

    private int mYT() {
        switch (this.getFacing()) {
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    private int mZT() {
        switch (this.getFacing()) {
            case 0: {
                return 1;
            }
            case 1: {
                return -1;
            }
        }
        return 0;
    }

    public String func_145825_b() {
        return "blower";
    }

    public int getStored() {
        return Math.round((float)this.energy);
    }

    public void setStored(int value) {
        this.energy = value;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer arg0, boolean arg1) {
        return new BlowerGui(new BlowerContainer(arg0, this));
    }

    public boolean getGui(EntityPlayer player) {
        return this instanceof IHasGui ? (IC2.platform.isSimulating() ? IC2.platform.launchGui(player, (IHasGui)this) : true) : false;
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer arg0) {
        return new BlowerContainer(arg0, this);
    }

    public void onGuiClosed(EntityPlayer arg0) {
    }

    public void setOverclockRates() {
        int speedUp = 0;
        int tierUp = 0;
        int capacityUp = 0;
        int checksum = 0;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            if (this.upgradeSlot.get(i) == null) continue;
            if (this.upgradeSlot.get(i).func_77960_j() == IC2Items.getItem((String)"overclockerUpgrade").func_77960_j()) {
                speedUp += this.upgradeSlot.get((int)i).field_77994_a;
            }
            if (this.upgradeSlot.get(i).func_77960_j() == IC2Items.getItem((String)"transformerUpgrade").func_77960_j()) {
                tierUp += this.upgradeSlot.get((int)i).field_77994_a;
            }
            if (this.upgradeSlot.get(i).func_77960_j() != IC2Items.getItem((String)"energyStorageUpgrade").func_77960_j()) continue;
            capacityUp += this.upgradeSlot.get((int)i).field_77994_a;
        }
        checksum = speedUp * 4096 + tierUp * 64 + capacityUp;
        if (this.updateChecksum != checksum) {
            this.airSpeedBase = this.isAirPassable(this.field_145851_c + this.mXL(), this.field_145848_d + this.mYL(), this.field_145849_e + this.mZL()) && this.isAirPassable(this.field_145851_c - this.mXL(), this.field_145848_d - this.mYL(), this.field_145849_e - this.mZL()) ? Math.min(3284, (int)((double)this.defaultAirSpeedBase * Math.pow(1.7, speedUp))) : (!this.isAirPassable(this.field_145851_c + this.mXL(), this.field_145848_d + this.mYL(), this.field_145849_e + this.mZL()) && !this.isAirPassable(this.field_145851_c - this.mXL(), this.field_145848_d - this.mYL(), this.field_145849_e - this.mZL()) ? 0 : Math.min(3282, (int)((double)this.defaultAirSpeedBase * Math.pow(1.7, speedUp) * 0.5)));
            this.maxStorage = this.defaultMaxStorage + capacityUp * 10000;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "maxStorage");
            this.energyConsume = (int)Math.min(this.defaultEnergyConsume * Math.pow(1.6, speedUp), (double)this.maxStorage);
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "airSpeedBase");
            this.tier = this.defaultTier + tierUp;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "tier");
            this.updateChecksum = checksum;
        }
    }

    public double getDemandedEnergy() {
        return (double)this.maxStorage - this.energy;
    }

    public int getSinkTier() {
        return this.tier;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= (double)this.maxStorage) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    public List<ItemStack> getCompatibleUpgradeList() {
        ArrayList<ItemStack> compatibleUpgrades = new ArrayList<ItemStack>();
        compatibleUpgrades.add(IC2Items.getItem((String)"overclockerUpgrade"));
        compatibleUpgrades.add(IC2Items.getItem((String)"transformerUpgrade"));
        compatibleUpgrades.add(IC2Items.getItem((String)"energyStorageUpgrade"));
        return compatibleUpgrades;
    }

    public double getEnergy() {
        return this.energy;
    }

    public void setRedstonePowered(boolean arg0) {
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public int neighborBlowerOperationRange(int x, int y, int z) {
        BlowerTileEntity bte;
        if (this.field_145850_b.func_147438_o(x, y, z) != null && this.field_145850_b.func_147438_o(x, y, z) instanceof BlowerTileEntity && (bte = (BlowerTileEntity)this.field_145850_b.func_147438_o(x, y, z)).getFacing() == this.getFacing()) {
            return bte.operationRange;
        }
        return -1;
    }

    public ItemStack getOutput(int arg0) {
        return null;
    }

    public int getOutputSize() {
        return 0;
    }

    public void setOutput(int arg0, ItemStack arg1) {
    }

    private class AirSpeedZone {
        private int airSpeedGrade;
        private int x0;
        private int y0;
        private int z0;
        private int x1;
        private int y1;
        private int z1;

        public AirSpeedZone(int airSpeedGrade1, int vx0, int vy0, int vz0, int vx1, int vy1, int vz1) {
            this.airSpeedGrade = airSpeedGrade1;
            this.x0 = vx0;
            this.y0 = vy0;
            this.z0 = vz0;
            this.x1 = vx1;
            this.y1 = vy1;
            this.z1 = vz1;
        }

        public AxisAlignedBB getAABB() {
            return AxisAlignedBB.func_72330_a((double)Math.min(this.x0, this.x1), (double)Math.min(this.y0, this.y1), (double)Math.min(this.z0, this.z1), (double)((double)Math.max(this.x0, this.x1) + 1.0), (double)((double)Math.max(this.y0, this.y1) + 1.0), (double)((double)Math.max(this.z0, this.z1) + 1.0));
        }

        public boolean equals(Object obj) {
            if (obj instanceof AirSpeedZone) {
                AirSpeedZone asz = (AirSpeedZone)obj;
                return this.x0 == asz.x0 && this.y0 == asz.y0 && this.z0 == asz.z0 && this.x1 == asz.x1 && this.y1 == asz.y1 && this.z1 == asz.z1;
            }
            return false;
        }

        public boolean isEntityMoveable(Entity entity) {
            if (this.airSpeedGrade >= 7) {
                return true;
            }
            return (entity.field_70130_N + 1.0f) * (entity.field_70131_O + 1.0f) <= (float)(this.airSpeedGrade * 2);
        }
    }
}

