/*
 * Decompiled with CFR 0.152.
 */
package ihl.enviroment;

import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.network.NetworkManager;
import ihl.enviroment.LightBulbBlock;
import ihl.enviroment.LightBulbTileEntity;
import ihl.i_hate_liquids.XYZ;
import ihl.utils.IHLUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class SpotlightTileEntity
extends LightBulbTileEntity
implements INetworkTileEntityEventListener {
    Vec3 directionVector = Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0);
    private static final int maxLightRange = 128;
    private final Set<XYZ> xyzGlowningAir = new HashSet<XYZ>();
    private final Set<Vec3> lightVectors = new HashSet<Vec3>();
    private static final Set<Vec3> lightSphereVectors = new HashSet<Vec3>();
    public float rotationPitch = 0.0f;
    public float rotationYaw = 0.0f;
    public float prevRotationPitch = 0.0f;
    public float prevRotationYaw = 0.0f;
    boolean needLightTargetUpdate = false;

    public static void createLightSphereVectors() {
        for (double y = -1.0; y <= 1.0; y += 0.2) {
            double sqr = 1.0 - y * y;
            for (double alpha = 0.0; alpha < Math.PI * 2; alpha += Math.PI * 2 / (sqr * 16.0 + 0.1)) {
                double x = Math.cos(alpha) * sqr;
                double z = Math.sin(alpha) * sqr;
                lightSphereVectors.add(Vec3.func_72443_a((double)(x * 0.25), (double)(y * 0.25), (double)(z * 0.25)));
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.directionVector.field_72450_a = nbttagcompound.func_74769_h("directionVector.xCoord");
        this.directionVector.field_72448_b = nbttagcompound.func_74769_h("directionVector.yCoord");
        this.directionVector.field_72449_c = nbttagcompound.func_74769_h("directionVector.zCoord");
        this.rotationPitch = this.getVectorPitchAngle(this.directionVector);
        this.rotationYaw = this.getVectorYawAngle(this.directionVector);
        this.needLightTargetUpdate = true;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("directionVector.xCoord", this.directionVector.field_72450_a);
        nbttagcompound.func_74780_a("directionVector.yCoord", this.directionVector.field_72448_b);
        nbttagcompound.func_74780_a("directionVector.zCoord", this.directionVector.field_72449_c);
    }

    @Override
    public List<String> getNetworkedFields() {
        List<String> list = super.getNetworkedFields();
        list.add("rotationPitch");
        list.add("rotationYaw");
        return list;
    }

    public void setLightOn() {
        for (XYZ xyz : this.xyzGlowningAir) {
            Block block = this.field_145850_b.func_147439_a(xyz.x, xyz.y, xyz.z);
            if (block != Blocks.field_150350_a && !block.isAir((IBlockAccess)this.field_145850_b, xyz.x, xyz.y, xyz.z)) continue;
            this.field_145850_b.func_147449_b(xyz.x, xyz.y, xyz.z, (Block)LightBulbBlock.glowningAir);
        }
    }

    public void setLightOff() {
        for (XYZ xyz : this.xyzGlowningAir) {
            Block block = this.field_145850_b.func_147439_a(xyz.x, xyz.y, xyz.z);
            if (block != LightBulbBlock.glowningAir) continue;
            this.field_145850_b.func_147468_f(xyz.x, xyz.y, xyz.z);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.needLightTargetUpdate) {
            this.generateGlowningAirList();
            this.updateLightState();
            this.needLightTargetUpdate = false;
        }
        if (this.prevRotationPitch != this.rotationPitch) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "rotationPitch");
            this.prevRotationPitch = this.rotationPitch;
        }
        if (this.prevRotationYaw != this.rotationYaw) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "rotationYaw");
            this.prevRotationYaw = this.rotationYaw;
        }
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("spotlight");
    }

    public void setDirectionVector(EntityLivingBase player) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing());
        Vec3 lookVec = player.func_70040_Z();
        if (lookVec.field_72450_a * (double)dir.offsetX + lookVec.field_72448_b * (double)dir.offsetY + lookVec.field_72449_c * (double)dir.offsetZ < 0.0) {
            double x = player.field_70165_t - (double)this.field_145851_c - 0.5;
            double y = player.field_70163_u + (double)player.func_70047_e() - (double)this.field_145848_d - 0.5;
            double z = player.field_70161_v - (double)this.field_145849_e - 0.5;
            double d = Math.sqrt(x * x + y * y + z * z);
            this.directionVector = Vec3.func_72443_a((double)(x / d), (double)(y / d), (double)(z / d));
        } else {
            this.directionVector = player.func_70040_Z();
        }
        this.rotationPitch = this.getVectorPitchAngle(this.directionVector);
        this.rotationYaw = this.getVectorYawAngle(this.directionVector);
        this.needLightTargetUpdate = true;
        ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 0, true);
    }

    private void generateGlowningAirList() {
        this.setLightOff();
        this.xyzGlowningAir.clear();
        Iterator<Vec3> lvi = lightSphereVectors.iterator();
        while (lvi.hasNext()) {
            this.traceVectorToLastAirBlock(lvi.next());
        }
    }

    private void traceVectorToLastAirBlock(Vec3 vector) {
        double dx = this.directionVector.field_72450_a;
        double dx1 = vector.field_72450_a;
        double dy = this.directionVector.field_72448_b;
        double dy1 = vector.field_72448_b;
        double dz = this.directionVector.field_72449_c;
        double dz1 = vector.field_72449_c;
        if (2.0 * dx * dx1 + dx1 * dx1 + 2.0 * dy * dy1 + dy1 * dy1 + 2.0 * dz * dz1 + dz1 * dz1 > 0.0) {
            double x1 = (double)this.field_145851_c + 0.5;
            double y1 = (double)this.field_145848_d + 0.5;
            double z1 = (double)this.field_145849_e + 0.5;
            int xi1 = this.field_145851_c;
            int yi1 = this.field_145848_d;
            int zi1 = this.field_145849_e;
            int airx = this.field_145851_c;
            int airy = this.field_145848_d;
            int airz = this.field_145849_e;
            for (int i = 0; i < 128; ++i) {
                int xi = (int)Math.floor(x1 + (dx + dx1) * (double)i * 0.79);
                int yi = (int)Math.floor(y1 + (dy + dy1) * (double)i * 0.79);
                int zi = (int)Math.floor(z1 + (dz + dz1) * (double)i * 0.79);
                if (xi == xi1 && yi == yi1 && zi == zi1) continue;
                Block block = this.field_145850_b.func_147439_a(xi, yi, zi);
                if (block != Blocks.field_150350_a && !block.isAir((IBlockAccess)this.field_145850_b, xi, yi, zi) && block.func_149688_o() != Material.field_151592_s && block.func_149688_o() != Material.field_151579_a) {
                    this.xyzGlowningAir.add(new XYZ(airx, airy, airz));
                    break;
                }
                if (block.isAir((IBlockAccess)this.field_145850_b, xi, yi, zi) || block == Blocks.field_150350_a) {
                    airx = xi;
                    airy = yi;
                    airz = zi;
                }
                xi1 = xi;
                yi1 = yi;
                zi1 = zi;
            }
        }
    }

    @Override
    protected void updateLightState() {
        if (this.getActive()) {
            this.setLightOn();
        } else {
            this.setLightOff();
        }
    }

    private float getVectorPitchAngle(Vec3 vector) {
        double x = vector.field_72450_a;
        double y = vector.field_72448_b;
        double z = vector.field_72449_c;
        switch (this.getFacing()) {
            case 0: {
                return (float)(-(Math.abs(Math.asin(z)) + Math.abs(Math.asin(x))));
            }
            case 1: {
                return (float)(Math.abs(Math.asin(z)) + Math.abs(Math.asin(x)));
            }
            case 2: {
                return (float)(Math.abs(Math.asin(y)) + Math.abs(Math.asin(x)));
            }
            case 3: {
                return (float)(Math.abs(Math.asin(y)) + Math.abs(Math.asin(x)));
            }
            case 4: {
                return (float)(Math.abs(Math.asin(y)) + Math.abs(Math.asin(z)));
            }
            case 5: {
                return (float)(Math.abs(Math.asin(y)) + Math.abs(Math.asin(z)));
            }
        }
        return (float)(-Math.asin(y));
    }

    private float getVectorYawAngle(Vec3 vector) {
        double x = vector.field_72450_a;
        double y = vector.field_72448_b;
        double z = vector.field_72449_c;
        switch (this.getFacing()) {
            case 0: {
                if (z >= 0.0) {
                    return (float)(Math.acos(x / Math.sqrt(x * x + z * z)) - 1.5707963267948966);
                }
                return (float)(-Math.acos(x / Math.sqrt(x * x + z * z)) - 1.5707963267948966);
            }
            case 1: {
                if (z >= 0.0) {
                    return (float)(Math.acos(x / Math.sqrt(x * x + z * z)) - 1.5707963267948966);
                }
                return (float)(-Math.acos(x / Math.sqrt(x * x + z * z)) - 1.5707963267948966);
            }
            case 2: {
                if (y >= 0.0) {
                    return (float)(-Math.acos(x / Math.sqrt(x * x + y * y)) - 1.5707963267948966);
                }
                return (float)(Math.acos(x / Math.sqrt(x * x + y * y)) - 1.5707963267948966);
            }
            case 3: {
                if (y >= 0.0) {
                    return (float)(-Math.acos(x / Math.sqrt(x * x + y * y)) - 1.5707963267948966);
                }
                return (float)(Math.acos(x / Math.sqrt(x * x + y * y)) - 1.5707963267948966);
            }
            case 4: {
                if (y >= 0.0) {
                    return (float)(-Math.acos(z / Math.sqrt(z * z + y * y)) - 1.5707963267948966);
                }
                return (float)(Math.acos(z / Math.sqrt(z * z + y * y)) - 1.5707963267948966);
            }
            case 5: {
                if (y >= 0.0) {
                    return (float)(-Math.acos(z / Math.sqrt(z * z + y * y)) - 1.5707963267948966);
                }
                return (float)(Math.acos(z / Math.sqrt(z * z + y * y)) - 1.5707963267948966);
            }
        }
        return 0.0f;
    }

    public void onNetworkEvent(int event) {
        this.field_145850_b.func_72980_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "ihl:spotlightRotating", 10.0f, 1.0f, true);
    }
}

