/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.metallurgy;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.network.NetworkManager;
import ihl.IHLMod;
import ihl.flexible_cable.IEnergyNetNode;
import ihl.flexible_cable.IHLCable;
import ihl.flexible_cable.IHLCableSet;
import ihl.flexible_cable.IHLGrid;
import ihl.flexible_cable.NodeEntity;
import ihl.processing.metallurgy.ElectricEngineInvSlot;
import ihl.utils.IHLUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BasicElectricMotorTileEntity
extends TileEntityInventory
implements IHasGui,
INetworkClientTileEntityEventListener,
IEnergyNetNode,
IEnergySink {
    public final ElectricEngineInvSlot engine;
    public short progress;
    protected short operationLength = (short)600;
    public boolean isGuiScreenOpened = false;
    private double connectionX;
    private double connectionY;
    private double connectionZ;
    private int gridID = -1;
    private IHLCableSet cableList = new IHLCableSet();
    private int countdownTimer = 200;
    private boolean startCableBurning = false;
    private IHLCable cableToBurn;
    protected final double energyConsume = 0.1;
    public double energy;
    public int maxStorage = 128;
    private boolean addedToEnergyNet = false;

    public BasicElectricMotorTileEntity() {
        this.engine = new ElectricEngineInvSlot(this, "engine", 0, InvSlot.Access.IO, 1, 1);
    }

    public String func_145825_b() {
        return "Lathe";
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public void setFacing(short facing1) {
        short facing2 = (short)Math.max(facing1, 2);
        double d = 0.3;
        double f = -0.1;
        double range = 0.1;
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)(this.getConnectionX() - range), (double)(this.getConnectionY() - range), (double)(this.getConnectionZ() - range), (double)(this.getConnectionX() + range), (double)(this.getConnectionY() + range), (double)(this.getConnectionZ() + range));
        List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
        super.setFacing(facing2);
        switch (this.getFacing()) {
            case 4: {
                this.setConnectionX((double)this.field_145851_c + 0.5);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + 1.0 - f);
                break;
            }
            case 5: {
                this.setConnectionX((double)this.field_145851_c + 0.5);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + f);
                break;
            }
            case 2: {
                this.setConnectionX((double)this.field_145851_c + 1.0 - f);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + 0.5);
                break;
            }
            case 3: {
                this.setConnectionX((double)this.field_145851_c + f);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + 0.5);
                break;
            }
            default: {
                this.setConnectionX((double)this.field_145851_c + 1.0 - f);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + 0.5);
            }
        }
        if (!nodeList.isEmpty()) {
            for (NodeEntity ne : nodeList) {
                if (!ne.isFixed || !this.cableListContains(ne.getChainUniqueID())) continue;
                ne.func_70107_b(this.getConnectionX(), this.getConnectionY(), this.getConnectionZ());
            }
        }
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    public double getDemandedEnergy() {
        if (this.gridID == -1) {
            return (double)this.maxStorage - this.energy;
        }
        return this.getGrid().getDemandedEnergy();
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy < (double)this.maxStorage) {
            this.energy += amount;
            return 0.0;
        }
        if (this.gridID != -1 && this.getGrid().energy <= 0.0) {
            this.getGrid().injectEnergy(amount, 400.0, this);
            return 0.0;
        }
        return amount;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.cableList.saveToNBT(nbt);
        nbt.func_74780_a("connectionX", this.getConnectionX());
        nbt.func_74780_a("connectionY", this.getConnectionY());
        nbt.func_74780_a("connectionZ", this.getConnectionZ());
        nbt.func_74768_a("gridID", this.gridID);
        nbt.func_74777_a("progress", this.progress);
        nbt.func_74780_a("energy", this.energy);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cableList.loadFromNBT(nbt);
        this.setConnectionX(nbt.func_74769_h("connectionX"));
        this.setConnectionY(nbt.func_74769_h("connectionY"));
        this.setConnectionZ(nbt.func_74769_h("connectionZ"));
        this.gridID = nbt.func_74762_e("gridID");
        this.progress = nbt.func_74765_d("progress");
        this.energy = nbt.func_74769_h("energy");
    }

    @Override
    public void removeAttachedChains() {
        if (!this.getCableList().isEmpty()) {
            double range = 128.0;
            AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
            List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
            if (!nodeList.isEmpty()) {
                for (NodeEntity ne : nodeList) {
                    if (!this.cableListContains(ne.getChainUniqueID())) continue;
                    ne.func_70106_y();
                }
            }
            for (IHLCable c : this.getCableList()) {
                ItemStack is = IHLUtils.getThisModItemStack(c.itemName);
                is.field_77990_d = new NBTTagCompound();
                is.field_77990_d.func_74757_a("firstConnection", false);
                is.field_77990_d.func_74768_a("length", c.length);
                is.field_77990_d.func_74768_a("fullLength", c.length);
                EntityItem eitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, is);
                this.field_145850_b.func_72838_d((Entity)eitem);
            }
            if (this.gridID != -1) {
                IHLMod.enet.splitGrids(this.gridID, this);
            }
            this.getCableList().clear();
        }
    }

    private boolean cableListContains(int chainUniqueID) {
        for (IHLCable c : this.getCableList()) {
            if (c.cableID != chainUniqueID) continue;
            return true;
        }
        return false;
    }

    public void onNetworkEvent(EntityPlayer player, int event) {
        switch (event) {
            case 0: {
                this.isGuiScreenOpened = false;
            }
        }
    }

    public abstract void operate();

    public void func_145845_h() {
        if (IC2.platform.isSimulating()) {
            super.func_145845_h();
            if (this.gridID != -1 && this.getGrid().energy > 0.0 && this.energy < (double)this.maxStorage) {
                this.energy += 1.0;
                this.getGrid().drawEnergy(1.0, this);
            }
            if (this.startCableBurning) {
                --this.countdownTimer;
                if (this.countdownTimer <= 0) {
                    double range = (double)this.cableToBurn.length * 2.0 + 32.0;
                    AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
                    List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
                    if (!nodeList.isEmpty()) {
                        for (NodeEntity ne : nodeList) {
                            if (ne.getChainUniqueID() != this.cableToBurn.cableID) continue;
                            ne.func_70106_y();
                        }
                    }
                    IHLMod.enet.removeCableAndSplitGrids(this.gridID, this.cableToBurn);
                    this.startCableBurning = false;
                    this.countdownTimer = 200;
                }
            }
            if (this.canOperate() && this.engine.correctContent() && this.isGuiScreenOpened && this.energy >= this.energyConsume / (double)this.engine.getEfficiency()) {
                this.energy -= this.energyConsume / (double)this.engine.getEfficiency();
                if (this.progress == 0) {
                    ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 0, true);
                }
                this.progress = (short)(this.progress + 1);
                if (this.progress >= this.operationLength) {
                    this.operate();
                    this.progress = 0;
                    ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 2, true);
                }
            } else {
                if (this.progress != 0 && this.getActive()) {
                    ((NetworkManager)IC2.network.get()).initiateTileEntityEvent((TileEntity)this, 1, true);
                }
                if (!this.canOperate()) {
                    this.progress = 0;
                }
            }
        }
    }

    public abstract List[] getInput();

    public abstract boolean canOperate();

    public void onGuiClosed(EntityPlayer arg0) {
    }

    @Override
    public void initiateCableBurnout(IHLCable cable) {
        this.cableToBurn = cable;
        double range = (double)cable.length * 2.0 + 32.0;
        AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
        List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
        if (!nodeList.isEmpty()) {
            for (NodeEntity ne : nodeList) {
                if (ne.getChainUniqueID() != cable.cableID) continue;
                ne.func_70015_d(10);
            }
        }
        this.startCableBurning = true;
    }

    @Override
    public double getConnectionX() {
        return this.connectionX;
    }

    public void setConnectionX(double connectionX) {
        this.connectionX = connectionX;
    }

    @Override
    public double getConnectionY() {
        return this.connectionY;
    }

    public void setConnectionY(double connectionY) {
        this.connectionY = connectionY;
    }

    @Override
    public double getConnectionZ() {
        return this.connectionZ;
    }

    public void setConnectionZ(double connectionZ) {
        this.connectionZ = connectionZ;
    }

    @Override
    public boolean addCable(IHLCable cable) {
        return this.cableList.add(cable);
    }

    @Override
    public IHLCableSet getCableList() {
        return this.cableList;
    }

    @Override
    public void setGrid(int newGridID) {
        if (newGridID != -1) {
            this.gridID = newGridID;
            IHLMod.enet.getGrid((int)newGridID).telist.add(this);
            IHLMod.enet.getGrid((int)newGridID).isGridValid = true;
        } else {
            this.gridID = -1;
        }
    }

    @Override
    public int getGridID() {
        return this.gridID;
    }

    @Override
    public IHLGrid getGrid() {
        return IHLMod.enet.getGrid(this.gridID);
    }

    public int getEnergy() {
        return (int)this.energy;
    }

    public int getGUIEnergy(int i) {
        if (this.energy < 3.4028234663852886E38) {
            return Math.round((float)this.energy / (float)this.maxStorage * (float)i);
        }
        return Math.round((float)(this.energy / (double)this.maxStorage) * (float)i);
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / this.operationLength;
    }

    public void setEnergy(int value) {
        this.energy = value;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getMaxAllowableVoltage() {
        return 64000.0;
    }
}

