/*
 * Decompiled with CFR 0.152.
 */
package ihl.utils;

import ic2.core.util.DrawUtil;
import ihl.utils.IHLFluidTank;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class IHLRenderUtils {
    private static FloatBuffer colorBuffer = GLAllocation.func_74529_h((int)16);
    private static Map<Long, Integer> frameTooltipMap = new HashMap<Long, Integer>();
    private static int displayScaledWidth = -1;
    private static int displayScaledHeight = -1;
    private static int guiXPos = -1;
    private static int guiYPos = -1;
    private static int prevDisplayWidth = -1;
    private static int prevDisplayHeight = -1;
    private static final int guiContainerWidth = 166;
    private static final int guiContainerHeight = 176;

    public static void renderIHLFluidTank(IHLFluidTank fluidTank, int x1, int y1, int x2, int y2, float zLevel, int par1, int par2, int xOffset, int yOffset) {
        int liquidHeight = 0;
        int prevLiquidHeight = 0;
        int i = y2 - y1;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i2 = 0; i2 < fluidTank.getNumberOfFluids(); ++i2) {
            IIcon fluidIcon;
            Fluid fluid;
            FluidStack fluidStack = fluidTank.getFluid(i2);
            if (fluidStack == null || (fluid = fluidStack.getFluid()) == null || (fluidIcon = fluid.getIcon()) == null) continue;
            liquidHeight = fluidTank.getFluidAmount(i2) * i / fluidTank.getCapacity();
            DrawUtil.drawRepeated((IIcon)fluidIcon, (double)x1, (double)(y2 - liquidHeight - prevLiquidHeight), (double)(x2 - x1), (double)liquidHeight, (double)zLevel);
            prevLiquidHeight += liquidHeight;
        }
        IHLRenderUtils.drawIHLFluidTankTooltip(par1, par2, x1 + guiXPos - 6, y1 + guiYPos + 6, x2 + guiXPos - 6, y2 + guiYPos + 6, fluidTank);
    }

    public static void drawMissingEngineTooltip(GuiContainer gui, int par1, int par2, int xPos, int yPos, int xOffset, int yOffset) {
        gui.func_73729_b(xPos, yPos, 194, 0, 3, 14);
        IHLRenderUtils.drawTooltip(par1, par2, 3, 14, xPos + xOffset, yPos + yOffset, "ihl.gui.missing.engine");
    }

    public static void drawWorkspaceElementTooltip(int par1, int par2, int xPos, int yPos, ItemStack workSpaceElement) {
        IHLRenderUtils.drawTooltip(par1, par2, 16, 16, xPos, yPos, workSpaceElement.func_77977_a() + ".tooltip");
    }

    public static void drawIHLFluidTankTooltip(int par1, int par2, int x1, int y1, int x2, int y2, IHLFluidTank fluidTank) {
        String fluidListNames = "";
        List<FluidStack> fli = fluidTank.getFluidList();
        for (int i = fli.size() - 1; i >= 0; --i) {
            FluidStack fluidStack = fli.get(i);
            fluidListNames = fluidListNames + StatCollector.func_74838_a((String)fluidStack.getUnlocalizedName()) + ": " + fluidStack.amount + "mB /n ";
        }
        IHLRenderUtils.drawTooltip(par1, par2, x2 - x1, y2 - y1, x1, y1, fluidListNames);
    }

    public static boolean drawTooltip(int cursorPosX, int cursorPosY, int width, int height, int xPos, int yPos, String text) {
        if (prevDisplayHeight != Minecraft.func_71410_x().field_71440_d || prevDisplayWidth != Minecraft.func_71410_x().field_71443_c) {
            ScaledResolution var2 = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
            displayScaledWidth = var2.func_78326_a();
            displayScaledHeight = var2.func_78328_b();
            guiXPos = (displayScaledWidth - 166) / 2;
            guiYPos = (displayScaledHeight - 176) / 2;
            prevDisplayWidth = Minecraft.func_71410_x().field_71443_c;
            prevDisplayHeight = Minecraft.func_71410_x().field_71440_d;
        }
        long key = xPos + yPos * 1024;
        Integer frame = 0;
        if (frameTooltipMap.containsKey(key)) {
            frame = frameTooltipMap.get(key);
        }
        boolean showString = true;
        if (cursorPosX < xPos || cursorPosX > xPos + width || cursorPosY < yPos || cursorPosY > yPos + height) {
            if (frame > 0) {
                frame = frame - 20;
                frameTooltipMap.put(key, frame);
            }
            showString = false;
        } else {
            frame = frame + 10;
            frameTooltipMap.put(key, frame);
        }
        if (frame > 0) {
            int i;
            int strokeHeight = 15;
            int tooltipHeight = 0;
            int tooltipWidth = 0;
            String[] splittedText = StatCollector.func_74838_a((String)text).split(" /n ");
            for (i = 0; i < splittedText.length; ++i) {
                if (Minecraft.func_71410_x().field_71466_p.func_78256_a(splittedText[i]) + 8 <= tooltipWidth) continue;
                tooltipWidth = Math.min(frame, Minecraft.func_71410_x().field_71466_p.func_78256_a(splittedText[i]) + 8);
            }
            tooltipHeight = Math.min(Math.max(frame - tooltipWidth, strokeHeight), strokeHeight * splittedText.length);
            int x1 = cursorPosX - xPos;
            int x2 = x1 + tooltipWidth;
            int y1 = cursorPosY - guiYPos + 18;
            int y2 = y1 + tooltipHeight;
            GL11.glPushAttrib((int)16704);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (showString) {
                IHLRenderUtils.drawRectangle(Tessellator.field_78398_a, x1, y1, x2, y2, 128);
                GL11.glEnable((int)3553);
                for (i = 0; i < splittedText.length; ++i) {
                    if (i >= tooltipHeight / strokeHeight) continue;
                    Minecraft.func_71410_x().field_71466_p.func_78261_a(splittedText[i].substring(0, Math.min(splittedText[i].length(), tooltipWidth / 5)), x1 + 4, y1 + i * strokeHeight + 4, 16768125);
                }
            } else {
                IHLRenderUtils.drawRectangle(Tessellator.field_78398_a, x1, y1, x2, y2, Math.min(128, frame / 2));
                GL11.glEnable((int)3553);
            }
            GL11.glPopAttrib();
            frame = Math.min(tooltipWidth + tooltipHeight, frame);
            frameTooltipMap.put(key, frame);
            return true;
        }
        return false;
    }

    public static void enableAmbientLighting() {
        GL11.glDisable((int)16384);
        GL11.glDisable((int)16385);
        GL11.glLightModel((int)2899, (FloatBuffer)IHLRenderUtils.setColorBuffer(1.0f, 1.0f, 1.0f, 1.0f));
    }

    public static void disableAmbientLighting() {
        GL11.glEnable((int)16384);
        GL11.glEnable((int)16385);
        GL11.glLightModel((int)2899, (FloatBuffer)IHLRenderUtils.setColorBuffer(0.0f, 0.0f, 0.0f, 1.0f));
    }

    private static FloatBuffer setColorBuffer(float par0, float par1, float par2, float par3) {
        colorBuffer.clear();
        colorBuffer.put(par0).put(par1).put(par2).put(par3);
        colorBuffer.flip();
        return colorBuffer;
    }

    private static void drawRectangle(Tessellator tessellator, int x1, int y1, int x2, int y2, int color) {
        tessellator.func_78382_b();
        tessellator.func_78370_a(color >>> 24 & 0xFF, color >>> 16 & 0xFF, color >>> 8 & 0xFF, color & 0xFF);
        tessellator.func_78377_a((double)x2, (double)y1, 300.0);
        tessellator.func_78377_a((double)x1, (double)y1, 300.0);
        tessellator.func_78377_a((double)x1, (double)y2, 300.0);
        tessellator.func_78377_a((double)x2, (double)y2, 300.0);
        tessellator.func_78381_a();
    }
}

