/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import ihl.IHLMod;
import ihl.flexible_cable.IEnergyNetNode;
import ihl.flexible_cable.IHLCable;
import ihl.flexible_cable.IHLCableSet;
import ihl.flexible_cable.IHLGrid;
import ihl.flexible_cable.NodeEntity;
import ihl.utils.IHLUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class AnchorTileEntity
extends TileEntityBlock
implements IEnergySink,
IEnergySource,
IEnergyNetNode {
    private boolean addedToEnergyNet = false;
    private double connectionX;
    private double connectionY;
    private double connectionZ;
    private int gridID = -1;
    private IHLCableSet cableList;
    private int countdownTimer = 200;
    private boolean startCableBurning = false;
    private IHLCable cableToBurn;
    private final Set<TileEntity> sacrifices = new HashSet<TileEntity>();

    public AnchorTileEntity() {
        this.cableList = new IHLCableSet();
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
        if (this.gridID != -1) {
            IHLGrid grid = IHLMod.enet.getGrid(this.gridID);
            grid.telist.add(this);
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
    }

    public boolean wrenchCanRemove(EntityPlayer var1) {
        return this.getCableList().isEmpty();
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_145845_h() {
        if (!this.sacrifices.isEmpty()) {
            for (TileEntity sacrifice : this.sacrifices) {
                ExplosionIC2 explosion = new ExplosionIC2(this.field_145850_b, null, (double)sacrifice.field_145851_c + 0.5, (double)sacrifice.field_145848_d + 0.5, (double)sacrifice.field_145849_e + 0.5, 3.0f, 0.3f, ExplosionIC2.Type.Normal, null, 0);
                explosion.doExplosion();
                this.sacrifices.remove(sacrifice);
            }
        }
        if (this.startCableBurning) {
            --this.countdownTimer;
            if (this.countdownTimer <= 0) {
                double range = (double)this.cableToBurn.length * 2.0 + 32.0;
                AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
                List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
                if (!nodeList.isEmpty()) {
                    for (NodeEntity ne : nodeList) {
                        if (ne.getChainUniqueID() != this.cableToBurn.cableID) continue;
                        ne.func_70106_y();
                    }
                }
                IHLMod.enet.removeCableAndSplitGrids(this.gridID, this.cableToBurn);
                this.startCableBurning = false;
                this.countdownTimer = 200;
            }
        }
    }

    @Override
    public void removeAttachedChains() {
        if (!this.getCableList().isEmpty()) {
            double range = 128.0;
            AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
            List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
            if (!nodeList.isEmpty()) {
                for (NodeEntity ne : nodeList) {
                    if (!this.cableListContains(ne.getChainUniqueID())) continue;
                    ne.func_70106_y();
                }
            }
            for (IHLCable c : this.getCableList()) {
                ItemStack is = IHLUtils.getThisModItemStack(c.itemName);
                is.field_77990_d = new NBTTagCompound();
                is.field_77990_d.func_74757_a("firstConnection", false);
                is.field_77990_d.func_74768_a("length", c.length);
                is.field_77990_d.func_74768_a("fullLength", c.length);
                EntityItem eitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, is);
                this.field_145850_b.func_72838_d((Entity)eitem);
            }
            if (this.gridID != -1) {
                IHLMod.enet.splitGrids(this.gridID, this);
            }
            this.getCableList().clear();
        }
    }

    private boolean cableListContains(int chainUniqueID) {
        for (IHLCable c : this.getCableList()) {
            if (c.cableID != chainUniqueID) continue;
            return true;
        }
        return false;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.cableList.saveToNBT(nbt);
        nbt.func_74780_a("connectionX", this.getConnectionX());
        nbt.func_74780_a("connectionY", this.getConnectionY());
        nbt.func_74780_a("connectionZ", this.getConnectionZ());
        nbt.func_74768_a("gridID", this.gridID);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cableList.loadFromNBT(nbt);
        this.setConnectionX(nbt.func_74769_h("connectionX"));
        this.setConnectionY(nbt.func_74769_h("connectionY"));
        this.setConnectionZ(nbt.func_74769_h("connectionZ"));
        this.gridID = nbt.func_74762_e("gridID");
    }

    public void setFacing(short facing) {
        double d = 0.3;
        double f = 0.1;
        super.setFacing(facing);
        switch (facing) {
            case 0: {
                this.setConnectionX((double)this.field_145851_c + d);
                this.setConnectionY((double)this.field_145848_d + 1.0 - f);
                this.setConnectionZ((double)this.field_145849_e + 0.5);
                break;
            }
            case 1: {
                this.setConnectionX((double)this.field_145851_c + d);
                this.setConnectionY((double)this.field_145848_d + f);
                this.setConnectionZ((double)this.field_145849_e + 0.5);
                break;
            }
            case 2: {
                this.setConnectionX((double)this.field_145851_c + 0.5);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + 1.0 - f);
                break;
            }
            case 3: {
                this.setConnectionX((double)this.field_145851_c + 0.5);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + f);
                break;
            }
            case 4: {
                this.setConnectionX((double)this.field_145851_c + 1.0 - f);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + 0.5);
                break;
            }
            case 5: {
                this.setConnectionX((double)this.field_145851_c + f);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + 0.5);
                break;
            }
            default: {
                this.setConnectionX((double)this.field_145851_c + f);
                this.setConnectionY((double)this.field_145848_d + d);
                this.setConnectionZ((double)this.field_145849_e + 0.5);
            }
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        switch (direction) {
            case UP: {
                return this.getFacing() == 0;
            }
            case DOWN: {
                return this.getFacing() == 1;
            }
            case SOUTH: {
                return this.getFacing() == 2;
            }
            case NORTH: {
                return this.getFacing() == 3;
            }
            case EAST: {
                return this.getFacing() == 4;
            }
            case WEST: {
                return this.getFacing() == 5;
            }
        }
        return false;
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.acceptsEnergyFrom(receiver, direction);
    }

    public double getOfferedEnergy() {
        if (this.gridID == -1) {
            return 0.0;
        }
        return Math.max(this.getGrid().energy, 0.0);
    }

    public void drawEnergy(double amount) {
        if (this.gridID != -1) {
            this.getGrid().drawEnergy(amount, this);
            double voltage = this.getGrid().getSinkVoltage(this);
            System.out.println(voltage);
            if (voltage > 500.0) {
                HashSet<TileEntity> teset = new HashSet<TileEntity>();
                ForgeDirection direction = ForgeDirection.getOrientation((int)this.getFacing()).getOpposite();
                TileEntity te = EnergyNet.instance.getNeighbor((TileEntity)this, direction);
                teset.add(te);
                TileEntity te1 = this.getSink(te, teset);
                if (te1 instanceof IEnergyNetNode && ((IEnergyNetNode)te1).getMaxAllowableVoltage() >= voltage) {
                    return;
                }
                if (te1 != null) {
                    this.sacrifices.add(te1);
                }
            }
        }
    }

    public int getSourceTier() {
        return EnergyNet.instance.getTierFromPower(this.getGrid().getDemandedEnergy());
    }

    public double getDemandedEnergy() {
        if (this.gridID == -1) {
            return 0.0;
        }
        return this.getGrid().getDemandedEnergy();
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.gridID == -1 || this.getGrid().energy > 0.0) {
            return amount;
        }
        this.getGrid().injectEnergy(amount, 400.0, this);
        return 0.0;
    }

    @Override
    public void setGrid(int newGridID) {
        if (newGridID != -1) {
            this.gridID = newGridID;
            IHLMod.enet.getGrid((int)newGridID).telist.add(this);
            IHLMod.enet.getGrid((int)newGridID).isGridValid = true;
        } else {
            this.gridID = -1;
        }
    }

    @Override
    public int getGridID() {
        return this.gridID;
    }

    @Override
    public IHLGrid getGrid() {
        return IHLMod.enet.getGrid(this.gridID);
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(IHLMod.cableAnchorBlock, 1);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public void initiateCableBurnout(IHLCable cable) {
        this.cableToBurn = cable;
        double range = (double)cable.length * 2.0 + 32.0;
        AxisAlignedBB searchArea = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - range), (double)((double)this.field_145848_d - range), (double)((double)this.field_145849_e - range), (double)((double)this.field_145851_c + range), (double)((double)this.field_145848_d + range), (double)((double)this.field_145849_e + range));
        List nodeList = this.field_145850_b.func_72872_a(NodeEntity.class, searchArea);
        if (!nodeList.isEmpty()) {
            for (NodeEntity ne : nodeList) {
                if (ne.getChainUniqueID() != cable.cableID) continue;
                ne.func_70015_d(10);
            }
        }
        this.startCableBurning = true;
    }

    @Override
    public double getConnectionX() {
        return this.connectionX;
    }

    public void setConnectionX(double connectionX) {
        this.connectionX = connectionX;
    }

    @Override
    public double getConnectionY() {
        return this.connectionY;
    }

    public void setConnectionY(double connectionY) {
        this.connectionY = connectionY;
    }

    @Override
    public double getConnectionZ() {
        return this.connectionZ;
    }

    public void setConnectionZ(double connectionZ) {
        this.connectionZ = connectionZ;
    }

    @Override
    public boolean addCable(IHLCable cable) {
        return this.cableList.add(cable);
    }

    @Override
    public IHLCableSet getCableList() {
        return this.cableList;
    }

    private TileEntity getSink(TileEntity te, Set<TileEntity> teset) {
        teset.add(te);
        while (te != null && !(te instanceof IEnergySink)) {
            TileEntity te2;
            TileEntity te1 = EnergyNet.instance.getNeighbor(te, ForgeDirection.NORTH);
            if (te1 == null || teset.contains(te1)) {
                te1 = EnergyNet.instance.getNeighbor(te, ForgeDirection.SOUTH);
            } else {
                te2 = this.getSink(te1, teset);
                if (te2 != null) {
                    return te2;
                }
            }
            if (te1 == null || teset.contains(te1)) {
                te1 = EnergyNet.instance.getNeighbor(te, ForgeDirection.UP);
            } else {
                te2 = this.getSink(te1, teset);
                if (te2 != null) {
                    return te2;
                }
            }
            if (te1 == null || teset.contains(te1)) {
                te1 = EnergyNet.instance.getNeighbor(te, ForgeDirection.DOWN);
            } else {
                te2 = this.getSink(te1, teset);
                if (te2 != null) {
                    return te2;
                }
            }
            if (te1 == null || teset.contains(te1)) {
                te1 = EnergyNet.instance.getNeighbor(te, ForgeDirection.WEST);
            } else {
                te2 = this.getSink(te1, teset);
                if (te2 != null) {
                    return te2;
                }
            }
            if (te1 == null || teset.contains(te1)) {
                te1 = EnergyNet.instance.getNeighbor(te, ForgeDirection.EAST);
            } else {
                te2 = this.getSink(te1, teset);
                if (te2 != null) {
                    return te2;
                }
            }
            if (te1 != null) {
                teset.add(te1);
            }
            te = te1;
        }
        if (te instanceof IEnergySink) {
            return te;
        }
        return null;
    }

    @Override
    public double getMaxAllowableVoltage() {
        return 64000.0;
    }
}

