/*
 * Decompiled with CFR 0.152.
 */
package ihl.flexible_cable;

import ihl.IHLMod;
import ihl.flexible_cable.IEnergyNetNode;
import ihl.flexible_cable.IHLCable;
import ihl.flexible_cable.IHLCableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.MinecraftServer;

public class IHLGrid {
    private static final double powerLossLimitPerMeter = 1.6;
    public final Set<IEnergyNetNode> telist = new HashSet<IEnergyNetNode>();
    public double energy = 0.0;
    private IEnergyNetNode sink;
    private IEnergyNetNode source;
    private double voltage;
    private short frequency = 0;
    private double lastVoltage;
    public boolean isGridValid = true;
    private double total20TicksEU;
    private int lastTickCounter = 0;
    public final List<IEnergyNetNode> calculatedSinks = new ArrayList<IEnergyNetNode>();
    public final List<IEnergyNetNode> calculatedSources = new ArrayList<IEnergyNetNode>();
    private final Map<IEnergyNetNode, Double> energyLossSinkMap = new HashMap<IEnergyNetNode, Double>();
    private final Map<IEnergyNetNode, Double> voltageSinkMap = new HashMap<IEnergyNetNode, Double>();
    private double averageEUTransfered;
    private double lastAverageEUTransfered = 0.0;

    public double getDemandedEnergy() {
        if (this.energy <= 0.0) {
            return 8192.0;
        }
        return 0.0;
    }

    public void drawEnergy(double amount, IEnergyNetNode sink1) {
        if (this.energyLossSinkMap.get(sink1) != null) {
            this.energy -= amount + this.energyLossSinkMap.get(sink1) * amount * amount;
        } else {
            this.energy -= amount;
            this.telist.add(sink1);
        }
        this.sink = sink1;
    }

    public void injectEnergy(double amount, double voltage1, IEnergyNetNode source1) {
        int d;
        this.energy += amount;
        this.voltage = voltage1;
        this.source = source1;
        this.total20TicksEU += amount;
        int tickCounter = MinecraftServer.func_71276_C().func_71259_af();
        if (tickCounter - this.lastTickCounter < 0) {
            this.lastTickCounter = tickCounter;
            this.total20TicksEU = 0.0;
        }
        if ((d = tickCounter - this.lastTickCounter) >= 200) {
            this.averageEUTransfered = this.total20TicksEU / (double)d;
            this.lastTickCounter = tickCounter;
            this.total20TicksEU = 0.0;
            if (IHLMod.config.enableFlexibleCablesGridPowerLossCalculations && this.isGridValid && this.averageEUTransfered > 1.0) {
                this.telist.add(source1);
                this.updateGrid();
            }
        }
    }

    private void updateGrid() {
        if (!(this.source == null || this.sink == null || this.source == this.sink || this.sink.getCableList().isEmpty() || this.source.getCableList().isEmpty() || this.calculatedSources.contains(this.source) && this.calculatedSinks.contains(this.sink) && !(this.averageEUTransfered > this.lastAverageEUTransfered) && this.voltage == this.lastVoltage)) {
            HashMap<IEnergyNetNode, IHLCable> map = new HashMap<IEnergyNetNode, IHLCable>();
            HashSet<IEnergyNetNode> templist = new HashSet<IEnergyNetNode>();
            HashSet<IEnergyNetNode> processlist = new HashSet<IEnergyNetNode>();
            HashSet<IEnergyNetNode> templist2 = new HashSet<IEnergyNetNode>();
            templist.addAll(this.telist);
            processlist.add(this.sink);
            int threads = 0;
            block0: while (!templist.isEmpty()) {
                if (threads++ > 1000) {
                    System.out.println("Invalidating grid 1");
                    this.isGridValid = false;
                    return;
                }
                templist.removeAll(processlist);
                templist2.clear();
                Iterator it1 = processlist.iterator();
                while (it1.hasNext()) {
                    if (threads++ > 1000) {
                        System.out.println("Invalidating grid 2");
                        this.isGridValid = false;
                        return;
                    }
                    IEnergyNetNode ate1 = (IEnergyNetNode)it1.next();
                    Iterator it2 = templist.iterator();
                    while (it2.hasNext()) {
                        IHLCable cable;
                        if (threads++ > 1000) {
                            System.out.println("Invalidating grid 3");
                            this.isGridValid = false;
                            return;
                        }
                        IEnergyNetNode ate2 = (IEnergyNetNode)it2.next();
                        if (ate1 == ate2 || (cable = this.getSame(ate1.getCableList(), ate2.getCableList())) == null) continue;
                        map.put(ate2, cable);
                        templist2.add(ate2);
                        if (ate2 != this.source) continue;
                        break block0;
                    }
                    templist.removeAll(templist2);
                }
                processlist.clear();
                processlist.addAll(templist2);
            }
            IEnergyNetNode cursor = this.source;
            double voltage1 = this.voltage;
            double euTransfered = this.averageEUTransfered;
            double voltageLossPerMeter = 0.0;
            double powerLossPerMeter = 0.0;
            double powerLossPerSquaredEU = 0.0;
            this.energyLossSinkMap.remove(this.sink);
            this.voltageSinkMap.remove(this.sink);
            while (cursor != this.sink) {
                IHLCable cable = (IHLCable)map.get(cursor);
                voltageLossPerMeter = (double)cable.resistivity / 1000.0 * euTransfered / voltage1;
                powerLossPerMeter = voltageLossPerMeter * euTransfered / voltage1;
                euTransfered -= powerLossPerMeter * (double)cable.length;
                powerLossPerSquaredEU += (double)cable.resistivity / 1000.0 * (double)cable.length / (voltage1 -= voltageLossPerMeter * (double)cable.length) / voltage1;
                if (powerLossPerMeter > 1.6 || voltage1 > (double)cable.voltageLimit) {
                    cursor.initiateCableBurnout(cable);
                }
                cursor = this.getHasCable(cable, cursor);
            }
            this.energyLossSinkMap.put(this.sink, powerLossPerSquaredEU);
            this.voltageSinkMap.put(this.sink, voltage1);
            this.calculatedSources.add(this.source);
            this.calculatedSinks.add(this.sink);
            this.lastAverageEUTransfered = this.averageEUTransfered;
            this.lastVoltage = this.voltage;
        }
    }

    private IHLCable getSame(IHLCableSet ihlCableSet, IHLCableSet ihlCableSet2) {
        for (IHLCable cable : ihlCableSet) {
            if (!ihlCableSet2.contains(cable)) continue;
            return cable;
        }
        return null;
    }

    public double getSinkVoltage(IEnergyNetNode node) {
        if (this.voltageSinkMap.containsKey(node)) {
            return this.voltageSinkMap.get(node);
        }
        return this.voltage;
    }

    private IEnergyNetNode getHasCable(IHLCable cable, IEnergyNetNode exclude) {
        for (IEnergyNetNode ate1 : this.telist) {
            if (ate1 == exclude || !ate1.getCableList().contains(cable)) continue;
            return ate1;
        }
        return null;
    }
}

