/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.chemistry;

import ic2.api.energy.tile.IHeatSource;
import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ihl.processing.chemistry.FractionatorCoverTileEntity;
import ihl.processing.chemistry.FractionatorSectionTileEntity;
import ihl.processing.chemistry.RefluxCondenserTileEntity;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLFluidTank;
import ihl.utils.IHLUtils;
import ihl.worldgen.ores.IHLFluid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class FractionatorBottomTileEntity
extends TileEntityInventory {
    private static final UniversalRecipeManager recipeManager = new UniversalRecipeManager();
    private static float kF = 24000.0f;
    private static float gasC = 1.0f;
    private static float fluidC = 4.0f;
    private static float H = 2256.0f;
    private final IHLFluidTank waterTank = new IHLFluidTank(100);
    private final IHLFluidTank fluidTank = new IHLFluidTank(8000);
    private int amountOfGasCondensed = 0;
    private int amountOfFluidEvaporated = 0;
    private int systemHeat = 0;
    private static final int maxSystemHeat = 10000;
    private final List<FractionatorSectionTileEntity> listOfColumnSections = new ArrayList<FractionatorSectionTileEntity>();
    private FractionatorCoverTileEntity columnCover;
    private RefluxCondenserTileEntity refluxCondenser;
    private IHeatSource heatSource;
    private int fluxRecirculationProportion = 10;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
        this.waterTank.readFromNBT(nbttagcompound.func_74775_l("waterTank"));
        this.amountOfGasCondensed = nbttagcompound.func_74762_e("amountOfGasCondensed");
        this.systemHeat = nbttagcompound.func_74762_e("systemHeat");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
        NBTTagCompound waterTankTag = new NBTTagCompound();
        this.waterTank.writeToNBT(waterTankTag);
        nbttagcompound.func_74782_a("waterTank", (NBTBase)waterTankTag);
        nbttagcompound.func_74768_a("amountOfGasCondensed", this.amountOfGasCondensed);
        nbttagcompound.func_74768_a("systemHeat", this.systemHeat);
    }

    public static void addRecipe(FluidStack fluidIn, FluidStack fluidOut1, FluidStack fluidOut2) {
        recipeManager.addRecipe(new UniversalRecipeInput(Arrays.asList(fluidIn), null), new UniversalRecipeOutput(Arrays.asList(fluidOut1, fluidOut2), null, 2));
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side && side != 0 && side != 1;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("fractionatorBottom");
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_145845_h() {
        FluidStack fsCurrentInput;
        super.func_145845_h();
        if (!this.checkIntegrity()) {
            return;
        }
        this.fluxRecirculationProportion = 100 - 10000 / (100 + this.listOfColumnSections.size() * 3);
        ForgeDirection orientation = ForgeDirection.getOrientation((int)this.getFacing()).getRotation(ForgeDirection.UP);
        if (this.systemHeat < 10000 && this.checkHeatSource(orientation)) {
            this.systemHeat += this.heatSource.requestHeat(orientation.getOpposite(), Integer.MAX_VALUE);
        }
        if ((fsCurrentInput = this.fluidTank.getFluid()) != null && fsCurrentInput.amount > 100 && this.systemHeat > 0) {
            UniversalRecipeOutput rOutput = recipeManager.getOutputFor(Arrays.asList(this.fluidTank.getFluid()), null, false, false);
            UniversalRecipeInput rInput = recipeManager.getRecipeInput(Arrays.asList(this.fluidTank.getFluid()), null);
            if (rOutput != null) {
                FluidStack input = rInput.getFluidInputs().get(0).copy();
                int rInputAmount = input.amount;
                FluidStack result1 = rOutput.getFluidOutputs().get(0).copy();
                FluidStack result2 = rOutput.getFluidOutputs().get(1).copy();
                int amountOfFluidToEvaporate = Math.min(fsCurrentInput.amount * result2.amount / rInputAmount, this.systemHeat / 100);
                this.systemHeat -= amountOfFluidToEvaporate * 100;
                this.amountOfFluidEvaporated += amountOfFluidToEvaporate;
                int amountOfVapours = this.amountOfFluidEvaporated * 50;
                FluidStack coolant = this.waterTank.getFluid();
                if (coolant != null && coolant.amount > 0) {
                    int t1 = this.waterTank.getTemperature();
                    float densityOfCoolant = IHLFluid.getRealDensity(coolant.getFluid());
                    float densityOfGas = 17.8f;
                    int boilingPointOfGas = IHLFluid.getBoilingPoint(result2.getFluid());
                    int amountOfGasToCondense = this.getAmountOfCondensedGas(coolant.amount, amountOfVapours, boilingPointOfGas, t1, densityOfGas, densityOfCoolant);
                    this.amountOfGasCondensed += amountOfGasToCondense;
                    this.amountOfFluidEvaporated -= amountOfGasToCondense / 50;
                }
                if (this.amountOfGasCondensed > 10000) {
                    int amountToProcess = this.amountOfGasCondensed * this.fluxRecirculationProportion / 5000;
                    input.amount = rInputAmount * amountToProcess / result2.amount;
                    result1.amount = result1.amount * amountToProcess / result2.amount;
                    result2.amount = amountToProcess;
                    this.fluidTank.drain(input, true);
                    this.fillVatResidueOutputApparatus(orientation.getOpposite(), result1, true);
                    this.fillCondensateOutputApparatus(ForgeDirection.UP, result2, true);
                    this.amountOfGasCondensed = 0;
                }
            }
        }
        if (this.waterTank.getFluid() != null) {
            FluidStack coolant = this.waterTank.drain(5, true);
            this.fillHeatTransferAgentOutputApparatus(ForgeDirection.UP, coolant, true);
        }
    }

    private boolean checkHeatSource(ForgeDirection orientation) {
        if (this.heatSource != null) {
            return true;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + orientation.offsetX, this.field_145848_d, this.field_145849_e + orientation.offsetZ);
        if (te instanceof IHeatSource && ((IHeatSource)te).maxrequestHeatTick(orientation.getOpposite()) > 0) {
            this.heatSource = (IHeatSource)te;
            return true;
        }
        return false;
    }

    private boolean checkIntegrity() {
        boolean allright = true;
        if (!(this.listOfColumnSections.isEmpty() || this.columnCover == null || this.columnCover.func_145837_r() || this.refluxCondenser == null || this.refluxCondenser.func_145837_r())) {
            for (FractionatorSectionTileEntity section : this.listOfColumnSections) {
                if (section != null && !section.func_145837_r()) continue;
                allright = false;
            }
        } else {
            allright = false;
        }
        if (allright) {
            return true;
        }
        this.listOfColumnSections.clear();
        this.columnCover = null;
        this.refluxCondenser = null;
        boolean checking = true;
        int height = 0;
        while (checking) {
            TileEntity te;
            if ((te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + ++height, this.field_145849_e)) instanceof FractionatorSectionTileEntity) {
                FractionatorSectionTileEntity section = (FractionatorSectionTileEntity)te;
                section.columnBottom = this;
                this.listOfColumnSections.add(section);
                continue;
            }
            if (te instanceof FractionatorCoverTileEntity) {
                FractionatorCoverTileEntity fcte;
                if (this.listOfColumnSections.isEmpty()) {
                    return false;
                }
                this.columnCover = fcte = (FractionatorCoverTileEntity)te;
                ForgeDirection orientation = ForgeDirection.getOrientation((int)fcte.getFacing()).getRotation(ForgeDirection.DOWN);
                te = this.field_145850_b.func_147438_o(this.field_145851_c + orientation.offsetX, this.field_145848_d + height, this.field_145849_e + orientation.offsetZ);
                if (!(te instanceof RefluxCondenserTileEntity) || ((RefluxCondenserTileEntity)te).getFacing() != fcte.getFacing()) continue;
                this.refluxCondenser = (RefluxCondenserTileEntity)te;
                this.refluxCondenser.columnBottom = this;
                return true;
            }
            checking = false;
        }
        return false;
    }

    private int getAmountOfCondensedGas(int amountOfCoolant, int amountOfGas, int boilingPointOfGas, int temperatureOfCoolant, float densityOfGas, float densityOfCoolant) {
        float Q2;
        int dt2;
        float deltaT;
        float Q1;
        if (amountOfCoolant <= 0 || amountOfGas <= 0 || boilingPointOfGas - 20 < temperatureOfCoolant) {
            return 0;
        }
        int L = amountOfGas;
        int t2 = boilingPointOfGas;
        int t1 = temperatureOfCoolant;
        int dt1 = t2 - t1;
        float maxQ = H * (float)L * densityOfGas;
        int t1_1 = t1;
        for (int i = 0; i < 10 && !((Q1 = kF * (deltaT = dt1 > 2 * (dt2 = t2 - (t1_1 = t1 + (int)((Q2 = H * (float)L * densityOfGas) / fluidC / (float)amountOfCoolant / densityOfCoolant))) ? (float)((double)(dt1 - dt2) / Math.log((double)dt2 / (double)dt1)) : (float)(dt1 + dt2) * 0.5f)) >= maxQ); ++i) {
            int next_L = (int)(Q1 / H / densityOfGas);
            if (Math.abs(next_L - L) < 4) {
                L = next_L;
                break;
            }
            L = next_L;
        }
        if (t1_1 > t1) {
            this.waterTank.setTemperature(t1_1);
        } else {
            this.waterTank.setTemperature(t1 + 1);
        }
        return L;
    }

    public String func_145825_b() {
        return "fractionator";
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int fill(ForgeDirection direction, FluidStack fluidStack, boolean doFill) {
        if (direction.equals((Object)ForgeDirection.UP)) {
            return this.waterTank.fill(fluidStack, doFill);
        }
        return this.fluidTank.fill(fluidStack, doFill);
    }

    private int fillCondensateOutputApparatus(ForgeDirection direction, FluidStack fluidStack, boolean doFill) {
        TileEntity te = this.field_145850_b.func_147438_o(this.refluxCondenser.field_145851_c, this.refluxCondenser.field_145848_d - 1, this.refluxCondenser.field_145849_e);
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).fill(direction, fluidStack, doFill);
        }
        return 0;
    }

    private int fillVatResidueOutputApparatus(ForgeDirection orientation, FluidStack fluidStack, boolean doFill) {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + orientation.offsetX, this.field_145848_d, this.field_145849_e + orientation.offsetZ);
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).fill(orientation, fluidStack, doFill);
        }
        return 0;
    }

    private int fillHeatTransferAgentOutputApparatus(ForgeDirection direction, FluidStack fluidStack, boolean doFill) {
        ForgeDirection orientation = ForgeDirection.getOrientation((int)this.refluxCondenser.getFacing()).getOpposite();
        TileEntity te = this.field_145850_b.func_147438_o(this.refluxCondenser.field_145851_c + orientation.offsetX, this.refluxCondenser.field_145848_d, this.refluxCondenser.field_145849_e + orientation.offsetZ);
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).fill(orientation, fluidStack, doFill);
        }
        return 0;
    }

    public void setFacing(short facing1) {
        super.setFacing((short)Math.max(facing1, 2));
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection arg0) {
        return new FluidTankInfo[]{this.fluidTank.getInfo(), this.waterTank.getInfo()};
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }
}

