/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.chemistry;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.IRecipeInput;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.TileEntityLiquidTankInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableFuel;
import ihl.processing.chemistry.ApparatusProcessableInvSlot;
import ihl.processing.chemistry.LeadOvenContainer;
import ihl.processing.chemistry.LeadOvenGui;
import ihl.processing.invslots.IHLInvSlotOutput;
import ihl.recipes.RecipeOutputItemStack;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class LeadOvenTileEntity
extends TileEntityLiquidTankInventory
implements IHasGui {
    public final InvSlotConsumableFuel fuelSlot;
    public final ApparatusProcessableInvSlot inputSlot;
    public final IHLInvSlotOutput outputSlot;
    public short progress = 0;
    public final short maxProgress = (short)160;
    public int fuel = 0;
    public int maxFuel = 0;
    protected static final UniversalRecipeManager recipeManager = new UniversalRecipeManager();
    private ItemStack burnedFuel;

    public LeadOvenTileEntity() {
        super(1000);
        this.fuelSlot = new InvSlotConsumableFuel((TileEntityInventory)this, "fuel", 1, 1, true);
        this.inputSlot = new ApparatusProcessableInvSlot((TileEntityInventory)this, "input", 2, InvSlot.Access.IO, 2, 64);
        this.outputSlot = new IHLInvSlotOutput((TileEntityInventory)this, "output", 0, 1);
    }

    public static void addRecipe(UniversalRecipeInput input, UniversalRecipeOutput output) {
        recipeManager.addRecipe(input, output);
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        try {
            this.fuel = nbttagcompound.func_74762_e("fuel");
        }
        catch (Throwable var4) {
            this.fuel = nbttagcompound.func_74765_d("fuel");
        }
        try {
            this.maxFuel = nbttagcompound.func_74762_e("maxFuel");
        }
        catch (Throwable var3) {
            this.maxFuel = nbttagcompound.func_74765_d("maxFuel");
        }
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("fuel", this.fuel);
        nbttagcompound.func_74768_a("maxFuel", this.maxFuel);
        nbttagcompound.func_74777_a("progress", this.progress);
        NBTTagCompound gasBufferTag = new NBTTagCompound();
        nbttagcompound.func_74782_a("gasBuffer", (NBTBase)gasBufferTag);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != (short)side && side != 0 && side != 1;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return IHLUtils.getThisModItemStack("leadOven");
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / 160;
    }

    public int gaugeFuelScaled(int i) {
        if (this.maxFuel == 0) {
            this.maxFuel = this.fuel;
            if (this.maxFuel == 0) {
                this.maxFuel = 160;
            }
        }
        return this.fuel * i / this.maxFuel;
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.getFluidTank().getFluid() != null) {
            FluidStack fs = this.maxProgress > 0 && this.getOutput() != null && this.getOutput().getFluidOutputs() != null && this.getOutput().getFluidOutputs().size() > 0 ? this.getFluidTank().drain(this.getOutput().getFluidOutputs().get((int)0).amount / this.maxProgress, true) : this.getFluidTank().drain(1000, true);
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            if (te != null) {
                ForgeDirection direction = ForgeDirection.DOWN;
                if (te instanceof IFluidHandler) {
                    ((IFluidHandler)te).fill(direction, fs, true);
                }
            }
        }
        boolean needsInvUpdate = false;
        if (this.fuel <= 0 && this.canOperate()) {
            if (this.fuelSlot.get() != null) {
                if (this.burnedFuel != null && IHLUtils.isItemsHaveSameOreDictionaryEntry(this.fuelSlot.get(), this.burnedFuel)) {
                    ++this.burnedFuel.field_77994_a;
                } else if (this.burnedFuel == null) {
                    this.burnedFuel = this.fuelSlot.get().func_77946_l();
                    this.burnedFuel.field_77994_a = 1;
                }
            }
            this.fuel = this.maxFuel = this.fuelSlot.consumeFuel();
            if (this.fuel > 0) {
                needsInvUpdate = true;
            }
        }
        if (this.isBurning() && this.canOperate()) {
            this.progress = (short)(this.progress + 1);
            if (this.progress >= 160) {
                this.progress = 0;
                this.operate();
                needsInvUpdate = true;
            }
        } else {
            this.progress = 0;
        }
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (this.getActive() != this.isBurning()) {
            this.setActive(this.isBurning());
            needsInvUpdate = true;
        }
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public boolean canOperate() {
        return this.getOutput() != null;
    }

    public String func_145825_b() {
        return "goldOven";
    }

    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new LeadOvenContainer(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new LeadOvenGui(new LeadOvenContainer(entityPlayer, this));
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public int mX() {
        switch (this.getFacing()) {
            case 4: {
                return -1;
            }
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    public int mZ() {
        switch (this.getFacing()) {
            case 2: {
                return -1;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public UniversalRecipeOutput getOutput() {
        return recipeManager.getOutputFor(this.getInput(), false, false);
    }

    public List[] getInput() {
        if (this.inputSlot.get(1) != null) {
            return new List[]{null, Arrays.asList(this.inputSlot.get(0), this.inputSlot.get(1))};
        }
        return new List[]{null, Arrays.asList(this.inputSlot.get())};
    }

    public void operate() {
        List<RecipeOutputItemStack> itemOutputs;
        List<IRecipeInput> rinput = recipeManager.getRecipeInput(this.getInput()).getItemInputs();
        UniversalRecipeOutput routput = recipeManager.getOutputFor(this.getInput(), false, false);
        List<FluidStack> output2 = routput.getFluidOutputs();
        if (!output2.isEmpty()) {
            this.getFluidTank().fill(output2.get(0), true);
        }
        if ((itemOutputs = routput.getItemOutputs()) != null && !itemOutputs.isEmpty()) {
            this.outputSlot.add(itemOutputs);
        }
        for (int i = 0; i < rinput.size(); ++i) {
            if (this.burnedFuel != null && IHLUtils.isItemsHaveSameOreDictionaryEntry(this.fuelSlot.get(), this.burnedFuel) && this.burnedFuel.field_77994_a >= rinput.get(i).getAmount()) {
                this.burnedFuel.field_77994_a -= rinput.get(i).getAmount();
                if (this.burnedFuel.field_77994_a <= 0) {
                    this.burnedFuel = null;
                }
            } else {
                this.inputSlot.consume(i, rinput.get(i).getAmount());
            }
            if (this.inputSlot.get(i) == null || this.inputSlot.get((int)i).field_77994_a > 0) continue;
            this.inputSlot.put(i, null);
        }
    }

    public boolean canDrain(ForgeDirection arg0, Fluid arg1) {
        return false;
    }

    public boolean canFill(ForgeDirection arg0, Fluid arg1) {
        return false;
    }

    public static void addRecipe(UniversalRecipeInput input, FluidStack fluidStackWithSize) {
        recipeManager.addRecipe(input, new UniversalRecipeOutput(Arrays.asList(fluidStackWithSize), null, 20));
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }

    public static void addRecipe(ItemStack input, FluidStack fluidStackOutput, ItemStack output) {
        recipeManager.addRecipe(new UniversalRecipeInput(null, Arrays.asList(input)), new UniversalRecipeOutput(Arrays.asList(fluidStackOutput), Arrays.asList(output), 20));
    }

    public static void addRecipe(ItemStack input, ItemStack output) {
        recipeManager.addRecipe(new UniversalRecipeInput(null, Arrays.asList(input)), new UniversalRecipeOutput(null, Arrays.asList(output), 20));
    }
}

