/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.metallurgy;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableItemStack;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotOutput;
import ihl.items_blocks.WireItem;
import ihl.processing.chemistry.ApparatusProcessableInvSlot;
import ihl.processing.invslots.InvSlotConsumableLiquidIHL;
import ihl.processing.metallurgy.BasicElectricMotorTileEntity;
import ihl.processing.metallurgy.IProductionLine;
import ihl.processing.metallurgy.WireMillContainer;
import ihl.processing.metallurgy.WireMillGui;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLFluidTank;
import ihl.utils.IHLUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class WireMillTileEntity
extends BasicElectricMotorTileEntity {
    public final ApparatusProcessableInvSlot input;
    public final InvSlotConsumableItemStack dice;
    public final InvSlotConsumableLiquidIHL fillInputSlotWater;
    public final InvSlotConsumableLiquidIHL fillInputSlotOil;
    public final InvSlotConsumableLiquidIHL drainInputSlotWater;
    public final InvSlotConsumableLiquidIHL drainInputSlotOil;
    public final InvSlotOutput emptyFluidItemsSlot;
    public final IHLFluidTank oilFluidTank = new IHLFluidTank(1100);
    public final IHLFluidTank waterFluidTank = new IHLFluidTank(1100);
    protected static final UniversalRecipeManager recipeManager = new UniversalRecipeManager();

    public WireMillTileEntity() {
        this.emptyFluidItemsSlot = new InvSlotOutput((TileEntityInventory)this, "emptyWaterFluidItemsSlot", 2, 2);
        this.fillInputSlotWater = new InvSlotConsumableLiquidIHL(this, "fillInputFlammableGas", -1, InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Fill);
        this.fillInputSlotOil = new InvSlotConsumableLiquidIHL(this, "fillInputOxygen", -1, InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Fill);
        this.drainInputSlotWater = new InvSlotConsumableLiquidIHL(this, "drainInputFlammableGas", -1, InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Drain);
        this.drainInputSlotOil = new InvSlotConsumableLiquidIHL(this, "drainInputOxygen", -1, InvSlot.Access.I, 1, InvSlot.InvSide.BOTTOM, InvSlotConsumableLiquid.OpType.Drain);
        this.input = new ApparatusProcessableInvSlot(this, "input", 1, InvSlot.Access.IO, 1, 64);
        this.dice = new InvSlotConsumableItemStack((TileEntityInventory)this, "dice", 3, InvSlot.Access.IO, 1, InvSlot.InvSide.ANY, new ItemStack[]{IHLUtils.getThisModItemStack("setOfDies1_5sqmm"), IHLUtils.getThisModItemStack("setOfDies24sqmm"), IHLUtils.getThisModItemStack("fiberGlassDieSteel")});
        this.isGuiScreenOpened = true;
        this.operationLength = (short)600;
    }

    @Override
    public String func_145825_b() {
        return "WireMill";
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        return IHLUtils.getThisModItemStack("wireMill");
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean arg1) {
        return new WireMillGui(new WireMillContainer(player, this));
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        return new WireMillContainer(player, this);
    }

    @Override
    public void operate() {
        ItemStack rOutputItemStack = this.getOutput().getItemOutputs().get((int)0).itemStack.func_77946_l();
        List<FluidStack> rInputFluidStacks = recipeManager.getRecipeInput(this.getInput()).getFluidInputs();
        if (this.input.get().func_77973_b() instanceof WireItem) {
            if (IHLUtils.adjustWireLength(this.input.get(), -1)) {
                this.input.clear();
            }
        } else {
            this.input.consume(0, 1);
        }
        if (this.dice.get() != null) {
            IHLUtils.damageItemViaNBTTag(this.dice.get(), 1);
            if (this.dice.get().field_77994_a <= 0) {
                this.dice.put(null);
            }
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing()).getRotation(ForgeDirection.DOWN);
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + ForgeDirection.getOrientation((int)this.getFacing()).offsetX, this.field_145848_d + ForgeDirection.getOrientation((int)this.getFacing()).offsetY, this.field_145849_e + ForgeDirection.getOrientation((int)this.getFacing()).offsetZ);
        if (te instanceof IProductionLine) {
            if (!rInputFluidStacks.isEmpty()) {
                this.oilFluidTank.drain(1, true);
                this.waterFluidTank.drain(1, true);
            }
            ((IProductionLine)te).process(rOutputItemStack);
        }
    }

    @Override
    public List[] getInput() {
        if (this.dice.get() != null) {
            return new List[]{Arrays.asList(this.oilFluidTank.getFluid(), this.waterFluidTank.getFluid()), Arrays.asList(this.dice.get(), this.input.get())};
        }
        return new List[]{null, Arrays.asList(this.input.get())};
    }

    public UniversalRecipeOutput getOutput() {
        return recipeManager.getOutputFor(this.getInput(), false, false);
    }

    public static void addRecipe(ItemStack inputDice, ItemStack input, ItemStack output1) {
        recipeManager.addRecipe(new UniversalRecipeInput(Arrays.asList(IHLUtils.getFluidStackWithSize("seedoil", 1), new FluidStack(FluidRegistry.WATER, 1)), Arrays.asList(inputDice, input)), new UniversalRecipeOutput(null, Arrays.asList(output1), 200));
        recipeManager.addRecipe(new UniversalRecipeInput(Arrays.asList(IHLUtils.getFluidStackWithSize("oleicacid", 1), new FluidStack(FluidRegistry.WATER, 1)), Arrays.asList(inputDice, input)), new UniversalRecipeOutput(null, Arrays.asList(output1), 200));
        recipeManager.addRecipe(new UniversalRecipeInput(Arrays.asList(IHLUtils.getFluidStackWithSize("mineraloil", 1), new FluidStack(FluidRegistry.WATER, 1)), Arrays.asList(inputDice, input)), new UniversalRecipeOutput(null, Arrays.asList(output1), 200));
        if (FluidRegistry.isFluidRegistered((String)"lubricant")) {
            recipeManager.addRecipe(new UniversalRecipeInput(Arrays.asList(IHLUtils.getFluidStackWithSize("lubricant", 1), new FluidStack(FluidRegistry.WATER, 1)), Arrays.asList(inputDice, input)), new UniversalRecipeOutput(null, Arrays.asList(output1), 200));
        }
    }

    public static void addPassingWireRecipe(ItemStack input) {
        recipeManager.addRecipe(new UniversalRecipeInput(null, Arrays.asList(input)), new UniversalRecipeOutput(null, Arrays.asList(input), 200));
    }

    @Override
    public boolean canOperate() {
        if (this.getOutput() != null) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing()).getRotation(ForgeDirection.DOWN);
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + ForgeDirection.getOrientation((int)this.getFacing()).offsetX, this.field_145848_d + ForgeDirection.getOrientation((int)this.getFacing()).offsetY, this.field_145849_e + ForgeDirection.getOrientation((int)this.getFacing()).offsetZ);
            if (te instanceof IProductionLine) {
                return ForgeDirection.getOrientation((int)((IProductionLine)te).getFacing()).equals((Object)dir) && ((IProductionLine)te).canProcess(this.getOutput().getItemOutputs().get((int)0).itemStack);
            }
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.oilFluidTank.readFromNBT(nbttagcompound.func_74775_l("oilFluidTank"));
        this.waterFluidTank.readFromNBT(nbttagcompound.func_74775_l("waterFluidTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound oilFluidTankTag = new NBTTagCompound();
        this.oilFluidTank.writeToNBT(oilFluidTankTag);
        nbttagcompound.func_74782_a("oilFluidTank", (NBTBase)oilFluidTankTag);
        NBTTagCompound waterFluidTankTag = new NBTTagCompound();
        this.waterFluidTank.writeToNBT(waterFluidTankTag);
        nbttagcompound.func_74782_a("waterFluidTank", (NBTBase)waterFluidTankTag);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        IHLUtils.handleFluidSlotsBehaviour(this.fillInputSlotOil, this.drainInputSlotOil, this.emptyFluidItemsSlot, this.oilFluidTank);
        IHLUtils.handleFluidSlotsBehaviour(this.fillInputSlotWater, this.drainInputSlotWater, this.emptyFluidItemsSlot, this.waterFluidTank);
    }

    public int gaugeLiquidScaled(int i) {
        if (this.oilFluidTank.getFluid() != null) {
            return this.oilFluidTank.getFluidAmount() * i / this.oilFluidTank.getCapacity();
        }
        return 0;
    }

    @Override
    public int gaugeProgressScaled(int i) {
        return this.progress * i / this.operationLength;
    }

    public int gaugeWaterScaled(int i) {
        if (this.waterFluidTank.getFluid() != null) {
            return this.waterFluidTank.getFluidAmount() * i / this.waterFluidTank.getCapacity();
        }
        return 0;
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }
}

