/*
 * Decompiled with CFR 0.152.
 */
package ihl.trans_dimensional_item_teleporter;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.IC2Items;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.IUpgradableBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.item.IUpgradeItem;
import ic2.core.network.NetworkManager;
import ihl.IHLMod;
import ihl.trans_dimensional_item_teleporter.TDITContainer;
import ihl.trans_dimensional_item_teleporter.TDITGui;
import ihl.utils.IHLInvSlotDischarge;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TDITTileEntity
extends TileEntityInventory
implements IEnergySink,
IHasGui,
IUpgradableBlock {
    private int startUpCounter = 0;
    private int tier = 4;
    private int defaultTier = 4;
    public int maxStorage = 12000;
    private int defaultMaxStorage = 12000;
    private double energy = 0.0;
    private double energyConsume = 12000.0;
    public boolean addedToEnergyNet = false;
    public final InvSlotUpgrade upgradeSlot;
    public final IHLInvSlotDischarge dischargeSlot;
    public final InvSlotOutput outputSlot;
    public final InvSlot inputSlot;
    public int updateChecksum = -1;
    private Random rand = new Random();
    private AudioSource startAS;
    public boolean targetSet = false;
    public int targetDimension;
    public int targetX;
    public int targetY;
    public int targetZ;
    public int currentStatus = 0;
    public int lastStatus = 0;
    private int timer = 0;

    public TDITTileEntity() {
        this.defaultTier = IHLMod.config.tditTier;
        this.defaultMaxStorage = IHLMod.config.tditMaxEnergyStorage;
        this.energyConsume = IHLMod.config.tditEnergyConsumePerStack;
        this.dischargeSlot = new IHLInvSlotDischarge(this, 0, InvSlot.Access.IO, this.tier, InvSlot.InvSide.SIDE);
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 1, 4);
        this.outputSlot = new InvSlotOutput((TileEntityInventory)this, "output", 2, 9);
        this.inputSlot = new InvSlot((TileEntityInventory)this, "input", 2, InvSlot.Access.I, 9, InvSlot.InvSide.TOP);
    }

    public List<String> getNetworkedFields() {
        List fields = super.getNetworkedFields();
        fields.add("tier");
        fields.add("maxStorage");
        fields.add("currentStatus");
        return fields;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        block2: {
            super.func_145839_a(nbttagcompound);
            try {
                this.energy = nbttagcompound.func_74769_h("energy");
            }
            catch (Exception var3) {
                this.energy = nbttagcompound.func_74762_e("energy");
                if (this.maxStorage <= Integer.MAX_VALUE) break block2;
                this.energy *= 10.0;
            }
        }
        this.targetSet = nbttagcompound.func_74767_n("targetSet");
        this.targetDimension = nbttagcompound.func_74762_e("targetDimension");
        this.targetX = nbttagcompound.func_74762_e("targetX");
        this.targetY = nbttagcompound.func_74762_e("targetY");
        this.targetZ = nbttagcompound.func_74762_e("targetZ");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
        nbttagcompound.func_74757_a("targetSet", this.targetSet);
        nbttagcompound.func_74768_a("targetDimension", this.targetDimension);
        nbttagcompound.func_74768_a("targetX", this.targetX);
        nbttagcompound.func_74768_a("targetY", this.targetY);
        nbttagcompound.func_74768_a("targetZ", this.targetZ);
    }

    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
        if (IC2.platform.isRendering() && this.startAS == null) {
            this.startAS = IC2.audioManager.createSource((Object)this, PositionSpec.Center, this.getStartSoundFile(), false, false, 1.0f);
        }
    }

    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.startAS != null) {
            this.startAS.stop();
            this.startAS = null;
            IC2.audioManager.removeSources((Object)this);
        }
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        if (this.dischargeSlot.get() != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.dischargeSlot.get()));
        }
        if (this.upgradeSlot.get(0) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(0)));
        }
        if (this.upgradeSlot.get(1) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(1)));
        }
        if (this.upgradeSlot.get(2) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(2)));
        }
        if (this.upgradeSlot.get(3) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, this.upgradeSlot.get(3)));
        }
        return new ItemStack(IHLMod.tditBlock, 1);
    }

    public void setFacing(short facing1) {
        super.setFacing(facing1);
        this.updateChecksum = -1;
    }

    public boolean enableUpdateEntity() {
        return true;
    }

    public String getStartSoundFile() {
        return "Machines/IHL Industrial Fan/start.ogg";
    }

    public String getLoopSoundFile() {
        return "Machines/IHL Industrial Fan/loop.ogg";
    }

    public String getStopSoundFile() {
        return "Machines/IHL Industrial Fan/stop.ogg";
    }

    public void func_145845_h() {
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
            if (this.timer > 0) {
                --this.timer;
            } else {
                this.timer = 60;
                int energyToOperate = this.countEnergyToOperate();
                if (energyToOperate > 0 && (double)energyToOperate <= this.energy) {
                    this.sendItemStack();
                    this.energy -= (double)energyToOperate;
                } else {
                    this.currentStatus = energyToOperate == 0 && this.energy > 100.0 ? 0 : 1;
                }
                if (this.currentStatus != this.lastStatus) {
                    ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "currentStatus");
                    this.lastStatus = this.currentStatus;
                }
            }
        }
        if (this.dischargeSlot.tier != this.tier) {
            this.dischargeSlot.tier = this.tier;
        }
        if (this.getDemandedEnergy() > 1.0) {
            double amount = this.dischargeSlot.discharge(this.getDemandedEnergy(), false);
            this.energy += amount;
        }
        if (this.energy > (double)this.maxStorage) {
            this.energy = this.maxStorage;
        }
        if (IC2.platform.isRendering() && this.startAS != null) {
            if (this.getActive()) {
                this.startAS.play();
            } else {
                this.startAS.stop();
            }
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public String func_145825_b() {
        return "tdit";
    }

    public int getStored() {
        return Math.round((float)this.energy);
    }

    public void setStored(int value) {
        this.energy = value;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer arg0, boolean arg1) {
        return new TDITGui(new TDITContainer(arg0, this));
    }

    public boolean getGui(EntityPlayer player) {
        return this instanceof IHasGui ? (IC2.platform.isSimulating() ? IC2.platform.launchGui(player, (IHasGui)this) : true) : false;
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer arg0) {
        return new TDITContainer(arg0, this);
    }

    public void onGuiClosed(EntityPlayer arg0) {
    }

    public void setOverclockRates() {
        int tierUp = 0;
        int capacityUp = 0;
        int checksum = 0;
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            if (this.upgradeSlot.get(i) == null) continue;
            if (this.upgradeSlot.get(i).func_77960_j() == IC2Items.getItem((String)"transformerUpgrade").func_77960_j()) {
                tierUp += this.upgradeSlot.get((int)i).field_77994_a;
            }
            if (this.upgradeSlot.get(i).func_77960_j() != IC2Items.getItem((String)"energyStorageUpgrade").func_77960_j()) continue;
            capacityUp += this.upgradeSlot.get((int)i).field_77994_a;
        }
        checksum = tierUp * 64 + capacityUp;
        if (this.updateChecksum != checksum) {
            this.maxStorage = this.defaultMaxStorage + capacityUp * 10000;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "maxStorage");
            this.tier = this.defaultTier + tierUp;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "tier");
            this.updateChecksum = checksum;
        }
    }

    public double getDemandedEnergy() {
        return (double)this.maxStorage - this.energy;
    }

    public int getSinkTier() {
        return this.tier;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (this.energy >= (double)this.maxStorage) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    public List<ItemStack> getCompatibleUpgradeList() {
        ArrayList<ItemStack> compatibleUpgrades = new ArrayList<ItemStack>();
        compatibleUpgrades.add(IC2Items.getItem((String)"transformerUpgrade"));
        compatibleUpgrades.add(IC2Items.getItem((String)"energyStorageUpgrade"));
        compatibleUpgrades.add(IC2Items.getItem((String)"ejectorUpgrade"));
        return compatibleUpgrades;
    }

    public double getEnergy() {
        return this.energy;
    }

    public void setRedstonePowered(boolean arg0) {
    }

    public boolean useEnergy(double amount) {
        if (this.energy >= amount) {
            this.energy -= amount;
            return true;
        }
        return false;
    }

    public void setTarget(int targetX2, int targetY2, int targetZ2, int dimesionID) {
        this.targetSet = true;
        this.targetX = targetX2;
        this.targetY = targetY2;
        this.targetZ = targetZ2;
        this.targetDimension = dimesionID;
    }

    public boolean canRecieve(List<ItemStack> itemStackList) {
        int countEmptySlots = 0;
        for (int i = 0; i < this.outputSlot.size(); ++i) {
            if (this.outputSlot.get(i) != null) continue;
            ++countEmptySlots;
        }
        return countEmptySlots >= itemStackList.size();
    }

    public void recieveItemStack(List<ItemStack> itemStackList) {
        this.outputSlot.add(itemStackList);
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack != null && stack.func_77973_b() instanceof IUpgradeItem && !((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this)) continue;
        }
    }

    private int countEnergyToOperate() {
        int energy = 0;
        for (int i = 0; i < this.inputSlot.size(); ++i) {
            if (this.inputSlot.get(i) == null) continue;
            energy = (int)((double)energy + this.energyConsume * (double)this.inputSlot.get((int)i).field_77994_a / (double)this.inputSlot.get(i).func_77976_d());
        }
        return energy;
    }

    public void sendItemStack() {
        if (!this.inputSlot.isEmpty() && this.targetSet) {
            WorldServer targetWorld = MinecraftServer.func_71276_C().func_71218_a(this.targetDimension);
            if (targetWorld != null) {
                TileEntity te = targetWorld.func_147438_o(this.targetX, this.targetY, this.targetZ);
                if (te != null && te instanceof TDITTileEntity) {
                    TDITTileEntity tdit = (TDITTileEntity)te;
                    ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
                    for (int i = 0; i < this.inputSlot.size(); ++i) {
                        if (this.inputSlot.get(i) == null) continue;
                        itemStackList.add(this.inputSlot.get(i));
                    }
                    if (tdit.canRecieve(itemStackList)) {
                        tdit.recieveItemStack(itemStackList);
                        this.inputSlot.clear();
                    } else {
                        this.currentStatus = 4;
                    }
                } else {
                    this.currentStatus = 2;
                }
            }
        } else {
            this.currentStatus = 3;
        }
    }

    public ItemStack getOutput(int arg0) {
        return this.outputSlot.get(arg0);
    }

    public int getOutputSize() {
        return this.outputSlot.size();
    }

    public void setOutput(int arg0, ItemStack arg1) {
        this.outputSlot.put(arg0, arg1);
    }
}

