/*
 * Decompiled with CFR 0.152.
 */
package ihl.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import ihl.IHLMod;
import ihl.utils.IHLUtils;
import ihl.worldgen.WorldGenMinableMeta;
import ihl.worldgen.ores.IHLFluid;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGenerator
implements IWorldGenerator {
    private WorldGenMinableMeta apatiteGenerator;
    private WorldGenMinableMeta saltpeterGenerator;
    private WorldGenMinableMeta limestoneGenerator;
    private WorldGenMinableMeta gypsumGenerator;
    private WorldGenMinableMeta potassiumFeldsparGenerator;
    private WorldGenMinableMeta tronaGenerator;
    private WorldGenMinableMeta gyubneraGenerator;
    private WorldGenMinableMeta rocksaltGenerator;
    private WorldGenMinableMeta cinnabarGenerator;
    private WorldGenMinableMeta bauxiteGenerator;
    private WorldGenMinableMeta chromiteGenerator;
    private WorldGenMinableMeta muscoviteGenerator;
    private WorldGenMinableMeta oilGenerator;
    private WorldGenMinableMeta datoliteGenerator;
    private WorldGenMinableMeta saltwaterGenerator;
    private WorldGenMinableMeta bischofiteGenerator;
    private static final float BASIC_CHANCE_TO_GENERATE_ORE = 0.01f;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (this.apatiteGenerator == null) {
            this.apatiteGenerator = new WorldGenMinableMeta(IHLUtils.getOreDictBlock("oreApatite"), 0, 360, Blocks.field_150348_b);
            this.saltpeterGenerator = new WorldGenMinableMeta(IHLUtils.getOreDictBlock("oreSaltpeter"), 0, 140, Blocks.field_150348_b);
            this.limestoneGenerator = new WorldGenMinableMeta(IHLUtils.getOreDictBlock("oreLimestone"), 0, 140, Blocks.field_150348_b);
            this.gypsumGenerator = new WorldGenMinableMeta(IHLUtils.getOreDictBlock("oreGypsum"), 0, 140, Blocks.field_150348_b);
            this.potassiumFeldsparGenerator = new WorldGenMinableMeta(IHLUtils.getOreDictBlock("orePotassiumFeldspar"), 0, 140, Blocks.field_150348_b);
            this.tronaGenerator = new WorldGenMinableMeta(IHLUtils.getOreDictBlock("oreTrona"), 0, 700, Blocks.field_150348_b);
            this.gyubneraGenerator = new WorldGenMinableMeta(IHLUtils.getOreDictBlock("oreGyubnera"), 0, 700, Blocks.field_150348_b);
            this.rocksaltGenerator = new WorldGenMinableMeta(IHLUtils.getOreDictBlock("oreRockSalt"), 0, 140, Blocks.field_150348_b);
            this.cinnabarGenerator = new WorldGenMinableMeta(IHLUtils.getOreDictBlock("oreCinnabar"), 0, 700, Blocks.field_150348_b);
            this.bauxiteGenerator = new WorldGenMinableMeta(IHLUtils.getOreDictBlock("oreBauxite"), 0, 700, Blocks.field_150348_b);
            this.chromiteGenerator = new WorldGenMinableMeta(IHLUtils.getOreDictBlock("oreChromite"), 0, 700, Blocks.field_150348_b);
            this.muscoviteGenerator = new WorldGenMinableMeta(IHLUtils.getOreDictBlock("oreMica"), 0, 140, Blocks.field_150348_b);
            this.oilGenerator = new WorldGenMinableMeta(IHLFluid.getBlock("oil"), Blocks.field_150435_aG, 0, 360, 64, 64, Blocks.field_150353_l);
            this.datoliteGenerator = new WorldGenMinableMeta(IHLUtils.getOreDictBlock("oreDatolite"), 0, 700, Blocks.field_150348_b);
            this.saltwaterGenerator = new WorldGenMinableMeta(IHLFluid.getBlock("saltwater"), Blocks.field_150322_A, 0, 360, 1, 1, new Block[]{Blocks.field_150354_m});
            this.bischofiteGenerator = new WorldGenMinableMeta(IHLUtils.getOreDictBlock("oreBischofite"), 0, 1400, Blocks.field_150348_b);
        }
        chunkX <<= 4;
        chunkZ <<= 4;
        if (random.nextFloat() < 0.01f) {
            int randPosZ;
            int randPosY;
            int randPosX;
            if (!IHLMod.config.generateApatiteOre || !(random.nextFloat() < 0.25f) || this.apatiteGenerator.func_76484_a(world, random, randPosX = chunkX + random.nextInt(16), randPosY = random.nextInt(world.func_72940_L() - 72) + 56, randPosZ = chunkZ + random.nextInt(16))) {
                // empty if block
            }
            if (!IHLMod.config.generateSaltpeterOre || !(random.nextFloat() < 0.25f) || this.saltpeterGenerator.func_76484_a(world, random, randPosX = chunkX + random.nextInt(16), randPosY = random.nextInt(world.func_72940_L() - 72) + 56, randPosZ = chunkZ + random.nextInt(16))) {
                // empty if block
            }
            if (!IHLMod.config.generateGyubnera || !(random.nextFloat() < 0.25f) || this.gyubneraGenerator.func_76484_a(world, random, randPosX = chunkX + random.nextInt(16), randPosY = random.nextInt(world.func_72940_L()), randPosZ = chunkZ + random.nextInt(16))) {
                // empty if block
            }
            if (!IHLMod.config.generateCinnabar || !(random.nextFloat() < 0.25f) || this.cinnabarGenerator.func_76484_a(world, random, randPosX = chunkX + random.nextInt(16), randPosY = random.nextInt(world.func_72940_L() - 16), randPosZ = chunkZ + random.nextInt(16))) {
                // empty if block
            }
            if (!IHLMod.config.generateRocksalt || !(random.nextFloat() < 0.2f) || this.rocksaltGenerator.func_76484_a(world, random, randPosX = chunkX + random.nextInt(16), randPosY = random.nextInt(world.func_72940_L() - 72) + 56, randPosZ = chunkZ + random.nextInt(16))) {
                // empty if block
            }
            if (!IHLMod.config.generateLimestone || this.limestoneGenerator.func_76484_a(world, random, randPosX = chunkX + random.nextInt(16), randPosY = random.nextInt(world.func_72940_L()) + 16, randPosZ = chunkZ + random.nextInt(16))) {
                // empty if block
            }
            if (!IHLMod.config.generateGypsum || this.gypsumGenerator.func_76484_a(world, random, randPosX = chunkX + random.nextInt(16), randPosY = random.nextInt(world.func_72940_L()) + 16, randPosZ = chunkZ + random.nextInt(16))) {
                // empty if block
            }
            if (!IHLMod.config.generatePotassiumFeldspar || this.potassiumFeldsparGenerator.func_76484_a(world, random, randPosX = chunkX + random.nextInt(16), randPosY = random.nextInt(world.func_72940_L()), randPosZ = chunkZ + random.nextInt(16))) {
                // empty if block
            }
            if (!IHLMod.config.generateTrona || this.tronaGenerator.func_76484_a(world, random, randPosX = chunkX + random.nextInt(16), randPosY = random.nextInt(world.func_72940_L() - 32) + 16, randPosZ = chunkZ + random.nextInt(16))) {
                // empty if block
            }
            if (!IHLMod.config.generateBauxite || !(random.nextFloat() < 0.25f) || this.bauxiteGenerator.func_76484_a(world, random, randPosX = chunkX + random.nextInt(16), randPosY = random.nextInt(world.func_72940_L() - 72) + 56, randPosZ = chunkZ + random.nextInt(16))) {
                // empty if block
            }
            if (!IHLMod.config.generateChromite || !(random.nextFloat() < 0.25f) || this.chromiteGenerator.func_76484_a(world, random, randPosX = chunkX + random.nextInt(16), randPosY = random.nextInt(world.func_72940_L()), randPosZ = chunkZ + random.nextInt(16))) {
                // empty if block
            }
            if (!IHLMod.config.generateMuscovite || this.muscoviteGenerator.func_76484_a(world, random, randPosX = chunkX + random.nextInt(16), randPosY = random.nextInt(world.func_72940_L() - 32) + 32, randPosZ = chunkZ + random.nextInt(16))) {
                // empty if block
            }
            if (!IHLMod.config.generateOil || this.oilGenerator.func_76484_a(world, random, randPosX = chunkX + random.nextInt(16), randPosY = random.nextInt(16), randPosZ = chunkZ + random.nextInt(16))) {
                // empty if block
            }
            if (IHLMod.config.generateSaltwater) {
                int randPosZ2;
                int randPosY2;
                int randPosX2;
                BiomeGenBase biome = world.func_72807_a(chunkX, chunkZ);
                if (!(biome.field_76750_F > 1.9f) || biome.field_76751_G != 0.0f || this.saltwaterGenerator.func_76484_a(world, random, randPosX2 = chunkX + random.nextInt(16), randPosY2 = 64, randPosZ2 = chunkZ + random.nextInt(16))) {
                    // empty if block
                }
            }
            if (!IHLMod.config.generateDatolite || !(random.nextFloat() < 0.25f) || this.datoliteGenerator.func_76484_a(world, random, randPosX = chunkX + random.nextInt(16), randPosY = random.nextInt(world.func_72940_L() - 32), randPosZ = chunkZ + random.nextInt(16))) {
                // empty if block
            }
            if (!IHLMod.config.generateBischofite || !(random.nextFloat() < 0.25f) || this.bischofiteGenerator.func_76484_a(world, random, randPosX = chunkX + random.nextInt(16), randPosY = random.nextInt(world.func_72940_L() - 32), randPosZ = chunkZ + random.nextInt(16))) {
                // empty if block
            }
        }
    }
}

