/*
 * Decompiled with CFR 0.152.
 */
package ihl.i_hate_liquids;

import ihl.IHLMod;
import ihl.i_hate_liquids.XYZ;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class InvisibleMagicanEntity
extends Entity {
    private int entityAge = 0;
    private int timer = 0;
    private int viscosityTimer = 0;
    private int viscosity = 5;
    public int x0 = 0;
    public int y0 = 0;
    public int z0 = 0;
    public List<XYZ> flowXYZ = new ArrayList<XYZ>();
    public List<Block> blockList = new ArrayList<Block>();
    private Block block;
    private int lowestPointsCounter = 0;

    public InvisibleMagicanEntity(World arg0) {
        super(arg0);
        this.field_70178_ae = true;
        this.field_70145_X = true;
        this.func_70105_a(0.0f, 0.0f);
    }

    public InvisibleMagicanEntity(World arg0, int x, int y, int z) {
        super(arg0);
        this.x0 = x;
        this.y0 = y;
        this.z0 = z;
        this.func_70107_b(x, y, z);
        this.field_70178_ae = true;
        this.field_70145_X = true;
        this.func_70105_a(0.0f, 0.0f);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.blockList.isEmpty()) {
                if (!this.takeLowestPoint()) {
                    this.func_70106_y();
                    return;
                }
                if (this.block != null) {
                    if (this.block == Blocks.field_150355_j || this.block == Blocks.field_150358_i) {
                        this.viscosity = -1;
                    } else if (this.block instanceof IFluidBlock) {
                        IFluidBlock bf = (IFluidBlock)this.block;
                        if (bf.getFluid() != null && bf.getFluid().getViscosity() > 600) {
                            this.viscosity = bf.getFluid().getViscosity() / 300;
                        }
                    } else {
                        this.viscosity = this.block.func_149688_o() == Material.field_151587_i ? 20 : 20;
                    }
                } else {
                    ++this.entityAge;
                }
            } else if (this.viscosityTimer < this.viscosity) {
                ++this.viscosityTimer;
            } else {
                this.viscosityTimer = 0;
                if (!this.flowXYZ.isEmpty()) {
                    XYZ xyz = this.flowXYZ.remove(0);
                    if (this.flowXYZ.isEmpty()) {
                        this.timer = 0;
                        Block block1 = this.blockList.get(0);
                        if (this.setBlock(xyz.x, xyz.y, xyz.z, block1)) {
                            this.blockList.remove(0);
                        }
                        if (!this.takeLowestPoint()) {
                            this.func_70106_y();
                            return;
                        }
                    } else {
                        Block blockToReplace = this.field_70170_p.func_147439_a(xyz.x, xyz.y, xyz.z);
                        if (blockToReplace == null || blockToReplace.isAir((IBlockAccess)this.field_70170_p, xyz.x, xyz.y, xyz.z) || blockToReplace.func_149688_o().func_76224_d() || blockToReplace == Blocks.field_150431_aC || blockToReplace == Blocks.field_150395_bd || blockToReplace == Blocks.field_150329_H || blockToReplace == Blocks.field_150330_I) {
                            if (this.flowXYZ.size() <= this.blockList.size()) {
                                Block block1 = this.blockList.get(0);
                                if (this.setBlock(xyz.x, xyz.y, xyz.z, block1)) {
                                    this.blockList.remove(0);
                                }
                            } else if (!this.setNonSourceBlock(xyz.x, xyz.y, xyz.z, this.block)) {
                                // empty if block
                            }
                        } else {
                            this.flowXYZ.clear();
                        }
                    }
                }
            }
            if (this.lowestPointsCounter > this.blockList.size()) {
                this.searchSourceDestroyCount(this.field_70170_p, this.x0, this.y0, this.z0, this.block, this.lowestPointsCounter);
                if (!this.blockList.isEmpty()) {
                    this.block = this.blockList.get(0);
                }
            }
            if (this.entityAge > 200) {
                this.func_70106_y();
                return;
            }
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound arg0) {
    }

    protected void func_70014_b(NBTTagCompound arg0) {
    }

    private int getFlowDecay(int par2, int par3, int par4) {
        Block block = this.field_70170_p.func_147439_a(par2, par3, par4);
        return block.func_149688_o().func_76224_d() ? this.field_70170_p.func_72805_g(par2, par3, par4) : -1;
    }

    private boolean writeLowestFlowPoint() {
        int startx = this.x0;
        int starty = this.y0;
        int startz = this.z0;
        int currentFlowDecay = this.getFlowDecay(startx, starty, startz);
        for (int i = 0; i < 64; ++i) {
            if (this.getFlowDecay(startx, starty + 1, startz) >= 0) {
                currentFlowDecay = this.getFlowDecay(startx, ++starty, startz);
                continue;
            }
            if (this.getFlowDecay(startx + 1, starty + 1, startz) >= 0) {
                currentFlowDecay = this.getFlowDecay(++startx, ++starty, startz);
                continue;
            }
            if (this.getFlowDecay(startx - 1, starty + 1, startz) >= 0) {
                currentFlowDecay = this.getFlowDecay(--startx, ++starty, startz);
                continue;
            }
            if (this.getFlowDecay(startx, starty + 1, startz + 1) >= 0) {
                currentFlowDecay = this.getFlowDecay(startx, ++starty, ++startz);
                continue;
            }
            if (this.getFlowDecay(startx, starty + 1, startz - 1) >= 0) {
                currentFlowDecay = this.getFlowDecay(startx, ++starty, --startz);
                continue;
            }
            if (this.getFlowDecay(startx - 1, starty, startz) < currentFlowDecay && this.getFlowDecay(startx - 1, starty, startz) != -1) {
                currentFlowDecay = this.getFlowDecay(--startx, starty, startz);
                continue;
            }
            if (this.getFlowDecay(startx, starty, startz + 1) < currentFlowDecay && this.getFlowDecay(startx, starty, startz + 1) != -1) {
                currentFlowDecay = this.getFlowDecay(startx, starty, ++startz);
                continue;
            }
            if (this.getFlowDecay(startx, starty, startz - 1) < currentFlowDecay && this.getFlowDecay(startx, starty, startz - 1) != -1) {
                currentFlowDecay = this.getFlowDecay(startx, starty, --startz);
                continue;
            }
            if (this.getFlowDecay(startx + 1, starty, startz) < currentFlowDecay && this.getFlowDecay(startx + 1, starty, startz) != -1) {
                currentFlowDecay = this.getFlowDecay(++startx, starty, startz);
                continue;
            }
            if (currentFlowDecay == 0) break;
            if (this.getFlowDecay(startx - 1, starty, startz) == currentFlowDecay && this.getFlowDecay(startx - 1, starty, startz) != -1) {
                currentFlowDecay = this.getFlowDecay(--startx, starty, startz);
                continue;
            }
            if (this.getFlowDecay(startx, starty, startz + 1) == currentFlowDecay && this.getFlowDecay(startx, starty, startz + 1) != -1) {
                currentFlowDecay = this.getFlowDecay(startx, starty, ++startz);
                continue;
            }
            if (this.getFlowDecay(startx, starty, startz - 1) == currentFlowDecay && this.getFlowDecay(startx, starty, startz - 1) != -1) {
                currentFlowDecay = this.getFlowDecay(startx, starty, --startz);
                continue;
            }
            if (this.getFlowDecay(startx + 1, starty, startz) != currentFlowDecay || this.getFlowDecay(startx + 1, starty, startz) == -1) break;
            currentFlowDecay = this.getFlowDecay(++startx, starty, startz);
        }
        if (currentFlowDecay == 0) {
            Block block1 = this.field_70170_p.func_147439_a(startx, starty, startz);
            if (this.replaceBlock(startx, starty, startz, block1)) {
                this.block = block1;
                return true;
            }
        } else if (currentFlowDecay >= 7) {
            this.field_70170_p.func_147468_f(startx, starty, startz);
        } else {
            this.field_70170_p.func_72921_c(startx, starty, startz, currentFlowDecay + 1, 0);
        }
        return false;
    }

    public boolean replaceBlock(int x, int y, int z, Block block) {
        if (!(IHLMod.cccFiniteWater || block != Blocks.field_150358_i && block != Blocks.field_150355_j)) {
            if (this.field_70170_p.func_147465_d(x, y, z, IHLMod.flowing_water, 6, 3)) {
                this.field_70170_p.func_147464_a(x, y, z, IHLMod.flowing_water, 10);
                return true;
            }
            return false;
        }
        if (!IHLMod.cccFiniteWater && this.field_70170_p.field_73011_w.field_76575_d && (block == Blocks.field_150356_k || block == Blocks.field_150353_l)) {
            if (this.field_70170_p.func_147465_d(x, y, z, IHLMod.flowing_lava, 6, 3)) {
                this.field_70170_p.func_147464_a(x, y, z, IHLMod.flowing_lava, 10);
                return true;
            }
            return false;
        }
        if (this.field_70170_p.func_72921_c(x, y, z, 6, 3)) {
            this.field_70170_p.func_147464_a(x, y, z, this.field_70170_p.func_147439_a(x, y, z), 10);
            return true;
        }
        return false;
    }

    public boolean setNonSourceBlock(int x, int y, int z, Block block) {
        if (block == Blocks.field_150358_i || block == Blocks.field_150355_j) {
            if (this.field_70170_p.func_147465_d(x, y, z, (Block)Blocks.field_150358_i, 1, 3)) {
                this.field_70170_p.func_147464_a(x, y, z, (Block)Blocks.field_150358_i, 80);
                return true;
            }
            return false;
        }
        if (block == Blocks.field_150356_k || block == Blocks.field_150353_l) {
            if (this.field_70170_p.func_147465_d(x, y, z, (Block)Blocks.field_150356_k, 1, 3)) {
                this.field_70170_p.func_147464_a(x, y, z, (Block)Blocks.field_150356_k, 80);
                return true;
            }
            return false;
        }
        if (this.field_70170_p.func_147465_d(x, y, z, block, 1, 3)) {
            this.field_70170_p.func_147464_a(x, y, z, block, 80);
            return true;
        }
        return false;
    }

    public boolean setBlock(int x, int y, int z, Block block) {
        if (block == Blocks.field_150358_i || block == Blocks.field_150355_j) {
            if (this.field_70170_p.func_147465_d(x, y, z, (Block)Blocks.field_150358_i, 0, 3)) {
                this.field_70170_p.func_147464_a(x, y, z, (Block)Blocks.field_150358_i, 20);
                return true;
            }
            return false;
        }
        if (block == Blocks.field_150356_k || block == Blocks.field_150353_l) {
            if (this.field_70170_p.func_147465_d(x, y, z, (Block)Blocks.field_150356_k, 0, 3)) {
                this.field_70170_p.func_147464_a(x, y, z, (Block)Blocks.field_150356_k, 20);
                return true;
            }
            return false;
        }
        if (this.field_70170_p.func_147465_d(x, y, z, block, 0, 3)) {
            this.field_70170_p.func_147464_a(x, y, z, block, 20);
            return true;
        }
        return false;
    }

    private boolean takeLowestPoint() {
        int[] xz = new int[]{0, 1, 0, -1, 0};
        int x = this.x0;
        int y = this.y0;
        int z = this.z0;
        ArrayList<Long> list = new ArrayList<Long>();
        list.clear();
        this.flowXYZ.clear();
        for (int thread = 0; thread <= 256; ++thread) {
            long number = new Long((long)x * 256L * 256L + (long)y * 256L + (long)z);
            list.add(number);
            boolean skip = false;
            Block block = this.field_70170_p.func_147439_a(x, y - 1, z);
            number = new Long((long)x * 256L * 256L + (long)(y - 1) * 256L + (long)z);
            if ((block.isAir((IBlockAccess)this.field_70170_p, x, y - 1, z) || this.getFlowDecay(x, y - 1, z) >= 1) && !list.contains(number)) {
                --y;
                this.lowestPointsCounter = 1;
                skip = true;
            }
            if (!skip) {
                for (int i = 0; i <= 3; ++i) {
                    block = this.field_70170_p.func_147439_a(x + xz[i], y, z + xz[i + 1]);
                    number = new Long((long)(x + xz[i]) * 256L * 256L + (long)y * 256L + (long)(z + xz[i + 1]));
                    if (!block.isAir((IBlockAccess)this.field_70170_p, x + xz[i], y, z + xz[i + 1]) && this.getFlowDecay(x + xz[i], y, z + xz[i + 1]) < 1 || list.contains(number)) continue;
                    x += xz[i];
                    z += xz[i + 1];
                    skip = true;
                    ++this.lowestPointsCounter;
                    break;
                }
            }
            XYZ xyz = new XYZ(x, y, z);
            this.flowXYZ.add(xyz);
            if (!skip) break;
        }
        return y < this.y0;
    }

    private int searchSourceDestroyCount(World world, int startx, int starty, int startz, Block type, int countCells) {
        int currentFlowDecay = this.getFlowDecay(world, startx, starty, startz);
        for (int i = 0; i < 64; ++i) {
            if (this.getFlowDecay(world, startx, starty + 1, startz) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, startx, ++starty, startz);
                continue;
            }
            if (this.getFlowDecay(world, startx + 1, starty + 1, startz) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, ++startx, ++starty, startz);
                continue;
            }
            if (this.getFlowDecay(world, startx - 1, starty + 1, startz) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, --startx, ++starty, startz);
                continue;
            }
            if (this.getFlowDecay(world, startx, starty + 1, startz + 1) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, startx, ++starty, ++startz);
                continue;
            }
            if (this.getFlowDecay(world, startx, starty + 1, startz - 1) >= 0) {
                currentFlowDecay = this.getFlowDecay(world, startx, ++starty, --startz);
                continue;
            }
            if (this.getFlowDecay(world, startx - 1, starty, startz) < currentFlowDecay && this.getFlowDecay(world, startx - 1, starty, startz) != -1) {
                currentFlowDecay = this.getFlowDecay(world, --startx, starty, startz);
                continue;
            }
            if (this.getFlowDecay(world, startx, starty, startz + 1) < currentFlowDecay && this.getFlowDecay(world, startx, starty, startz + 1) != -1) {
                currentFlowDecay = this.getFlowDecay(world, startx, starty, ++startz);
                continue;
            }
            if (this.getFlowDecay(world, startx, starty, startz - 1) < currentFlowDecay && this.getFlowDecay(world, startx, starty, startz - 1) != -1) {
                currentFlowDecay = this.getFlowDecay(world, startx, starty, --startz);
                continue;
            }
            if (this.getFlowDecay(world, startx + 1, starty, startz) >= currentFlowDecay || this.getFlowDecay(world, startx + 1, starty, startz) == -1) break;
            currentFlowDecay = this.getFlowDecay(world, ++startx, starty, startz);
        }
        ArrayList<XYZ> xyzlist = new ArrayList<XYZ>();
        if (currentFlowDecay == 0) {
            xyzlist.add(new XYZ(startx, starty, startz));
            Block block = this.field_70170_p.func_147439_a(startx, starty, startz);
            this.replaceBlock(startx, starty, startz, block);
            this.blockList.add(block);
            int listPos = 0;
            for (int i = 0; i <= countCells; ++i) {
                if (this.getFlowDecay(world, startx - 1, starty, startz) == 0 && !xyzlist.contains(new XYZ(startx - 1, starty, startz))) {
                    xyzlist.add(new XYZ(--startx, starty, startz));
                    listPos = xyzlist.size() - 1;
                    block = this.field_70170_p.func_147439_a(startx, starty, startz);
                    this.replaceBlock(startx, starty, startz, block);
                    this.blockList.add(block);
                    continue;
                }
                if (this.getFlowDecay(world, startx, starty, startz + 1) == 0 && !xyzlist.contains(new XYZ(startx, starty, startz + 1))) {
                    xyzlist.add(new XYZ(startx, starty, ++startz));
                    listPos = xyzlist.size() - 1;
                    block = this.field_70170_p.func_147439_a(startx, starty, startz);
                    this.replaceBlock(startx, starty, startz, block);
                    this.blockList.add(block);
                    continue;
                }
                if (this.getFlowDecay(world, startx, starty, startz - 1) == 0 && !xyzlist.contains(new XYZ(startx, starty, startz - 1))) {
                    xyzlist.add(new XYZ(startx, starty, --startz));
                    listPos = xyzlist.size() - 1;
                    block = this.field_70170_p.func_147439_a(startx, starty, startz);
                    this.replaceBlock(startx, starty, startz, block);
                    this.blockList.add(block);
                    continue;
                }
                if (this.getFlowDecay(world, startx + 1, starty, startz) == 0 && !xyzlist.contains(new XYZ(startx + 1, starty, startz))) {
                    xyzlist.add(new XYZ(++startx, starty, startz));
                    listPos = xyzlist.size() - 1;
                    block = this.field_70170_p.func_147439_a(startx, starty, startz);
                    this.replaceBlock(startx, starty, startz, block);
                    this.blockList.add(block);
                    continue;
                }
                if (listPos <= 0) continue;
                XYZ xyz = (XYZ)xyzlist.get(--listPos);
                startx = xyz.x;
                starty = xyz.y;
                startz = xyz.z;
            }
        }
        return xyzlist.size();
    }

    private int getFlowDecay(World world, int startx, int starty, int startz) {
        return this.getFlowDecay(startx, starty, startz);
    }
}

