/*
 * Decompiled with CFR 0.152.
 */
package ihl.processing.metallurgy;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.block.invslot.InvSlot;
import ic2.core.network.NetworkManager;
import ihl.processing.chemistry.ApparatusProcessableInvSlot;
import ihl.processing.metallurgy.BasicElectricMotorTileEntity;
import ihl.processing.metallurgy.ExtruderContainer;
import ihl.processing.metallurgy.ExtruderGui;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeManager;
import ihl.recipes.UniversalRecipeOutput;
import ihl.utils.IHLUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;

public class ExtruderTileEntity
extends BasicElectricMotorTileEntity {
    public final ApparatusProcessableInvSlot input;
    public final ApparatusProcessableInvSlot input2;
    public boolean hasEngine;
    private int processTimer = 0;
    private FluidTank fluidTank = new FluidTank(1000);
    protected static final UniversalRecipeManager recipeManager = new UniversalRecipeManager();

    public ExtruderTileEntity() {
        this.input = new ApparatusProcessableInvSlot(this, "input", 1, InvSlot.Access.IO, 1, 64);
        this.input2 = new ApparatusProcessableInvSlot(this, "input2", 2, InvSlot.Access.IO, 1, 64);
        this.isGuiScreenOpened = true;
    }

    public List<String> getNetworkedFields() {
        List fields = super.getNetworkedFields();
        fields.add("hasEngine");
        return fields;
    }

    @Override
    public String func_145825_b() {
        return "Extruder";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.engine.isEmpty() && this.hasEngine) {
            this.hasEngine = false;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "hasEngine");
        } else if (this.engine.correctContent() && !this.hasEngine) {
            this.hasEngine = true;
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "hasEngine");
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing());
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        if (this.checkCorrectAccembly() && this.fluidTank.getFluidAmount() > 0 && this.processTimer++ > 20) {
            this.processTimer = 0;
            ((IFluidHandler)te).fill(ForgeDirection.getOrientation((int)this.getFacing()), this.fluidTank.drain(this.fluidTank.getCapacity(), true), true);
        }
    }

    public ItemStack getWrenchDrop(EntityPlayer player) {
        return IHLUtils.getThisModItemStack("extruder");
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean arg1) {
        return new ExtruderGui(new ExtruderContainer(player, this));
    }

    public ContainerBase<?> getGuiContainer(EntityPlayer player) {
        return new ExtruderContainer(player, this);
    }

    @Override
    public void operate() {
        UniversalRecipeInput ri = recipeManager.getRecipeInput(this.getInput());
        this.fluidTank.fill(this.getOutput().getFluidOutputs().get(0), true);
        this.input.consume(0, ri.getItemInputs().get(0).getAmount());
        this.input2.consume(0, ri.getItemInputs().get(1).getAmount());
    }

    public UniversalRecipeOutput getOutput() {
        return recipeManager.getOutputFor(this.getInput(), false, false);
    }

    @Override
    public List[] getInput() {
        return new List[]{null, Arrays.asList(this.input.get(), this.input2.get())};
    }

    @Override
    public boolean canOperate() {
        return this.fluidTank.getFluidAmount() < this.fluidTank.getCapacity() && this.engine.correctContent() && this.getOutput() != null && this.checkCorrectAccembly();
    }

    private boolean checkCorrectAccembly() {
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + ForgeDirection.getOrientation((int)this.getFacing()).offsetX, this.field_145848_d + ForgeDirection.getOrientation((int)this.getFacing()).offsetY, this.field_145849_e + ForgeDirection.getOrientation((int)this.getFacing()).offsetZ);
        return te instanceof IFluidHandler && ((IFluidHandler)te).canFill(ForgeDirection.getOrientation((int)this.getFacing()), FluidRegistry.getFluid((String)"molten.rubberwithsulfur"));
    }

    @Override
    public void onGuiClosed(EntityPlayer arg0) {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fluidTank.readFromNBT(nbttagcompound.func_74775_l("fluidTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagCompound fluidTankTag = new NBTTagCompound();
        this.fluidTank.writeToNBT(fluidTankTag);
        nbttagcompound.func_74782_a("fluidTank", (NBTBase)fluidTankTag);
    }

    public static void addRecipe(ItemStack input, ItemStack input2, FluidStack output) {
        recipeManager.addRecipe(new UniversalRecipeInput(null, Arrays.asList(input, input2)), new UniversalRecipeOutput(Arrays.asList(output), null, 20));
    }

    public static Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return recipeManager.getRecipes();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }
}

