/*
 * Decompiled with CFR 0.152.
 */
package ihl.recipes;

import ic2.api.recipe.IRecipeInput;
import ihl.recipes.UniversalRecipeInput;
import ihl.recipes.UniversalRecipeOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class UniversalRecipeManager {
    private final Map<UniversalRecipeInput, UniversalRecipeOutput> recipes = new HashMap<UniversalRecipeInput, UniversalRecipeOutput>();

    public void addRecipe(UniversalRecipeInput input, UniversalRecipeOutput output) {
        if (input == null) {
            throw new NullPointerException("The recipe input is null");
        }
        if (output.getFluidOutputs() == null || output.getItemOutputs() == null || output.getFluidOutputs().size() == 0 && output.getItemOutputs().size() == 0) {
            throw new NullPointerException("The output is empty");
        }
        for (UniversalRecipeInput existingInput : this.recipes.keySet()) {
            IRecipeInput is;
            if (!existingInput.matches(input)) continue;
            Iterator<IRecipeInput> ilist1 = existingInput.getItemInputs().iterator();
            Iterator<IRecipeInput> ilist2 = input.getItemInputs().iterator();
            while (ilist1.hasNext()) {
                is = ilist1.next();
                System.out.println("Item:" + is.toString());
            }
            System.out.println("recipe 2:");
            while (ilist2.hasNext()) {
                is = ilist2.next();
                System.out.println("Item:" + is.toString());
            }
            throw new RuntimeException("Ambiguous recipe.");
        }
        this.recipes.put(input, output);
    }

    public UniversalRecipeOutput getOutputFor(List<FluidStack> fluidInputs, List<ItemStack> itemInputs, boolean adjustInput, boolean inputAffectOutput) {
        if (fluidInputs == null && itemInputs == null) {
            return null;
        }
        for (Map.Entry<UniversalRecipeInput, UniversalRecipeOutput> entry : this.recipes.entrySet()) {
            UniversalRecipeInput recipeInput = entry.getKey();
            if (!recipeInput.matches(fluidInputs, itemInputs)) continue;
            if (!recipeInput.adjustAmounts(fluidInputs, itemInputs, false)) break;
            UniversalRecipeOutput output = entry.getValue();
            if (adjustInput) {
                if (inputAffectOutput) {
                    int multiplier = recipeInput.getMultiplierAndAdjustAmounts(fluidInputs, itemInputs);
                    return output.copyWithMultiplier(multiplier);
                }
                recipeInput.adjustAmounts(fluidInputs, itemInputs, true);
            }
            return output;
        }
        return null;
    }

    public Map<UniversalRecipeInput, UniversalRecipeOutput> getRecipes() {
        return this.recipes;
    }

    public UniversalRecipeInput getRecipeInput(List<FluidStack> fluidInputs1, List<ItemStack> itemInputs1) {
        for (Map.Entry<UniversalRecipeInput, UniversalRecipeOutput> entry : this.recipes.entrySet()) {
            UniversalRecipeInput recipeInput = entry.getKey();
            if (!recipeInput.matches(fluidInputs1, itemInputs1)) continue;
            if (!recipeInput.adjustAmounts(fluidInputs1, itemInputs1, false)) break;
            return recipeInput;
        }
        return null;
    }

    public UniversalRecipeOutput getOutputFor(List[] input, boolean adjustInput, boolean inputAffectOutput) {
        return this.getOutputFor(input[0], input[1], adjustInput, inputAffectOutput);
    }

    public UniversalRecipeInput getRecipeInput(List[] input) {
        return this.getRecipeInput(input[0], input[1]);
    }
}

