/*
 * Decompiled with CFR 0.152.
 */
package ihl.tunneling_shield;

import ic2.core.block.RenderBlockDefault;
import ihl.items_blocks.IHLItemBlock;
import ihl.model.IHLModelRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class BlockItemRender
implements IItemRenderer {
    private ModelBase model;
    private ResourceLocation tex;
    private int renderFrom = 0;
    private int renderTo = 0;
    private RenderBlockDefault rbd;
    private float amendment = 0.0f;
    private float inventoryOffset = 0.0f;
    private boolean renderHand;

    public BlockItemRender() {
        this.rbd = new RenderBlockDefault();
    }

    public BlockItemRender(ModelBase model1, ResourceLocation texture, int renderFrom1, int renderTo1, float amendment1, float inventoryOffset1) {
        this.model = model1;
        this.tex = texture;
        this.renderFrom = renderFrom1;
        this.renderTo = renderTo1;
        this.amendment = amendment1;
        this.inventoryOffset = inventoryOffset1;
        this.renderHand = false;
    }

    public BlockItemRender(ModelBase model1, ResourceLocation texture, int renderFrom1, int renderTo1, float amendment1, float inventoryOffset1, boolean renderHand1) {
        this.model = model1;
        this.tex = texture;
        this.renderFrom = renderFrom1;
        this.renderTo = renderTo1;
        this.amendment = amendment1;
        this.inventoryOffset = inventoryOffset1;
        this.renderHand = renderHand1;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                return true;
            }
            case EQUIPPED: {
                return true;
            }
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (this.tex != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.tex);
        }
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        IHLItemBlock bItem = (IHLItemBlock)item.func_77973_b();
        Block block = bItem.getBlockContained();
        GL11.glScalef((float)1.0f, (float)(-1.0f + this.amendment), (float)-1.0f);
        switch (type) {
            case ENTITY: {
                GL11.glTranslatef((float)0.0f, (float)-1.5f, (float)0.0f);
                if (this.model != null) {
                    for (int i = this.renderFrom; i < this.model.field_78092_r.size() - this.renderTo; ++i) {
                        Object piece;
                        if (this.model.field_78092_r.get(i) instanceof ModelRenderer) {
                            piece = (ModelRenderer)this.model.field_78092_r.get(i);
                            piece.func_78785_a(0.0625f);
                            continue;
                        }
                        if (!(this.model.field_78092_r.get(i) instanceof IHLModelRenderer)) continue;
                        piece = (IHLModelRenderer)this.model.field_78092_r.get(i);
                        ((IHLModelRenderer)piece).render(0.0625f);
                    }
                } else {
                    this.rbd.renderInventoryBlock(block, 3, 0, new RenderBlocks());
                }
                GL11.glPopMatrix();
                break;
            }
            case EQUIPPED: {
                GL11.glTranslatef((float)0.25f, (float)-2.0f, (float)-0.75f);
                if (this.model != null) {
                    for (int i = this.renderFrom; i < this.model.field_78092_r.size() - this.renderTo; ++i) {
                        Object piece;
                        if (this.model.field_78092_r.get(i) instanceof ModelRenderer) {
                            piece = (ModelRenderer)this.model.field_78092_r.get(i);
                            piece.func_78785_a(0.0625f);
                            continue;
                        }
                        if (!(this.model.field_78092_r.get(i) instanceof IHLModelRenderer)) continue;
                        piece = (IHLModelRenderer)this.model.field_78092_r.get(i);
                        ((IHLModelRenderer)piece).render(0.0625f);
                    }
                } else {
                    this.rbd.renderInventoryBlock(block, 3, 0, new RenderBlocks());
                }
                GL11.glPopMatrix();
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                if (this.renderHand) {
                    EntityClientPlayerMP var3 = Minecraft.func_71410_x().field_71439_g;
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(var3.func_110306_p());
                    RenderPlayer var25 = (RenderPlayer)RenderManager.field_78727_a.func_78713_a((Entity)Minecraft.func_71410_x().field_71439_g);
                    GL11.glRotatef((float)135.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)35.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    var25.func_82441_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                    GL11.glRotatef((float)-35.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)-135.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(this.tex);
                    GL11.glTranslatef((float)0.0f, (float)0.2f, (float)0.0f);
                }
                GL11.glTranslatef((float)-0.25f, (float)(-2.0f - this.amendment), (float)0.0f);
                if (this.model != null) {
                    for (int i = this.renderFrom; i < this.model.field_78092_r.size() - this.renderTo; ++i) {
                        Object piece;
                        if (this.model.field_78092_r.get(i) instanceof ModelRenderer) {
                            piece = (ModelRenderer)this.model.field_78092_r.get(i);
                            piece.func_78785_a(0.0625f);
                            continue;
                        }
                        if (!(this.model.field_78092_r.get(i) instanceof IHLModelRenderer)) continue;
                        piece = (IHLModelRenderer)this.model.field_78092_r.get(i);
                        ((IHLModelRenderer)piece).render(0.0625f);
                    }
                } else {
                    this.rbd.renderInventoryBlock(block, 3, 0, new RenderBlocks());
                }
                GL11.glPopMatrix();
                break;
            }
            case INVENTORY: {
                GL11.glRotatef((float)15.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)(-1.0f + this.inventoryOffset), (float)0.0f);
                if (this.model != null) {
                    for (int i = this.renderFrom; i < this.model.field_78092_r.size() - this.renderTo; ++i) {
                        Object piece;
                        if (this.model.field_78092_r.get(i) instanceof ModelRenderer) {
                            piece = (ModelRenderer)this.model.field_78092_r.get(i);
                            piece.func_78785_a(0.0625f);
                            continue;
                        }
                        if (!(this.model.field_78092_r.get(i) instanceof IHLModelRenderer)) continue;
                        piece = (IHLModelRenderer)this.model.field_78092_r.get(i);
                        ((IHLModelRenderer)piece).render(0.0625f);
                    }
                } else {
                    this.rbd.renderInventoryBlock(block, 3, 0, new RenderBlocks());
                }
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
                break;
            }
        }
    }
}

