/*
 * Decompiled with CFR 0.152.
 */
package ihl.utils;

import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.Recipes;
import ic2.core.block.invslot.InvSlotOutput;
import ihl.IHLMod;
import ihl.flexible_cable.IWire;
import ihl.processing.invslots.InvSlotConsumableLiquidIHL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.mutable.MutableObject;

public class IHLUtils {
    private static Map<String, ItemStack> ihlItemStackRegistry = new HashMap<String, ItemStack>();

    public static void registerLocally(String name, ItemStack stack) {
        ihlItemStackRegistry.put(name, stack);
    }

    public static ItemStack getOreDictItemStack(String name) {
        ItemStack ore = (ItemStack)OreDictionary.getOres((String)name).get(0);
        if (ore == null) {
            return null;
        }
        ItemStack orecopy = ore.func_77946_l();
        orecopy.field_77994_a = 1;
        return orecopy;
    }

    public static boolean hasOreDictionaryEntry(String name) {
        return !OreDictionary.getOres((String)name).isEmpty();
    }

    public static Item getOreDictItem(String name) {
        return ((ItemStack)OreDictionary.getOres((String)name).get(0)).func_77973_b();
    }

    public static Block getOreDictBlock(String name) {
        return Block.func_149634_a((Item)((ItemStack)OreDictionary.getOres((String)name).get(0)).func_77973_b());
    }

    public static ItemStack getOreDictItemStackWithSize(String name, int size) {
        ItemStack ore = (ItemStack)OreDictionary.getOres((String)name).get(0);
        if (ore == null) {
            return null;
        }
        ItemStack orecopy = ore.func_77946_l();
        orecopy.field_77994_a = size;
        return orecopy;
    }

    public static String getFirstOreDictName(ItemStack stack) {
        int[] arrayIDs = OreDictionary.getOreIDs((ItemStack)stack);
        if (arrayIDs.length > 0) {
            return OreDictionary.getOreName((int)arrayIDs[0]);
        }
        return "";
    }

    public static ItemStack getThisModItemStack(String name) {
        if (ihlItemStackRegistry.get(name) != null) {
            return ihlItemStackRegistry.get(name).func_77946_l();
        }
        if (GameRegistry.findItem((String)"ihl", (String)name) != null) {
            return new ItemStack(GameRegistry.findItem((String)"ihl", (String)name));
        }
        if (GameRegistry.findBlock((String)"ihl", (String)name) == null) {
            throw new IllegalArgumentException("No such item in item registry: ihl:" + name);
        }
        return new ItemStack(GameRegistry.findBlock((String)"ihl", (String)name));
    }

    public static ItemStack getThisModItemStackWithSize(String name, int i) {
        if (ihlItemStackRegistry.get(name) != null) {
            ItemStack stack = ihlItemStackRegistry.get(name).func_77946_l();
            stack.field_77994_a = i;
            return stack;
        }
        if (GameRegistry.findItem((String)"ihl", (String)name) != null) {
            return new ItemStack(GameRegistry.findItem((String)"ihl", (String)name), i);
        }
        if (GameRegistry.findBlock((String)"ihl", (String)name) == null) {
            throw new IllegalArgumentException("No such item in item registry: ihl:" + name);
        }
        return new ItemStack(GameRegistry.findBlock((String)"ihl", (String)name), i);
    }

    public static ItemStack getOtherModItemStackWithDamage(String modname, String name, int damage) {
        if (GameRegistry.findItem((String)modname, (String)name) != null) {
            return new ItemStack(GameRegistry.findItem((String)modname, (String)name), 1, damage);
        }
        if (GameRegistry.findBlock((String)modname, (String)name) == null) {
            return null;
        }
        return new ItemStack(GameRegistry.findBlock((String)modname, (String)name), 1, damage);
    }

    public static Item getThisModItem(String name) {
        if (GameRegistry.findItem((String)"ihl", (String)name) != null) {
            return GameRegistry.findItem((String)"ihl", (String)name);
        }
        if (GameRegistry.findBlock((String)"ihl", (String)name) == null) {
            throw new IllegalArgumentException("No such item in item registry: ihl:" + name);
        }
        return Item.func_150898_a((Block)GameRegistry.findBlock((String)"ihl", (String)name));
    }

    public static FluidStack getFluidStackWithSize(String name, int i) {
        if (FluidRegistry.isFluidRegistered((String)name)) {
            return FluidRegistry.getFluidStack((String)name, (int)i);
        }
        throw new IllegalArgumentException("No such fluid: " + name);
    }

    public static Block getThisModBlock(String name) {
        if (GameRegistry.findBlock((String)"ihl", (String)name) == null) {
            throw new IllegalArgumentException("No such block in item registry: ihl:" + name);
        }
        return GameRegistry.findBlock((String)"ihl", (String)name);
    }

    public static ItemStack getThisModItemStackWithDamage(String name, int value) {
        ItemStack stack = IHLUtils.getThisModItemStack(name);
        stack.func_77964_b(value);
        return stack;
    }

    public static boolean adjustWireLength(ItemStack stack, int adjustBy) {
        int length = IHLUtils.getWireLength(stack);
        if (length <= 0) {
            return true;
        }
        int newLength = Math.max(length + adjustBy, 0);
        stack.field_77990_d.func_74768_a(((IWire)stack.func_77973_b()).getTag(), newLength);
        stack.field_77990_d.func_74768_a(((IWire)stack.func_77973_b()).getTagSecondary(), newLength);
        return newLength == 0;
    }

    public static int getWireLength(ItemStack itemStack) {
        return itemStack.field_77990_d.func_74762_e(((IWire)itemStack.func_77973_b()).getTag());
    }

    public static ItemStack getThisModWireItemStackWithLength(String name, int i) {
        if (IHLUtils.getThisModItemStack(name) != null) {
            ItemStack stack = IHLUtils.getThisModItemStack(name);
            if (stack.func_77973_b() instanceof IWire) {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74768_a(((IWire)stack.func_77973_b()).getTag(), i);
                stack.field_77990_d.func_74768_a(((IWire)stack.func_77973_b()).getTagSecondary(), i);
                return stack;
            }
            throw new IllegalArgumentException("ihl:" + name + " is not an instance of IWire.");
        }
        throw new IllegalArgumentException("No such item in item registry: ihl:" + name);
    }

    public static ItemStack getThisModWireItemStackWithLength(ItemStack stack1, int i) {
        ItemStack stack = stack1.func_77946_l();
        if (stack1.func_77973_b() instanceof IWire) {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74768_a(((IWire)stack.func_77973_b()).getTag(), i);
            stack.field_77990_d.func_74768_a(((IWire)stack.func_77973_b()).getTagSecondary(), i);
            return stack;
        }
        throw new IllegalArgumentException(stack1.func_77977_a() + " is not an instance of IWire.");
    }

    public static boolean isItemsHaveSameOreDictionaryEntry(ItemStack is, ItemStack is1) {
        int[] odids1 = OreDictionary.getOreIDs((ItemStack)is);
        int[] odids2 = OreDictionary.getOreIDs((ItemStack)is1);
        if (odids1 != null && odids1.length > 0 && odids2 != null && odids2.length > 0) {
            for (int i1 = 0; i1 < odids1.length; ++i1) {
                for (int i2 = 0; i2 < odids2.length; ++i2) {
                    if (OreDictionary.getOreName((int)odids1[i1]).contains("Any") || odids1[i1] != odids2[i2]) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static List<ItemStack> getEntryListForOre(String name) {
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        ArrayList oreList = OreDictionary.getOres((String)name);
        Iterator oreListIterator = oreList.iterator();
        while (oreListIterator.hasNext()) {
            outputList.add(((ItemStack)oreListIterator.next()).func_77946_l());
        }
        return outputList;
    }

    public static ItemStack getItemStackIfExist(String name) {
        if (IHLUtils.hasOreDictionaryEntry(name)) {
            return IHLUtils.getOreDictItemStack(name);
        }
        if (ihlItemStackRegistry.get(name) != null) {
            return ihlItemStackRegistry.get(name).func_77946_l();
        }
        if (GameRegistry.findItem((String)"ihl", (String)name) != null) {
            return new ItemStack(GameRegistry.findItem((String)"ihl", (String)name));
        }
        if (GameRegistry.findBlock((String)"ihl", (String)name) == null) {
            return null;
        }
        return new ItemStack(GameRegistry.findBlock((String)"ihl", (String)name));
    }

    public static FluidStack getFluidStackIfExist(String string, int meltingFluidAmount) {
        if (FluidRegistry.isFluidRegistered((String)string)) {
            return IHLUtils.getFluidStackWithSize(string, meltingFluidAmount);
        }
        return null;
    }

    public static boolean addItemStackToInventory(EntityPlayer player, ItemStack stack) {
        ItemStack[] inv = player.field_71071_by.field_70462_a;
        for (int i = 0; i <= 35; ++i) {
            if (inv[i] != null) {
                if (inv[i].func_77973_b() != stack.func_77973_b() || inv[i].func_77960_j() != stack.func_77960_j() || inv[i].field_77994_a >= inv[i].func_77976_d()) continue;
                inv[i].field_77994_a += stack.field_77994_a;
                if (inv[i].field_77994_a > inv[i].func_77976_d()) {
                    stack.field_77994_a = inv[i].field_77994_a - inv[i].func_77976_d();
                    continue;
                }
                return true;
            }
            inv[i] = stack;
            return true;
        }
        return false;
    }

    public static FluidStack getFluidStackWithSizeChemicallyPure(String name, int amount) {
        FluidStack fstack = IHLUtils.getFluidStackWithSize(name, amount);
        fstack.tag = new NBTTagCompound();
        fstack.tag.func_74757_a("chemicallyPure", true);
        return fstack;
    }

    public static void removeItemStackFromOreDictionaryEntry(String orename, ItemStack itemStack) {
        ArrayList orelist = OreDictionary.getOres((String)orename);
        Iterator oreListIterator = orelist.iterator();
        ItemStack odstack = null;
        while (oreListIterator.hasNext() && (odstack = (ItemStack)oreListIterator.next()).func_77973_b() != itemStack.func_77973_b()) {
            odstack = null;
        }
        if (odstack != null) {
            orelist.remove(odstack);
            IHLMod.log.debug("Stack " + odstack.func_82833_r() + " (" + odstack.toString() + ")" + " removed from ore entry '" + orename + "'");
        }
    }

    public static void addIC2MaceratorRecipe(String input, ItemStack output) {
        if (Recipes.macerator.getOutputFor(IHLUtils.getOreDictItemStack(input), false) == null) {
            NBTTagCompound tag = new NBTTagCompound();
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict(input), tag, new ItemStack[]{output});
        }
    }

    public static void addIC2MaceratorRecipe(String input, int stacksize, ItemStack output) {
        if (Recipes.macerator.getOutputFor(IHLUtils.getOreDictItemStackWithSize(input, stacksize), false) == null) {
            NBTTagCompound tag = new NBTTagCompound();
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict(input, stacksize), tag, new ItemStack[]{output});
        }
    }

    public static void addIC2MaceratorRecipe(ItemStack input, ItemStack output) {
        if (Recipes.macerator.getOutputFor(input, false) == null) {
            NBTTagCompound tag = new NBTTagCompound();
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputItemStack(input), tag, new ItemStack[]{output});
        }
    }

    public static void addIC2RollingRecipe(ItemStack input, ItemStack output) {
        if (Recipes.metalformerRolling.getOutputFor(input, false) == null) {
            NBTTagCompound tag = new NBTTagCompound();
            Recipes.metalformerRolling.addRecipe((IRecipeInput)new RecipeInputItemStack(input), tag, new ItemStack[]{output});
        }
    }

    public static void addIC2RollingRecipe(String input, ItemStack output) {
        if (Recipes.metalformerRolling.getOutputFor(IHLUtils.getThisModItemStack(input), false) == null) {
            NBTTagCompound tag = new NBTTagCompound();
            Recipes.metalformerRolling.addRecipe((IRecipeInput)new RecipeInputOreDict(input), tag, new ItemStack[]{output});
        }
    }

    public static void addIC2CentrifugeRecipe(String input, ItemStack output, ItemStack output2) {
        if (Recipes.centrifuge.getOutputFor(IHLUtils.getOreDictItemStack(input), false) == null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("minHeat", 2000);
            Recipes.centrifuge.addRecipe((IRecipeInput)new RecipeInputOreDict(input), tag, new ItemStack[]{output, output2});
        }
    }

    public static void damageItemViaNBTTag(ItemStack stack, int amount) {
        if (!stack.field_77990_d.func_74764_b("GT.ToolStats")) {
            --stack.field_77994_a;
            return;
        }
        NBTTagCompound gtTagCompound = stack.field_77990_d.func_74775_l("GT.ToolStats");
        int damage = 0;
        int maxDamage = 0;
        if (!gtTagCompound.func_74764_b("MaxDamage")) {
            --stack.field_77994_a;
            return;
        }
        maxDamage = gtTagCompound.func_74762_e("MaxDamage");
        if (gtTagCompound.func_74764_b("Damage")) {
            damage = gtTagCompound.func_74762_e("Damage");
        }
        if (damage < maxDamage - amount) {
            gtTagCompound.func_74768_a("Damage", damage += amount);
            gtTagCompound.func_74768_a("MaxDamage", maxDamage);
            stack.field_77990_d.func_74782_a("GT.ToolStats", (NBTBase)gtTagCompound);
        } else {
            --stack.field_77994_a;
        }
    }

    public static int getDamageValueViaNBTTag(ItemStack stack) {
        if (!stack.field_77990_d.func_74764_b("GT.ToolStats")) {
            return 0;
        }
        NBTTagCompound gtTagCompound = stack.field_77990_d.func_74775_l("GT.ToolStats");
        if (gtTagCompound.func_74764_b("Damage")) {
            return gtTagCompound.func_74762_e("Damage");
        }
        return 0;
    }

    public static int getMaxDamageValueViaNBTTag(ItemStack stack) {
        if (!stack.field_77990_d.func_74764_b("GT.ToolStats")) {
            return 0;
        }
        NBTTagCompound gtTagCompound = stack.field_77990_d.func_74775_l("GT.ToolStats");
        if (gtTagCompound.func_74764_b("MaxDamage")) {
            return gtTagCompound.func_74762_e("MaxDamage");
        }
        return 0;
    }

    public static boolean isItemStacksIsEqual(ItemStack stack1, ItemStack stack2, boolean useOreDictionary) {
        if (useOreDictionary && IHLUtils.isItemsHaveSameOreDictionaryEntry(stack1, stack2)) {
            return true;
        }
        if (stack1.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == Short.MAX_VALUE) {
            return stack1.func_77973_b() == stack2.func_77973_b();
        }
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j();
    }

    public static boolean isItemStacksIsEqual(ItemStack stack1, String stack2name, boolean useOreDictionary) {
        return IHLUtils.isItemStacksIsEqual(stack1, IHLUtils.getThisModItemStack(stack2name), useOreDictionary);
    }

    public static boolean isIRecipeInputMatchesWithAmount(IRecipeInput input, ItemStack stack) {
        if (input.matches(stack)) {
            if (stack.func_77973_b() instanceof IWire) {
                return IHLUtils.getWireLength(stack) >= input.getAmount();
            }
            return stack.field_77994_a >= input.getAmount();
        }
        return false;
    }

    public static boolean reduceItemStackAmountUsingIRecipeInput(IRecipeInput input, ItemStack stack) {
        if (stack.func_77973_b() instanceof IWire) {
            return IHLUtils.adjustWireLength(stack, -input.getAmount());
        }
        stack.field_77994_a -= input.getAmount();
        return stack.field_77994_a <= 0;
    }

    public static String getFirstOreDictNameExcludingTagAny(ItemStack stack) {
        int[] arrayIDs = OreDictionary.getOreIDs((ItemStack)stack);
        for (int i = 0; i < arrayIDs.length; ++i) {
            if (OreDictionary.getOreName((int)arrayIDs[i]).contains("Any")) continue;
            return OreDictionary.getOreName((int)arrayIDs[i]);
        }
        return "";
    }

    public static void handleFluidSlotsBehaviour(InvSlotConsumableLiquidIHL fillInputSlot, InvSlotConsumableLiquidIHL drainInputSlot, InvSlotOutput emptyFluidItemsSlot, IFluidTank fluidTank) {
        MutableObject output;
        if (drainInputSlot != null && !drainInputSlot.isEmpty()) {
            output = new MutableObject();
            if (fluidTank.fill(drainInputSlot.drain(null, fluidTank.getCapacity() - fluidTank.getFluidAmount(), (MutableObject<ItemStack>)output, true), false) > 0 && (output.getValue() == null || emptyFluidItemsSlot.canAdd((ItemStack)output.getValue()))) {
                fluidTank.fill(drainInputSlot.drain(null, fluidTank.getCapacity() - fluidTank.getFluidAmount(), (MutableObject<ItemStack>)output, false), true);
                if (output.getValue() != null) {
                    emptyFluidItemsSlot.add((ItemStack)output.getValue());
                }
            }
        }
        if (fillInputSlot != null && !fillInputSlot.isEmpty() && fillInputSlot.transferFromTank(fluidTank, output = new MutableObject(), true) && (output.getValue() == null || emptyFluidItemsSlot.canAdd((ItemStack)output.getValue()))) {
            fillInputSlot.transferFromTank(fluidTank, output, false);
            if (output.getValue() != null) {
                emptyFluidItemsSlot.add((ItemStack)output.getValue());
            }
        }
    }
}

