/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.usefulcrops.crops;

import com.estebes.usefulcrops.reference.Reference;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import ic2.api.item.IC2Items;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.oredict.OreDictionary;

public class CropCopper
extends CropCard {
    public ItemStack mDrop;

    public String owner() {
        return "IC2";
    }

    public String displayName() {
        return "Cyprium";
    }

    public String discoveredBy() {
        return "estebes";
    }

    public String name() {
        return "\u0441yprium";
    }

    public int tier() {
        return 6;
    }

    public int stat(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    public String[] attributes() {
        return new String[]{"Leaves", "Metal"};
    }

    public int maxSize() {
        return 4;
    }

    public boolean canGrow(ICropTile crop) {
        return crop.getSize() == 3 && this.checkBelow(crop) || crop.getSize() < 3;
    }

    public int getrootslength(ICropTile crop) {
        return 3;
    }

    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() == 4;
    }

    public int getOptimalHavestSize(ICropTile crop) {
        return 4;
    }

    public ItemStack getGain(ICropTile crop) {
        if (this.mDrop == null) {
            this.mDrop = IC2Items.getItem((String)"smallCopperDust").func_77946_l();
        }
        return this.mDrop.func_77946_l();
    }

    public float dropGainChance() {
        return super.dropGainChance() / 2.0f;
    }

    public int growthDuration(ICropTile crop) {
        return crop.getSize() == 3 ? 2000 : 800;
    }

    public byte getSizeAfterHarvest(ICropTile crop) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSprites(IIconRegister iconRegister) {
        this.textures = new IIcon[this.maxSize()];
        for (int i = 1; i <= this.textures.length; ++i) {
            this.textures[i - 1] = iconRegister.func_94245_a(Reference.LOWERCASE_MOD_ID + ":" + "copper" + i);
        }
    }

    private boolean checkBelow(ICropTile crop) {
        if (crop == null) {
            return false;
        }
        for (int i = 1; i < this.getrootslength(crop); ++i) {
            TileEntity teCrop = (TileEntity)crop;
            Block block = teCrop.func_145831_w().func_147439_a(teCrop.field_145851_c, teCrop.field_145848_d - i, teCrop.field_145849_e);
            int metaData = block.func_149643_k(teCrop.func_145831_w(), teCrop.field_145851_c, teCrop.field_145848_d - i, teCrop.field_145849_e);
            if (block.isAir((IBlockAccess)teCrop.func_145831_w(), teCrop.field_145851_c, teCrop.field_145848_d - i, teCrop.field_145849_e)) {
                return false;
            }
            for (ItemStack itemStack : OreDictionary.getOres((String)"oreCopper")) {
                if (Item.func_150898_a((Block)block) != itemStack.func_77973_b() || metaData != itemStack.func_77960_j()) continue;
                return true;
            }
            for (ItemStack itemStack : OreDictionary.getOres((String)"blockCopper")) {
                if (Item.func_150898_a((Block)block) != itemStack.func_77973_b() || metaData != itemStack.func_77960_j()) continue;
                return true;
            }
        }
        return false;
    }
}

